/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.pathmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbTextHost;
import ro.amiq.dvt.ui.editor.pathmanager.DPMNotificationJob;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProviderCommon;
import ro.amiq.dvt.ui.editor.pathmanager.RegionTreeCommon;
import ro.amiq.dvt.ui.editor.pathmanager.RegionTreeNode;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

class RegionTree
extends RegionTreeCommon {
    private IDVTFileInstance fileInstance;
    private boolean isDeprecatedFileInstance;
    private ElementPath pathFromInclude;
    private IEditorInput editorInput;

    public RegionTree(IDVTBreadcrumbTextHost editor) {
        super(editor);
        this.editorInput = editor.getEditorInput();
    }

    @Override
    protected boolean computeAndPopulateRegionTree() {
        HashSet<RegionTreeNode> visited;
        LinkedHashSet<IRfNamedElement> topBindings;
        IFile file;
        IProgressMonitor monitor;
        block29: {
            block28: {
                boolean fileInstanceChanged;
                block27: {
                    IRfDefElement rootDef;
                    Collection<?> rfChildren;
                    block26: {
                        IDocument document;
                        IRfFileDef fileDef;
                        block25: {
                            IDesignPathProvider designPathProvider;
                            IProject project;
                            block24: {
                                block23: {
                                    DVTEditor editor;
                                    block22: {
                                        block21: {
                                            block20: {
                                                block19: {
                                                    block18: {
                                                        IDVTBreadcrumbTextHost bcHost;
                                                        block17: {
                                                            try {
                                                                Job currentJob = Job.getJobManager().currentJob();
                                                                monitor = currentJob instanceof DPMNotificationJob ? ((DPMNotificationJob)currentJob).getMonitor() : null;
                                                                bcHost = this.getBcHost();
                                                                if (bcHost instanceof DVTEditor) break block17;
                                                                ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
                                                                return false;
                                                            }
                                                            catch (Exception e) {
                                                                DVTLogger.INSTANCE.logError((Throwable)e);
                                                                return false;
                                                            }
                                                        }
                                                        editor = (DVTEditor)bcHost;
                                                        this.editorInput = editor.getEditorInput();
                                                        file = editor.getCurrentFile();
                                                        if (file != null) break block18;
                                                        ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
                                                        return false;
                                                    }
                                                    project = file.getProject();
                                                    if (project != null) break block19;
                                                    ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
                                                    return false;
                                                }
                                                designPathProvider = this.getDesignPathProvider();
                                                if (designPathProvider != null) break block20;
                                                ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
                                                return false;
                                            }
                                            if (DVTPlugin.getDefault().collect().c(project, designPathProvider.getLangNature())) break block21;
                                            ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
                                            return false;
                                        }
                                        fileDef = designPathProvider.getFileDef(project, file);
                                        if (fileDef != null) break block22;
                                        ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
                                        return false;
                                    }
                                    document = editor.getDocument();
                                    if (document != null) break block23;
                                    ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
                                    return false;
                                }
                                if (monitor == null || !monitor.isCanceled()) break block24;
                                return false;
                            }
                            fileInstanceChanged = this.updateFileInstance(project, file, fileDef);
                            rfChildren = fileDef.getChildren();
                            this.pathFromInclude = designPathProvider.getPathFromIncludeScope(file, true);
                            if (this.pathFromInclude == null && this.fileInstance != null) {
                                this.pathFromInclude = designPathProvider.getFirstPathFor(designPathProvider.getScopeFromFileInstance(this.fileInstance), project);
                            }
                            if (rfChildren != null) break block25;
                            this.setDirty(false);
                            ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
                            return true;
                        }
                        rootDef = this.getRootDef(fileDef);
                        this.createRoot(document, rootDef, fileDef);
                        this.initializePaths();
                        this.initializeNodes();
                        if (monitor == null || !monitor.isCanceled()) break block26;
                        this.internalClean();
                        return false;
                    }
                    ArrayList children = new ArrayList(rfChildren);
                    children.add(rootDef);
                    topBindings = new LinkedHashSet<IRfNamedElement>();
                    if (this.buildActualTree(children, this.getRoot(), topBindings, monitor)) break block27;
                    return false;
                }
                this.setDirty(false);
                visited = new HashSet();
                if (!fileInstanceChanged) {
                    visited = this.preserveOldPaths(topBindings, monitor);
                }
                if (monitor == null || !monitor.isCanceled()) break block28;
                this.internalClean();
                return false;
            }
            if (!topBindings.isEmpty() || !this.hasPaths()) break block29;
            ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
            return true;
        }
        this.findAndAssociateNewPaths(file, topBindings, visited, monitor);
        ObjectionManager.getInstance().clear(Objection.DESIGN_PATH_MANAGER_READY);
        return true;
    }

    private IRfDefElement getRootDef(IRfFileDef fileDef) {
        if (this.pathFromInclude == null) {
            return fileDef instanceof IRfDefElement ? (IRfDefElement)((Object)fileDef) : null;
        }
        IProject project = this.getProject();
        if (project == null) {
            return null;
        }
        IELMemory elMemory = RfMixedLangManager.getInstance().getELMemory(project);
        if (elMemory == null) {
            return null;
        }
        ELInstance instanceFor = elMemory.instanceFor(this.pathFromInclude);
        if (instanceFor == null) {
            return null;
        }
        IRfNamedElement binding = instanceFor.getBinding(false);
        if (binding == null) {
            return null;
        }
        return binding.getDeclaration();
    }

    private void findAndAssociateNewPaths(IFile file, Set<IRfNamedElement> topBindings, Set<RegionTreeNode> visited, IProgressMonitor monitor) {
        try {
            IDesignPathProvider pathProvider = this.getDesignPathProvider();
            if (pathProvider == null) {
                return;
            }
            Map<IRfDefElement, ElementPath> paths = this.getPaths();
            IRfNamedElement scopeFromFileInstance = pathProvider.getScopeFromFileInstance(this.fileInstance);
            ElementPath pathFromIncludeScope = pathProvider.getPathFromIncludeScope(file, true);
            if (scopeFromFileInstance != null && pathFromIncludeScope != null) {
                topBindings.remove(scopeFromFileInstance);
                paths.put(scopeFromFileInstance.getDeclaration(), pathFromIncludeScope);
            } else if (scopeFromFileInstance != null) {
                topBindings.add(scopeFromFileInstance);
            }
            if (monitor != null && monitor.isCanceled()) {
                this.internalClean();
                return;
            }
            pathProvider.populateInstanceMap(paths, topBindings, this.pathFromInclude, this.getProject());
            if (monitor != null && monitor.isCanceled()) {
                this.internalClean();
                return;
            }
            if (this.pathFromInclude == null) {
                this.pathFromInclude = pathFromIncludeScope;
            }
            if (this.pathFromInclude == null && scopeFromFileInstance != null) {
                this.pathFromInclude = paths.get(scopeFromFileInstance.getDeclaration());
            }
            for (IRfNamedElement topElement : topBindings) {
                IRfDefElement topDeclaration;
                if (monitor != null && monitor.isCanceled()) {
                    this.internalClean();
                    return;
                }
                if (topElement == null || (topDeclaration = topElement.getDeclaration()) == null || visited.contains(this.getNode(topDeclaration))) continue;
                HashSet<RegionTreeNode> tempVisited = new HashSet<RegionTreeNode>();
                this.addElementPath(topDeclaration, paths.get(topDeclaration), tempVisited, true, monitor);
            }
            IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.getProject());
            if (memory == null) {
                return;
            }
            if (monitor != null && monitor.isCanceled()) {
                this.internalClean();
                return;
            }
            this.getLeafPaths().entrySet().removeIf(e -> memory.instanceFor((ElementPath)e.getValue()) == null);
            if (monitor != null && monitor.isCanceled()) {
                this.internalClean();
                return;
            }
            if (this.fileInstance != null && this.fileInstance.isValid()) {
                this.getLeafPaths().entrySet().removeIf(e -> !this.fileInstance.isInstanceInScope(memory.instanceFor((ElementPath)e.getValue()).getDescription()));
            } else {
                this.fileInstance = null;
            }
        }
        catch (Exception e2) {
            DVTLogger.INSTANCE.logError((Throwable)e2);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean updateFileInstance(IProject project, IFile file, IRfFileDef fileDef) {
        try {
            if (project == null || file == null || fileDef == null) {
                return false;
            }
            IDesignPathProvider pathProvider = this.getDesignPathProvider();
            if (pathProvider == null) {
                return false;
            }
            boolean fileInstanceChanged = false;
            if (this.fileInstance == null) {
                this.fileInstance = pathProvider.getFileInstance(file, true);
                fileInstanceChanged = !this.isDeprecatedFileInstance;
            } else if (!this.fileInstance.isValid()) {
                List<? extends IDVTFileInstance> fileInstances = RfMixedLangManager.getInstance().getFileInstances(project, fileDef.getParserPath());
                if (fileInstances == null || fileInstances.isEmpty()) {
                    return false;
                }
                for (IDVTFileInstance iDVTFileInstance : fileInstances) {
                    if (iDVTFileInstance.getIndex() != this.fileInstance.getIndex()) continue;
                    this.fileInstance = iDVTFileInstance;
                    break;
                }
                if (!this.fileInstance.isValid()) {
                    this.fileInstance = fileInstances.get(0);
                }
            } else {
                IDVTFileInstance fileInstanceCandidate = pathProvider.getFileInstance(file, false);
                if (fileInstanceCandidate != null && fileInstanceCandidate.isValid() && fileInstanceCandidate != this.fileInstance) {
                    this.fileInstance = fileInstanceCandidate;
                    fileInstanceChanged = true;
                }
            }
            file.setSessionProperty(IDVTConstants.FILE_INSTANCE_QN, null);
            return fileInstanceChanged;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean buildActualTree(Collection<?> children, RegionTreeNode parent, Set<IRfNamedElement> bindingsToFind, IProgressMonitor monitor) {
        try {
            if (children == null) return true;
            if (children.isEmpty()) {
                return true;
            }
            IDesignPathProvider designPathProvider = this.getDesignPathProvider();
            if (designPathProvider == null) {
                return false;
            }
            if (monitor != null && monitor.isCanceled()) {
                this.internalClean();
                return false;
            }
            Iterator<?> iterator = children.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                Object child = iterator.next();
                if (monitor != null && monitor.isCanceled()) {
                    this.internalClean();
                    return false;
                }
                if (!(child instanceof IRfDefElement) || !designPathProvider.validDesignScope(child)) continue;
                IRfDefElement childDef = (IRfDefElement)child;
                if (monitor != null && monitor.isCanceled()) {
                    this.internalClean();
                    return false;
                }
                RegionTreeNode childNode = RegionTreeNode.getChildNode(parent, childDef);
                parent.addChild(childNode);
                this.addNode(childDef, childNode);
                if (this.isRoot(parent) && bindingsToFind != null) {
                    bindingsToFind.add(designPathProvider.getBindingInScope(childDef, this.fileInstance));
                }
                if (monitor != null && monitor.isCanceled()) {
                    this.internalClean();
                    return false;
                }
                Collection<?> childrenDefs = childDef.getChildren();
                if (childrenDefs != null && !this.buildActualTree(childrenDefs, childNode, bindingsToFind, monitor)) break;
            }
            return false;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Set<RegionTreeNode> preserveOldPaths(Set<IRfNamedElement> topBindings, IProgressMonitor monitor) {
        HashSet<RegionTreeNode> visited = new HashSet<RegionTreeNode>();
        try {
            IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.getProject());
            if (memory == null) {
                return visited;
            }
            LinkedHashMap<RegionTreeNode, ElementPath> newLeafPaths = new LinkedHashMap<RegionTreeNode, ElementPath>();
            for (Map.Entry<RegionTreeNode, ElementPath> entry : this.getLeafPaths().entrySet()) {
                IRfDefElement def;
                IRfNamedElement binding;
                if (monitor != null && monitor.isCanceled()) {
                    this.internalClean();
                    return null;
                }
                ElementPath oldLeafPath = entry.getValue();
                ELInstance instance = memory.instanceFor(oldLeafPath);
                if (instance == null || (binding = instance.getBinding(entry.getKey().isStripToEntity())) == null || (def = binding.getDeclaration()) == null) continue;
                boolean hasSamePath = this.hasSamePath(oldLeafPath, def);
                if (this.hasNodeFor(def) && !hasSamePath) {
                    this.addElementPath(def, oldLeafPath, visited, false, monitor);
                    newLeafPaths.put(this.getNode(def), oldLeafPath);
                }
                if (!hasSamePath) continue;
                visited.add(this.getNode(def));
            }
            this.setLeafPaths(newLeafPaths);
            Iterator<IRfNamedElement> it = topBindings.iterator();
            while (it.hasNext()) {
                IRfDefElement bindingDeclaration;
                if (monitor != null && monitor.isCanceled()) {
                    this.internalClean();
                    return null;
                }
                IRfNamedElement topBinding = it.next();
                if (topBinding == null || (bindingDeclaration = topBinding.getDeclaration()) == null || !visited.contains(this.getNode(bindingDeclaration))) continue;
                it.remove();
            }
            if (!topBindings.isEmpty()) {
                return visited;
            }
            if (monitor != null && monitor.isCanceled()) {
                this.internalClean();
                return null;
            }
            IDesignPathProvider designPathProvider = this.getDesignPathProvider();
            if (designPathProvider == null) {
                return visited;
            }
            IDVTBreadcrumbTextHost bcHost = this.getBcHost();
            if (!(bcHost instanceof DVTEditor)) {
                return visited;
            }
            DVTEditor editor = (DVTEditor)bcHost;
            RegionTreeNode root = this.getRoot();
            if (root == null) {
                return visited;
            }
            IRfDefElement rootDef = root.getAssociatedDef();
            if (rootDef == null) {
                return visited;
            }
            if (memory.hasInstanceFor(this.pathFromInclude, 1)) {
                this.addPath(rootDef, this.pathFromInclude);
                return visited;
            }
            this.pathFromInclude = editor.getDesignPathProvider().getPathFromIncludeScope(editor.getCurrentFile(), true);
            if (this.pathFromInclude != null) {
                this.addPath(rootDef, this.pathFromInclude);
            }
            return visited;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return visited;
        }
    }

    @Override
    protected void addElementPath(IRfDefElement def, ElementPath path, Set<RegionTreeNode> visited, boolean computeLeafs, IProgressMonitor monitor) {
        try {
            if (this.getPaths() == null || path == null || visited == null) {
                return;
            }
            RegionTreeNode node = this.getNode(def);
            if (node == null) {
                return;
            }
            path = path.toElaborationForm();
            this.addPath(def, path);
            visited.add(node);
            if (monitor != null && monitor.isCanceled()) {
                this.internalClean();
                return;
            }
            if (node.isValidLeaf(this.getDesignPathProvider()) && computeLeafs) {
                this.addLeafPath(node, path);
            }
            for (RegionTreeNode child : node.getChildren()) {
                if (monitor != null && monitor.isCanceled()) {
                    this.internalClean();
                    return;
                }
                this.computeSubtreeFromPath(path, visited, child, false, computeLeafs, monitor);
            }
            ElementPath newPath = path == null ? null : path.removeLastSegment();
            this.computeSubtreeFromPath(newPath, visited, node.getParent(), true, computeLeafs, monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean computeSubtreeFromPath(ElementPath prefix, Set<RegionTreeNode> visited, RegionTreeNode current, boolean keepPrefix, boolean computeLeafs, IProgressMonitor monitor) {
        try {
            if (current == null || this.isRoot(current) || this.getPaths() == null) {
                return true;
            }
            IDesignPathProvider designPathProvider = this.getDesignPathProvider();
            if (designPathProvider == null) {
                return true;
            }
            if (visited.contains(current)) {
                return true;
            }
            visited.add(current);
            IRfDefElement associatedDef = current.getAssociatedDef();
            if (associatedDef == null) {
                return false;
            }
            ElementPath tempPrefix = null;
            if (!keepPrefix && prefix != null) {
                IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.getProject());
                if (memory == null) {
                    return false;
                }
                for (IRfNamedElement namedElement : designPathProvider.getNamedElementsSet(associatedDef)) {
                    if (monitor != null && monitor.isCanceled()) {
                        this.internalClean();
                        return false;
                    }
                    tempPrefix = IDesignPathProviderCommon.getPathPrefixedBy(memory, prefix, namedElement, true);
                    if (tempPrefix == null) continue;
                }
                prefix = tempPrefix;
            }
            this.addPath(associatedDef, prefix);
            if (prefix != null && computeLeafs && current.isValidLeaf(designPathProvider)) {
                this.addLeafPath(current, prefix);
            }
            if (monitor != null && monitor.isCanceled()) {
                this.internalClean();
                return false;
            }
            if (prefix == null) {
                this.markUnelabSubtreeFor(current, computeLeafs);
            }
            if (monitor != null && monitor.isCanceled()) {
                this.internalClean();
                return false;
            }
            Iterator<RegionTreeNode> iterator = current.getChildren().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    if (monitor == null || !monitor.isCanceled()) break;
                    this.internalClean();
                    return false;
                }
                RegionTreeNode child = iterator.next();
                this.computeSubtreeFromPath(prefix, visited, child, false, computeLeafs, monitor);
            }
            ElementPath newPrefix = prefix == null ? null : prefix.removeLastSegment();
            return this.computeSubtreeFromPath(newPrefix, visited, current.getParent(), true, computeLeafs, monitor);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return false;
        }
    }

    @Override
    public synchronized void updateFor(ElementPath path) {
        try {
            super.updateFor(path);
            this.isDeprecatedFileInstance = true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public ElementPath getPathFromScope() {
        return this.pathFromInclude;
    }

    public synchronized IRfNamedElement getElementFor(int offset) {
        if (!(this.hasPaths() && !this.isDirty() || this.computeAndPopulateRegionTree())) {
            return null;
        }
        IDesignPathProvider designPathProvider = this.getDesignPathProvider();
        if (designPathProvider == null) {
            return null;
        }
        RegionTreeNode root = this.getRoot();
        if (root == null) {
            return null;
        }
        RegionTreeNode node = this.getNodeAtOffset(root, offset);
        if (node == null) {
            return null;
        }
        boolean rootHasChildren = root.hasChildren();
        if (!this.isRoot(node) || !rootHasChildren) {
            return designPathProvider.getBindingInScope(this.getNodeAssociatedDef(node, false), this.fileInstance);
        }
        List<RegionTreeNode> rootChildren = root.getChildren();
        RegionTreeNode firstChild = rootChildren.get(0);
        if (firstChild == null) {
            return null;
        }
        if (offset <= firstChild.getOffset()) {
            return designPathProvider.getBindingInScope(this.getNodeAssociatedDef(firstChild, false), this.fileInstance);
        }
        if (rootChildren.size() == 1) {
            return designPathProvider.getBindingInScope(this.getNodeAssociatedDef(firstChild, false), this.fileInstance);
        }
        return designPathProvider.getBindingInScope(node.getAssociatedDef(), this.fileInstance);
    }

    public IDVTFileInstance getFileInstance() {
        return this.fileInstance;
    }

    public IEditorInput getCachedEditorInput() {
        return this.editorInput;
    }

    @Override
    public synchronized void clean() {
        IDVTBreadcrumbTextHost bcHost = this.getBcHost();
        if (bcHost instanceof DVTEditor) {
            IFile file = ((DVTEditor)bcHost).getCurrentFile();
            try {
                file.setSessionProperty(IDVTConstants.INHIBIT_DPM_UPDATE_QN, null);
            }
            catch (CoreException coreException) {}
        }
        super.clean();
        this.fileInstance = null;
    }

    @Override
    protected void internalClean() {
        super.internalClean();
        this.pathFromInclude = null;
    }
}

