/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.pathmanager;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbTextHost;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProviderCommon;
import ro.amiq.dvt.ui.editor.pathmanager.RegionTreeNode;

public abstract class RegionTreeCommon {
    private IDVTBreadcrumbTextHost bcHost;
    private RegionTreeNode root;
    private Map<IRfDefElement, ElementPath> paths;
    private Map<IRfDefElement, RegionTreeNode> nodes;
    private Map<RegionTreeNode, ElementPath> leafPaths;
    private volatile boolean isDirty;

    protected RegionTreeCommon(IDVTBreadcrumbTextHost bcHost) {
        this.bcHost = bcHost;
        this.paths = new LinkedHashMap<IRfDefElement, ElementPath>(1);
        this.leafPaths = new LinkedHashMap<RegionTreeNode, ElementPath>(1);
    }

    protected IDVTBreadcrumbTextHost getBcHost() {
        return this.bcHost;
    }

    protected IDesignPathProvider getDesignPathProvider() {
        return this.bcHost != null ? this.bcHost.getDesignPathProvider() : null;
    }

    protected IProject getProject() {
        return this.bcHost != null ? this.bcHost.getProject() : null;
    }

    protected void createRoot(IDocument document, IRfDefElement defElem, IRfFileDef fileDef) {
        this.root = RegionTreeNode.createRoot(document, defElem, fileDef);
    }

    protected RegionTreeNode getRoot() {
        return this.root;
    }

    protected boolean isRoot(RegionTreeNode node) {
        return node == this.root;
    }

    protected boolean isRootFromInclude(RegionTreeNode node) {
        if (!this.isRoot(node)) {
            return false;
        }
        IRfDefElement associatedDef = node.getAssociatedDef();
        return associatedDef != null && !(associatedDef instanceof IRfFileDef);
    }

    private boolean isNodeInIncludingFileChain(RegionTreeNode node) {
        return node.getFileDef() != null;
    }

    protected void initializePaths() {
        this.paths = new LinkedHashMap<IRfDefElement, ElementPath>();
    }

    protected boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    protected Map<IRfDefElement, ElementPath> getPaths() {
        return this.paths;
    }

    public void updateFor(ElementPath path) {
        if (path == null) {
            return;
        }
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.getProject());
        if (memory == null) {
            return;
        }
        ELInstance instance = memory.instanceFor(path = path.toElaborationForm());
        if (instance == null) {
            return;
        }
        if ((this.getPaths() == null || this.isDirty()) && !this.computeAndPopulateRegionTree()) {
            return;
        }
        IRfDefElement entDef = instance.getBinding(true).getDeclaration();
        IRfDefElement archDef = instance.getBinding(false).getDeclaration();
        if (entDef == null && archDef == null) {
            return;
        }
        if (this.hasPathFor(entDef) && !this.hasSamePath(path, entDef)) {
            this.addElementPath(entDef, path, new HashSet<RegionTreeNode>(), true, null);
        }
        if (this.hasPathFor(archDef) && !this.hasSamePath(path, archDef)) {
            this.addElementPath(archDef, path, new HashSet<RegionTreeNode>(), true, null);
        }
    }

    protected void addPath(IRfDefElement defElem, ElementPath path) {
        this.paths.put(defElem, path);
    }

    protected boolean hasSamePath(ElementPath path, IRfDefElement defElem) {
        if (path == null || this.paths == null) {
            return false;
        }
        return path.equals(this.paths.get(defElem));
    }

    protected boolean hasPathFor(IRfDefElement defElem) {
        return this.paths != null ? this.paths.containsKey(defElem) : false;
    }

    protected ElementPath getPathFor(IRfDefElement defElement) {
        return this.paths.get(defElement);
    }

    protected void initializeNodes() {
        this.nodes = new HashMap<IRfDefElement, RegionTreeNode>();
    }

    protected RegionTreeNode getNode(IRfDefElement defElem) {
        return this.nodes.get(defElem);
    }

    protected void addNode(IRfDefElement defElem, RegionTreeNode node) {
        this.nodes.put(defElem, node);
    }

    protected boolean hasNodeFor(IRfDefElement defElem) {
        return this.nodes.containsKey(defElem);
    }

    protected Map<RegionTreeNode, ElementPath> getLeafPaths() {
        return this.leafPaths;
    }

    protected void setLeafPaths(Map<RegionTreeNode, ElementPath> paths) {
        this.leafPaths = paths;
    }

    protected void addLeafPath(RegionTreeNode node, ElementPath path) {
        this.leafPaths.put(node, path);
    }

    protected void removeLeafPath(RegionTreeNode node) {
        this.leafPaths.remove(node);
    }

    public synchronized IRegion getRegion(int offset) {
        RegionTreeNode current = this.getNodeAtOffset(this.root, offset);
        return current != null && current != this.root ? current.getAssociatedRegion() : null;
    }

    protected RegionTreeNode getNodeAtOffset(RegionTreeNode startNode, int offset) {
        if (startNode == null) {
            return null;
        }
        if (!startNode.hasChildren()) {
            return startNode;
        }
        for (RegionTreeNode child : startNode.getChildren()) {
            if (!child.contains(offset)) continue;
            return this.getNodeAtOffset(child, offset);
        }
        return startNode;
    }

    protected void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    protected boolean isDirty() {
        return this.isDirty;
    }

    protected ElementPath getNodePath(int offset, RegionTreeNode node, boolean appendInstanceScope) {
        boolean rootHasChildren = this.root.hasChildren();
        if (!this.isRoot(node) || !rootHasChildren) {
            return this.internalGetPath(node, appendInstanceScope);
        }
        List<RegionTreeNode> rootChildren = this.root.getChildren();
        RegionTreeNode firstChild = rootChildren.get(0);
        if (firstChild == null) {
            return null;
        }
        if (offset <= firstChild.getOffset()) {
            return this.internalGetPath(firstChild, appendInstanceScope);
        }
        if (rootChildren.size() == 1) {
            return this.internalGetPath(firstChild, appendInstanceScope);
        }
        return this.internalGetPath(node, appendInstanceScope);
    }

    private ElementPath internalGetPath(RegionTreeNode node, boolean appendInstanceScope) {
        IRfDefElement defToSearch = this.getNodeAssociatedDef(node, appendInstanceScope);
        if (defToSearch == null) {
            return null;
        }
        ElementPath elementPath = this.paths.get(defToSearch);
        if (elementPath == null) {
            return null;
        }
        return elementPath;
    }

    protected IRfDefElement getNodeAssociatedDef(RegionTreeNode node, boolean appendInstanceScope) {
        if (node == null) {
            return null;
        }
        IDesignPathProvider designPathProvider = this.getDesignPathProvider();
        if (designPathProvider == null) {
            return null;
        }
        IRfDefElement nodeAssocDef = node.getAssociatedDef();
        if (appendInstanceScope) {
            return nodeAssocDef;
        }
        if (!designPathProvider.isInstanceDef(nodeAssocDef)) {
            return nodeAssocDef;
        }
        RegionTreeNode parent = node.getParent();
        if (parent == null) {
            return null;
        }
        return parent.getAssociatedDef();
    }

    protected void markUnelabSubtreeFor(RegionTreeNode current, boolean computeLeafs) {
        if (current == null) {
            return;
        }
        this.addPath(current.getAssociatedDef(), null);
        if (current.isValidLeaf(this.getDesignPathProvider()) && computeLeafs) {
            this.removeLeafPath(current);
        }
        if (current.getChildren() == null) {
            return;
        }
        for (RegionTreeNode child : current.getChildren()) {
            this.markUnelabSubtreeFor(child, computeLeafs);
        }
    }

    public synchronized ElementPath getPathFromOffset(int offset, boolean parentIfNotElab, boolean appendInstanceScope) {
        RegionTreeNode instanceNode;
        if (this.shouldRecompute() && !this.computeAndPopulateRegionTree()) {
            return null;
        }
        RegionTreeNode node = this.getNodeAtOffset(this.getRoot(), offset);
        if (node == null) {
            return null;
        }
        IDesignPathProvider designPathProvider = this.getDesignPathProvider();
        if (designPathProvider == null) {
            return null;
        }
        if (this.isRoot(node) && !this.isRootFromInclude(node) || designPathProvider.isInstanceDef(node.getAssociatedDef()) && appendInstanceScope) {
            return this.getNodePath(offset, node, appendInstanceScope);
        }
        IRfDefElement nodeDef = node.getAssociatedDef();
        if (nodeDef == null) {
            return null;
        }
        if (appendInstanceScope && (instanceNode = this.getInstanceNodeChild(node, offset, designPathProvider)) != null) {
            this.addNode(instanceNode.getAssociatedDef(), instanceNode);
            this.associateInstancePath(instanceNode);
            node = instanceNode;
        }
        if (!parentIfNotElab) {
            return this.getNodePath(offset, node, appendInstanceScope);
        }
        IRfDefElement associatedDef = node.getAssociatedDef();
        while (!this.isElaborated(associatedDef) && node.getParent() != null) {
            node = node.getParent();
            associatedDef = node.getAssociatedDef();
        }
        return this.getNodePath(offset, node, appendInstanceScope);
    }

    protected boolean shouldRecompute() {
        return !this.hasPaths() || this.isDirty();
    }

    protected RegionTreeNode getInstanceNodeChild(RegionTreeNode parentNode, int offset, IDesignPathProvider designPathProvider) {
        return parentNode.computeInstanceChildNode(offset, designPathProvider, this.isNodeInIncludingFileChain(parentNode) ? this.internalGetPath(parentNode, false) : null);
    }

    protected void associateInstancePath(RegionTreeNode node) {
        IDesignPathProvider designPathProvider = this.getDesignPathProvider();
        if (designPathProvider == null) {
            return;
        }
        if (node == null || !designPathProvider.isInstanceDef(node.getAssociatedDef())) {
            return;
        }
        IELMemory memory = RfMixedLangManager.getInstance().getELMemory(this.getProject());
        if (memory == null) {
            return;
        }
        RegionTreeNode parentNode = node.getParent();
        if (parentNode == null || this.isRoot(parentNode) && !this.isRootFromInclude(parentNode)) {
            return;
        }
        ElementPath prefix = this.getPathFor(parentNode.getAssociatedDef());
        if (prefix == null) {
            return;
        }
        ElementPath instancePath = null;
        for (IRfNamedElement namedElement : designPathProvider.getNamedElementsSet(node.getAssociatedDef())) {
            instancePath = IDesignPathProviderCommon.getPathPrefixedBy(memory, prefix, namedElement, true);
            if (instancePath != null) break;
        }
        this.addPath(node.getAssociatedDef(), instancePath);
    }

    protected boolean isElaborated(IRfDefElement associatedDef) {
        return this.getPathFor(associatedDef) != null;
    }

    public boolean hasDesignElements() {
        return this.root != null && this.root.hasChildren();
    }

    public boolean hasElaboratedDesignElements() {
        if (this.root == null || !this.root.hasChildren()) {
            return false;
        }
        for (RegionTreeNode child : this.root.getChildren()) {
            if (this.paths.get(child.getAssociatedDef()) == null) continue;
            return true;
        }
        return false;
    }

    public synchronized void clean() {
        this.bcHost = null;
        this.root = null;
        this.paths = null;
        this.nodes = null;
        this.leafPaths = null;
    }

    protected void internalClean() {
        this.isDirty = true;
        this.root = null;
        this.paths = new LinkedHashMap<IRfDefElement, ElementPath>(1);
        this.leafPaths = new LinkedHashMap<RegionTreeNode, ElementPath>(1);
        this.nodes = null;
    }

    public synchronized Collection<ElementPath> testGetAllPaths() {
        if (this.paths == null || this.paths.isEmpty() || this.isDirty) {
            this.computeAndPopulateRegionTree();
        }
        return this.paths.values();
    }

    public synchronized boolean testIsDirty() {
        return this.isDirty;
    }

    public synchronized ElementPath getPathFromElement(IRfNamedElement element) {
        ElementPath elementPath;
        if ((this.getPaths() == null || this.isDirty()) && !this.computeAndPopulateRegionTree()) {
            return null;
        }
        if (element == null || this.getPaths() == null) {
            return null;
        }
        IDVTBreadcrumbTextHost bcHost = this.getBcHost();
        if (!(bcHost instanceof DVTEditor)) {
            return null;
        }
        DVTEditor editor = (DVTEditor)bcHost;
        IRfDefElement declaration = element.getDeclaration();
        if (declaration == null || editor.getCurrentFile() == null || !editor.getCurrentFile().equals((Object)declaration.getFileAdapter())) {
            return null;
        }
        IDesignPathProvider designPathProvider = this.getDesignPathProvider();
        if (designPathProvider == null) {
            return null;
        }
        if (designPathProvider.isInstanceDef(declaration) && !this.hasNodeFor(declaration)) {
            RegionTreeNode parent = this.getNodeAtOffset(this.getRoot(), declaration.getStartOffset());
            if (parent == null || this.isRoot(parent)) {
                return null;
            }
            IRfDefElement parentDef = parent.getAssociatedDef();
            if (parentDef == null) {
                return null;
            }
            RegionTreeNode instanceNode = parent.computeInstanceChildNode(declaration.getStartOffset(), designPathProvider, null);
            if (instanceNode != null) {
                this.addNode(instanceNode.getAssociatedDef(), instanceNode);
                this.associateInstancePath(instanceNode);
            }
        }
        if ((elementPath = this.getPathFor(declaration)) == null) {
            return null;
        }
        return elementPath;
    }

    public abstract ElementPath getPathFromScope();

    protected abstract boolean computeAndPopulateRegionTree();

    protected abstract boolean buildActualTree(Collection<?> var1, RegionTreeNode var2, Set<IRfNamedElement> var3, IProgressMonitor var4);

    protected abstract Set<RegionTreeNode> preserveOldPaths(Set<IRfNamedElement> var1, IProgressMonitor var2);

    protected abstract void addElementPath(IRfDefElement var1, ElementPath var2, Set<RegionTreeNode> var3, boolean var4, IProgressMonitor var5);
}

