/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.pathmanager;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELInstance;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfEntityComplement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProvider;
import ro.amiq.dvt.ui.editor.pathmanager.IDesignPathProviderCommon;

class RegionTreeNode {
    private RegionTreeNode parent;
    private List<RegionTreeNode> children;
    private IRegion associatedRegion;
    private IRfDefElement associatedDef;
    private IRfFileDef fileDef;
    private boolean stripToEntity;

    private RegionTreeNode(RegionTreeNode parent, IRfDefElement def) {
        this.children = new ArrayList<RegionTreeNode>(){
            private static final long serialVersionUID = 1L;
            private Comparator<RegionTreeNode> nodeComparator = new Comparator<RegionTreeNode>(){

                @Override
                public int compare(RegionTreeNode o1, RegionTreeNode o2) {
                    return o1.getOffset() - o2.getOffset();
                }
            };

            @Override
            public boolean add(RegionTreeNode e) {
                int index = Collections.binarySearch(this, e, this.nodeComparator);
                if (index >= 0) {
                    return false;
                }
                super.add(index ^= 0xFFFFFFFF, e);
                return true;
            }
        };
        this.parent = parent;
        this.associatedDef = def;
        int startOffset = def.getStartOffset();
        int endOffset = def.getEndOffset();
        this.associatedRegion = new Region(startOffset, endOffset - startOffset + 1);
        this.stripToEntity = !(def instanceof IRfEntityComplement);
        this.fileDef = parent.fileDef;
    }

    private RegionTreeNode(int startOffset, int length, IRfDefElement def, IRfFileDef fileDef) {
        this.children = new ArrayList<RegionTreeNode>(2);
        this.associatedDef = def;
        this.associatedRegion = new Region(startOffset, length);
        this.fileDef = fileDef;
    }

    public static RegionTreeNode createRoot(IDocument document, IRfDefElement defElem, IRfFileDef fileDef) {
        if (document == null) {
            return null;
        }
        return new RegionTreeNode(0, document.getLength(), defElem, fileDef);
    }

    public static RegionTreeNode getChildNode(RegionTreeNode parent, IRfDefElement def) {
        if (parent == null || def == null) {
            return null;
        }
        return new RegionTreeNode(parent, def);
    }

    public boolean contains(int offset) {
        return DesignPathManager.getInstance().isOffsetInsideRegion(this.associatedRegion, offset);
    }

    public void addChild(RegionTreeNode child) {
        if (child == null) {
            return;
        }
        this.children.add(this.children.size(), child);
    }

    public boolean hasChildren() {
        return this.children != null ? !this.children.isEmpty() : false;
    }

    public List<RegionTreeNode> getChildren() {
        return this.children;
    }

    public RegionTreeNode getParent() {
        return this.parent;
    }

    public int getOffset() {
        return this.associatedRegion.getOffset();
    }

    public IRfDefElement getAssociatedDef() {
        return this.associatedDef;
    }

    protected IRfFileDef getFileDef() {
        return this.fileDef;
    }

    public IRegion getAssociatedRegion() {
        return this.associatedRegion;
    }

    public boolean isValidLeaf(IDesignPathProvider provider) {
        if (provider == null) {
            return false;
        }
        if (provider.isInstanceDef(this.associatedDef)) {
            return false;
        }
        return !this.hasChildren() || this.onlyHasInstanceChildren(provider);
    }

    private boolean onlyHasInstanceChildren(IDesignPathProvider provider) {
        if (this.children == null || provider == null) {
            return false;
        }
        for (RegionTreeNode child : this.children) {
            if (provider.isInstanceDef(child.associatedDef)) continue;
            return false;
        }
        return true;
    }

    public boolean isStripToEntity() {
        return this.stripToEntity;
    }

    public RegionTreeNode computeInstanceChildNode(int offset, IDesignPathProvider designPathProvider, ElementPath parentPath) {
        if (designPathProvider == null || offset < 0) {
            return null;
        }
        if (this.associatedDef == null) {
            return null;
        }
        if (parentPath == null) {
            return this.computeSameFileChildren(offset, designPathProvider);
        }
        return this.computeIncludedFileChildren(offset, parentPath, designPathProvider);
    }

    private RegionTreeNode computeSameFileChildren(int offset, IDesignPathProviderCommon designPathProvider) {
        Collection<?> defChildren = this.associatedDef.getChildren();
        if (defChildren == null) {
            return null;
        }
        for (Object c : defChildren) {
            IRfDefElement childDef;
            if (!(c instanceof IRfDefElement) || !designPathProvider.isInstanceDef(childDef = (IRfDefElement)c) || offset > childDef.getEndOffset()) continue;
            if (offset < childDef.getStartOffset()) {
                return null;
            }
            RegionTreeNode newChild = new RegionTreeNode(this, childDef);
            this.children.add(newChild);
            return newChild;
        }
        return null;
    }

    private RegionTreeNode computeIncludedFileChildren(int offset, ElementPath parentPath, IDesignPathProvider designPathProvider) {
        if (this.fileDef == null) {
            return null;
        }
        if (this.associatedDef == null) {
            return null;
        }
        IRfSingleLangProject rfProject = this.associatedDef.getRfProject();
        if (rfProject == null) {
            return null;
        }
        IProject project = rfProject.getProject();
        if (project == null) {
            return null;
        }
        IELMemory elMemory = RfMixedLangManager.getInstance().getELMemory(project);
        if (elMemory == null) {
            return null;
        }
        List<ELInstance> childInstances = ELUtils.getChildInstances(elMemory, parentPath, Integer.MAX_VALUE);
        if (childInstances == null || childInstances.isEmpty()) {
            return null;
        }
        for (ELInstance child : childInstances) {
            IRfFileDef childDefFile;
            IRfDefElement declaration;
            IRfInstanceElement description = child.getDescription();
            if (description == null || (declaration = description.getDeclaration()) == null || !this.fileDef.equals(childDefFile = declaration.getDefFile()) || !designPathProvider.isInstanceDef(declaration) || offset > declaration.getEndOffset() || offset < declaration.getStartOffset()) continue;
            RegionTreeNode newChild = new RegionTreeNode(this, declaration);
            this.children.add(newChild);
            return newChild;
        }
        return null;
    }
}

