/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.pathmanager;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.pathmanager.DesignPathManager;
import ro.amiq.dvt.utils.DVTFileUtils;

public class VisitedRegionWrapper {
    private IDVTBreadcrumbHost editor;
    private IRegion lastVisitedRegion;
    private int lineCache;

    public VisitedRegionWrapper(IDVTBreadcrumbHost editor) {
        this.editor = editor;
        this.lineCache = -1;
    }

    public boolean isInsideLastRegion(int offset) {
        IFile currentFile = ((DVTEditor)this.editor).getCurrentFile();
        if (currentFile == null) {
            return false;
        }
        int currentLine = DVTFileUtils.getInstance().getLineFromOffset(currentFile, offset);
        if (this.lineCache == currentLine) {
            return true;
        }
        this.lineCache = currentLine;
        IRegion current = DesignPathManager.getInstance().getRegionFor(this.editor, offset, true);
        if (current == null) {
            return false;
        }
        return this.lastVisitedRegion == current;
    }

    public void updateLastVisitedRegion(int offset) {
        this.lastVisitedRegion = DesignPathManager.getInstance().getRegionFor(this.editor, offset, true);
        IFile currentFile = ((DVTEditor)this.editor).getCurrentFile();
        if (currentFile == null) {
            return;
        }
        this.lineCache = DVTFileUtils.getInstance().getLineFromOffset(currentFile, offset);
    }

    public int getCachedLine() {
        return this.lineCache;
    }
}

