/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.problem.hover;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.hover.HTMLTextPresenter;
import ro.amiq.dvt.ui.editor.problem.hover.DVTProblemHoverAnnotationInfo;
import ro.amiq.dvt.ui.editor.problem.hover.DVTProblemHoverControlCreator;
import ro.amiq.dvt.ui.editor.problem.hover.DVTProblemHoverPresenterControlCreator;
import ro.amiq.dvt.ui.editor.problem.hover.DVTProblemHoverUtils;
import ro.amiq.dvt.ui.editor.problem.hover.DvtProblemHoverInput;
import ro.amiq.dvt.ui.editor.quickassist.QuickAssistCreateWaiverProposal;
import ro.amiq.dvt.ui.editor.quickfix.EditorQuickFixProcessor;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;

public abstract class DVTProblemHoverAbstract
implements ITextHover {
    protected final DVTEditor fTextEditor;
    private IInformationControlCreator fHoverControlCreator;
    private IInformationControlCreator fPresenterControlCreator;
    private HTMLTextPresenter fHtmlTextPresenter;
    protected IRegion hoverRegion;
    protected String extraToolTipInfo;
    private Set<String> problemCategories;

    public DVTProblemHoverAbstract(DVTEditor editor, Set<String> problemCategories) {
        this.fTextEditor = editor;
        this.problemCategories = problemCategories;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        return this.hoverRegion;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        IAnnotationModel annotationModel = EditorQuickFixProcessor.getAnnotationModel((ITextEditor)this.fTextEditor);
        if (annotationModel == null || hoverRegion == null || hoverRegion.getOffset() < 0 || this.problemCategories == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        this.hoverRegion = hoverRegion;
        TreeMap<Annotation, DVTProblemHoverAnnotationInfo> allAnnotationInfos = new TreeMap<Annotation, DVTProblemHoverAnnotationInfo>(DVTProblemHoverUtils.ANNOTATION_SEVERITY_COMPARATOR.thenComparing(DVTProblemHoverUtils.ANNOTATION_TEXT_COMPARATOR));
        try {
            int offset = hoverRegion.getOffset();
            Iterator iter = annotationModel.getAnnotationIterator();
            while (iter.hasNext()) {
                Annotation annotation = (Annotation)iter.next();
                if (!(annotation instanceof MarkerAnnotation)) continue;
                IMarker marker = ((MarkerAnnotation)annotation).getMarker();
                Position position = annotationModel.getPosition(annotation);
                if (!this.problemCategories.contains(marker.getType())) continue;
                int markerPosStart = position.getOffset();
                int markerPosEnd = markerPosStart + position.getLength();
                if ("ro.amiq.vlogdt.LintingErrorMarker".equals(marker.getType())) {
                    boolean hasAutofixImplemented = marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.ImplementedAutofixAttribute", false);
                    if (!hasAutofixImplemented) continue;
                    if (position.getLength() == 0) {
                        int line = document.getLineOfOffset(markerPosStart);
                        int lineLength = document.getLineLength(line);
                        markerPosEnd = markerPosStart + lineLength;
                    }
                }
                if (offset < markerPosStart || offset > markerPosEnd) continue;
                if (markerPosStart <= offset) {
                    List<Object> allProposals = this.getProposalsForAnnotation((MarkerAnnotation)annotation, textViewer, offset);
                    if (allProposals == null) {
                        allProposals = Collections.emptyList();
                    }
                    allAnnotationInfos.put(annotation, new DVTProblemHoverAnnotationInfo(annotation, position, allProposals));
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return new DvtProblemHoverInput(textViewer, this.extraToolTipInfo, allAnnotationInfos);
    }

    private List<ICompletionProposal> getProposalsForAnnotation(MarkerAnnotation annotation, ITextViewer textViewer, int offset) {
        ArrayList<ICompletionProposal> allProposals = new ArrayList<ICompletionProposal>();
        boolean noQFSuggestion = false;
        List<ICompletionProposal> quickFixProposals = this.getQuickFixProposals(textViewer, offset, annotation);
        List<ICompletionProposal> quickAssistProposals = this.getQuickAssistProposals(textViewer, offset, annotation);
        List<ICompletionProposal> lintingAutofixProposals = this.getLintingProposalFromMarker(annotation);
        if (lintingAutofixProposals != null && !lintingAutofixProposals.isEmpty()) {
            allProposals.addAll(lintingAutofixProposals);
        }
        if (quickFixProposals == null || quickFixProposals.isEmpty()) {
            if (quickAssistProposals != null && !quickAssistProposals.isEmpty()) {
                allProposals.addAll(quickAssistProposals);
            }
            return allProposals;
        }
        if (quickFixProposals.size() == 1) {
            if (quickFixProposals.get(0) == DVTQuickFixUtil.QUICK_FIX_TOOLTIP_CANCELLED) {
                return Collections.singletonList(DVTQuickFixUtil.QUICK_FIX_TOOLTIP_CANCELLED);
            }
            if (quickFixProposals.get(0) == DVTQuickFixUtil.NO_SUGGESTION_AVAILABLE) {
                noQFSuggestion = true;
            }
        }
        if (!noQFSuggestion) {
            allProposals.addAll(quickFixProposals);
        }
        if (!quickAssistProposals.isEmpty()) {
            allProposals.addAll(quickAssistProposals);
        } else if (noQFSuggestion) {
            allProposals.add(DVTQuickFixUtil.NO_SUGGESTION_AVAILABLE);
        }
        return allProposals;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        return null;
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new DVTProblemHoverControlCreator(this.getInformationPresenterControlCreator(), this.getHtmlTextPresenter());
        }
        return this.fHoverControlCreator;
    }

    private HTMLTextPresenter getHtmlTextPresenter() {
        if (this.fHtmlTextPresenter == null) {
            this.fHtmlTextPresenter = new HTMLTextPresenter(true);
        }
        return this.fHtmlTextPresenter;
    }

    public IInformationControlCreator getInformationPresenterControlCreator() {
        if (this.fPresenterControlCreator == null) {
            this.fPresenterControlCreator = new DVTProblemHoverPresenterControlCreator(this.getHtmlTextPresenter());
        }
        return this.fPresenterControlCreator;
    }

    private List<ICompletionProposal> getQuickAssistProposals(ITextViewer textViewer, int offset, MarkerAnnotation annotation) {
        if (annotation == null) {
            return Collections.emptyList();
        }
        ArrayList<ICompletionProposal> allQAProposals = new ArrayList<ICompletionProposal>();
        List<ICompletionProposal> langSpecifixQAProposals = this.getLangSpecificQAProposals(textViewer, offset);
        if (langSpecifixQAProposals != null) {
            allQAProposals.addAll(langSpecifixQAProposals);
        }
        IMarker marker = annotation.getMarker();
        allQAProposals.add(new QuickAssistCreateWaiverProposal(marker));
        return allQAProposals;
    }

    public void setExtraTooltipInfo(String extraToolTipInfo) {
        this.extraToolTipInfo = extraToolTipInfo;
    }

    public abstract List<ICompletionProposal> getQuickFixProposals(ITextViewer var1, int var2, MarkerAnnotation var3);

    public abstract List<ICompletionProposal> getLangSpecificQAProposals(ITextViewer var1, int var2);

    public List<ICompletionProposal> getLintingProposalFromMarker(MarkerAnnotation annotation) {
        return null;
    }
}

