/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.problem.hover;

import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.AbstractInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.hover.HTMLTextPresenter;
import ro.amiq.dvt.ui.editor.problem.hover.DVTProblemHoverAnnotationInfo;
import ro.amiq.dvt.ui.editor.problem.hover.DVTProblemHoverUtils;
import ro.amiq.dvt.ui.editor.problem.hover.DvtProblemHoverInput;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.preferences.theme.DVTThemeUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.InspectViewUpdateEvent;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.InspectView;

public class DVTProblemHoverInformationControl
extends AbstractInformationControl
implements IInformationControlExtension2 {
    private final DefaultMarkerAnnotationAccess fMarkerAnnotationAccess;
    private Control fFocusControl;
    private DvtProblemHoverInput fInput;
    private final TextPresentation fPresentation = new TextPresentation();
    private ScrolledComposite scrolledComposite;
    private Composite fParent;
    private TriggerInspectUpdateJob job = new TriggerInspectUpdateJob();
    private static final long TRIGGER_JOB_DELAY = 300L;

    public DVTProblemHoverInformationControl(Shell parentShell, String statusFieldText) {
        super(parentShell, statusFieldText);
        this.fMarkerAnnotationAccess = new DefaultMarkerAnnotationAccess();
        this.create();
    }

    public DVTProblemHoverInformationControl(Shell parentShell, ToolBarManager toolBarManager) {
        super(parentShell, toolBarManager);
        this.fMarkerAnnotationAccess = new DefaultMarkerAnnotationAccess();
        this.create();
    }

    protected void createContent(Composite parent) {
        this.fParent = parent;
        Color background = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.tooltip.backgroundColor");
        Color foreground = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.tooltip.foregroundColor");
        DVTColorUtil.INSTANCE.setBackgroundRecursive((Control)parent.getParent(), background);
        DVTColorUtil.INSTANCE.setForegroundRecursive((Control)parent.getParent(), foreground);
    }

    public void setInput(Object input) {
        Assert.isLegal((boolean)(input instanceof DvtProblemHoverInput));
        this.fInput = (DvtProblemHoverInput)input;
        this.disposeCreatedControl();
        this.createControl();
    }

    protected void createControl() {
        this.fillToolbar();
        this.scrolledComposite = new ScrolledComposite(this.fParent, 768);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        final Composite tooltipComposite = new Composite((Composite)this.scrolledComposite, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tooltipComposite.setLayout((Layout)layout);
        DvtProblemHoverInput annotationInput = this.fInput;
        Map<Annotation, DVTProblemHoverAnnotationInfo> allAnnotationInfos = annotationInput.getAnnotationInfos();
        this.createAnnotationAndQuickFixesControl(allAnnotationInfos, tooltipComposite);
        String extraTooltipInfo = annotationInput.getExtraTooltipInfo();
        if (extraTooltipInfo != null && !extraTooltipInfo.isEmpty()) {
            this.createExtraTooltipInfo(tooltipComposite, extraTooltipInfo);
        }
        Point contentSize = this.getSizeConstraints();
        this.scrolledComposite.setSize(contentSize);
        tooltipComposite.addListener(11, new Listener(){
            int width = -1;
            int height = -1;

            public void handleEvent(Event e) {
                int newHeight;
                int newWidth = tooltipComposite.getSize().x;
                if (newWidth != this.width) {
                    DVTProblemHoverInformationControl.this.scrolledComposite.setMinHeight(tooltipComposite.computeSize((int)newWidth, (int)-1).y);
                    this.width = newWidth;
                }
                if (this.height != (newHeight = tooltipComposite.getSize().y)) {
                    DVTProblemHoverInformationControl.this.scrolledComposite.setMinWidth(tooltipComposite.computeSize((int)newHeight, (int)-1).x);
                    this.height = newHeight;
                }
            }
        });
        this.scrolledComposite.setContent((Control)tooltipComposite);
        Color background = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.tooltip.backgroundColor");
        DVTColorUtil.INSTANCE.setBackgroundRecursive((Control)this.scrolledComposite, background);
        Color foreground = JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.tooltip.foregroundColor");
        DVTColorUtil.INSTANCE.setForegroundRecursive((Control)this.scrolledComposite, foreground);
        Font font = JFaceResources.getDialogFont();
        DVTThemeUtils.setFontRecursive((Control)this.scrolledComposite, font);
        this.fParent.layout(true, true);
    }

    protected void fillToolbar() {
        ToolBarManager toolBarManager = this.getToolBarManager();
        if (toolBarManager == null) {
            return;
        }
        if (TestHelper.isTestMode()) {
            this.fInput.testAddCopyTooltipButton(toolBarManager);
        }
        toolBarManager.update(true);
    }

    private void createAnnotationAndQuickFixesControl(Map<Annotation, DVTProblemHoverAnnotationInfo> allAnnotationInfos, Composite tooltipComposite) {
        if (allAnnotationInfos == null) {
            return;
        }
        boolean isFirstAnnotation = true;
        for (Map.Entry<Annotation, DVTProblemHoverAnnotationInfo> annotationEntry : allAnnotationInfos.entrySet()) {
            Annotation annotation = annotationEntry.getKey();
            if (!isFirstAnnotation) {
                Label separator = new Label(tooltipComposite, 258);
                GridData gridData = new GridData(4, 0x1000000, true, false);
                separator.setLayoutData((Object)gridData);
            } else {
                isFirstAnnotation = false;
            }
            this.createAnnotationInformation(tooltipComposite, annotation);
            DVTProblemHoverAnnotationInfo annotationInfo = annotationEntry.getValue();
            ICompletionProposal[] proposals = annotationInfo.getCompletionProposals();
            if (proposals.length <= 0) continue;
            this.createCompletionProposalsControl(tooltipComposite, annotationInfo);
        }
    }

    private void createAnnotationInformation(Composite parent, final Annotation annotation) {
        Composite composite = new Composite(parent, 16);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(3, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        final Canvas canvas = new Canvas(composite, 524288);
        GridData gridData = new GridData(1, 1, false, false);
        gridData.widthHint = 17;
        gridData.heightHint = 16;
        canvas.setLayoutData((Object)gridData);
        canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                e.gc.setFont(null);
                DVTProblemHoverInformationControl.this.fMarkerAnnotationAccess.paint(annotation, e.gc, canvas, new Rectangle(0, 0, 16, 16));
            }
        });
        StyledText text = new StyledText(composite, 74);
        GridData data = new GridData(4, 4, true, true);
        text.setLayoutData((Object)data);
        String annotationText = annotation.getText();
        if (annotationText != null) {
            DVTProblemHoverUtils.CompileIndexEnrichedMessage enrichedMessage = DVTProblemHoverUtils.addFileCompileIndexNoteToMessage(annotation, annotationText, this.fInput.getViewer());
            text.setText(enrichedMessage.message);
            text.setStyleRange(enrichedMessage.styleRange);
        }
        this.addInspectHyperlink(annotation, composite);
    }

    private void addInspectHyperlink(Annotation annotation, Composite composite) {
        if (!(annotation instanceof MarkerAnnotation)) {
            return;
        }
        final MarkerAnnotation markerAnnotation = (MarkerAnnotation)annotation;
        Link link = new Link(composite, 0);
        GridData linkData = new GridData(4, 4, false, false);
        link.setText(" (<a>inspect</a>)");
        link.setLayoutData((Object)linkData);
        DVTUiUtils.setPlatformLinkColor((Link)link);
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IMarker marker = markerAnnotation.getMarker();
                if (marker == null) {
                    return;
                }
                IResource resource = marker.getResource();
                if (resource == null) {
                    return;
                }
                IProject project = resource.getProject();
                Map<String, Object> result = DVTInspectViewUtils.getInstance().getProblemMarkerInfo(marker);
                if (result == null) {
                    return;
                }
                InspectViewUpdateEvent inspectViewEvent = new InspectViewUpdateEvent(result, project, false);
                DVTProblemHoverInformationControl.this.job.cancel();
                DVTProblemHoverInformationControl.this.job.setTriggerEvent(inspectViewEvent);
                DVTProblemHoverInformationControl.this.job.schedule(300L);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    private void createCompletionProposalsControl(Composite parent, DVTProblemHoverAnnotationInfo annotationInfo) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        Label separator = new Label(composite, 258);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        separator.setLayoutData((Object)gridData);
        this.createQuickFixNumberText(parent, annotationInfo, composite);
        this.createCompletionProposalsList(composite, annotationInfo);
    }

    private void createQuickFixNumberText(Composite parent, DVTProblemHoverAnnotationInfo annotationInfo, Composite composite) {
        ICompletionProposal firstProposal;
        Label quickFixNumberLabel = new Label(composite, 0);
        GridData layoutData = new GridData(1, 0x1000000, false, false);
        layoutData.horizontalIndent = 4;
        quickFixNumberLabel.setLayoutData((Object)layoutData);
        String quickFixNumberText = "";
        ICompletionProposal[] proposals = annotationInfo.getCompletionProposals();
        quickFixNumberText = proposals.length == 1 ? ((firstProposal = proposals[0]) == DVTQuickFixUtil.QUICK_FIX_TOOLTIP_CANCELLED ? "Computing Quick Fix proposals timed out." : (firstProposal == DVTQuickFixUtil.NO_SUGGESTION_AVAILABLE ? "No Quick Fix proposals available." : "1 quick fix available:")) : String.valueOf(proposals.length) + " quick fixes available:";
        quickFixNumberLabel.setText(quickFixNumberText);
    }

    private void createCompletionProposalsList(Composite parent, DVTProblemHoverAnnotationInfo annotationInfo) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 5;
        layout.verticalSpacing = 2;
        composite.setLayout((Layout)layout);
        ICompletionProposal[] proposals = annotationInfo.getCompletionProposals();
        int i = 0;
        while (i < proposals.length) {
            this.createCompletionProposalLink(composite, annotationInfo.getPosition(), proposals[i]);
            ++i;
        }
    }

    private Link createCompletionProposalLink(Composite parent, final Position position, final ICompletionProposal proposal) {
        Label proposalImage = new Label(parent, 4);
        proposalImage.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        Image image = proposal.getImage();
        if (image != null) {
            proposalImage.setImage(image);
            proposalImage.addMouseListener(new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                }

                public void mouseDown(MouseEvent e) {
                }

                public void mouseUp(MouseEvent e) {
                    if (e.button == 1) {
                        DVTProblemHoverInformationControl.this.apply(proposal, DVTProblemHoverInformationControl.this.fInput.getViewer(), position.offset, false);
                    }
                }
            });
        }
        Link proposalLink = new Link(parent, 0);
        GridData layoutData = new GridData(4, 0x1000000, true, false);
        String linkText = proposal.getDisplayString();
        proposalLink.setText("<a>" + linkText + "</a>");
        DVTUiUtils.setPlatformLinkColor((Link)proposalLink);
        proposalLink.setLayoutData((Object)layoutData);
        proposalLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DVTProblemHoverInformationControl.this.apply(proposal, DVTProblemHoverInformationControl.this.fInput.getViewer(), position.offset, false);
            }
        });
        return proposalLink;
    }

    private void createExtraTooltipInfo(Composite parent, String extraTooltipInfo) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData(4, 0x1000000, true, false);
        separator.setLayoutData((Object)gridData);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        StyledText extraTooltipLabel = new StyledText(composite, 10);
        GridData layoutData = new GridData(1, 0x1000000, false, false);
        layoutData.horizontalIndent = 4;
        extraTooltipLabel.setLayoutData((Object)layoutData);
        extraTooltipLabel.setText(this.getStyledText(extraTooltipInfo, extraTooltipLabel));
        TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)extraTooltipLabel);
    }

    private String getStyledText(String tooltipText, StyledText extraTooltipLabel) {
        String text;
        HTMLTextPresenter textPresenter = this.getHtmlControlCreator();
        if (textPresenter == null) {
            return tooltipText;
        }
        this.fPresentation.clear();
        int maxWidth = -1;
        int maxHeight = -1;
        Point constraints = this.getSizeConstraints();
        if (constraints != null) {
            maxWidth = constraints.x;
            maxHeight = constraints.y;
            --maxWidth;
            Rectangle trim = this.computeTrim();
            maxWidth -= trim.width;
            maxHeight -= trim.height;
        }
        if (this.isResizable()) {
            maxHeight = Integer.MAX_VALUE;
        }
        return (text = textPresenter.updatePresentation((Drawable)extraTooltipLabel, tooltipText, this.fPresentation, maxWidth, maxHeight)) == null ? "" : text;
    }

    private void apply(ICompletionProposal p, ITextViewer viewer, int offset, boolean isMultiFix) {
        this.dispose();
        IRewriteTarget target = null;
        try {
            IDocument document = viewer.getDocument();
            if (viewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)viewer;
                target = extension.getRewriteTarget();
            }
            if (target != null) {
                target.beginCompoundChange();
            }
            if (p instanceof ICompletionProposalExtension2) {
                e = (ICompletionProposalExtension2)p;
                e.apply(viewer, '\u0000', isMultiFix ? 262144 : 0, offset);
            } else if (p instanceof ICompletionProposalExtension) {
                e = (ICompletionProposalExtension)p;
                e.apply(document, '\u0000', offset);
            } else {
                p.apply(document);
            }
            Point selection = p.getSelection(document);
            if (selection != null) {
                viewer.setSelectedRange(selection.x, selection.y);
                viewer.revealRange(selection.x, selection.y);
            }
        }
        finally {
            if (target != null) {
                target.endCompoundChange();
            }
        }
    }

    public boolean hasContents() {
        return this.fInput != null;
    }

    public void setFocus() {
        super.setFocus();
        if (this.fFocusControl != null) {
            this.fFocusControl.setFocus();
        }
    }

    public final void setVisible(boolean visible) {
        if (!visible) {
            this.disposeCreatedControl();
        }
        super.setVisible(visible);
    }

    protected void disposeCreatedControl() {
        Control[] children = this.fParent.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        ToolBarManager toolBarManager = this.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.removeAll();
        }
    }

    public Point computeSizeHint() {
        Point preferedSize = this.getShell().computeSize(-1, -1, true);
        Point constrains = this.getSizeConstraints();
        if (constrains == null) {
            return preferedSize;
        }
        int trimWidth = this.getShell().computeTrim((int)0, (int)0, (int)0, (int)0).width;
        Point constrainedSize = this.getShell().computeSize(constrains.x - trimWidth, -1, true);
        int width = Math.min(preferedSize.x, constrainedSize.x);
        int height = Math.max(preferedSize.y, constrainedSize.y);
        return new Point(width, height);
    }

    public void setInformation(String information) {
    }

    public HTMLTextPresenter getHtmlControlCreator() {
        return null;
    }

    private static class TriggerInspectUpdateJob
    extends Job {
        private InspectViewUpdateEvent triggerEvent = null;

        public TriggerInspectUpdateJob() {
            super("Trigger Inspect Marker Update Job");
        }

        public void setTriggerEvent(InspectViewUpdateEvent event) {
            this.triggerEvent = event;
        }

        public IStatus run(IProgressMonitor monitor) {
            if (!InspectView.isActive()) {
                ViewsUtils.showViewById("ro.amiq.dvt.ui.views.InspectView");
            }
            InspectView.getInstance().update(this.triggerEvent);
            this.triggerEvent = null;
            return Status.OK_STATUS;
        }
    }
}

