/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.problem.hover;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.DVTProjectionViewer;
import ro.amiq.dvt.ui.editor.quickfix.EditorQuickFixProcessor;
import ro.amiq.dvt.ui.views.inspect.DVTInspectViewUtils;
import ro.amiq.dvt.ui.views.inspect.FileCompileInfo;

public class DVTProblemHoverUtils {
    public static final String QUICK_FIXES_AVAILABLE = " quick fixes available:";
    public static final String ONE_QUICK_FIX_AVAILABLE = "1 quick fix available:";
    public static final String NO_QUICK_FIX_PROPOSALS_AVAILABLE = "No Quick Fix proposals available.";
    public static final String QUICK_FIX_TIMED_OUT = "Computing Quick Fix proposals timed out.";
    public static final int INNER_BORDER = 1;
    private static final String NOTE = "Note: ";
    private static final String COMPILE_INDEXES_MESSAGE = "File is compiled multiple times, with compile indexes: ";
    private static final String NEW_LINE = System.lineSeparator();
    private static final Set<String> ST_MARKER_IDS = new HashSet<String>(Arrays.asList("ro.amiq.vhdldt.SyntaxProblemMarker", "ro.amiq.vlogdt.SyntaxProblemMarker"));
    private static final Set<String> SM_MARKER_IDS = new HashSet<String>(Arrays.asList("ro.amiq.vhdldt.SemanticProblemMarker", "ro.amiq.vhdldt.ObsoleteSemanticProblemMarker", "ro.amiq.vlogdt.SemanticProblemMarker", "ro.amiq.vlogdt.ObsoleteSemanticProblemMarker"));
    private static final Set<Pattern> SM_PATTERNS = new HashSet<Pattern>(Arrays.asList(Pattern.compile("^_?DUPLICATE_\\w+:"), Pattern.compile("^\\w+: Redefinition of macro name:")));
    public static final Comparator<Annotation> ANNOTATION_TEXT_COMPARATOR = new Comparator<Annotation>(){

        @Override
        public int compare(Annotation o1, Annotation o2) {
            if (!(o1 instanceof MarkerAnnotation) || !(o2 instanceof MarkerAnnotation)) {
                return 0;
            }
            MarkerAnnotation o1Marker = (MarkerAnnotation)o1;
            MarkerAnnotation o2Marker = (MarkerAnnotation)o2;
            String o1Text = o1Marker.getText();
            String o2Text = o2Marker.getText();
            return o1Text.compareTo(o2Text);
        }
    };
    public static final Comparator<Annotation> ANNOTATION_SEVERITY_COMPARATOR = new Comparator<Annotation>(){

        @Override
        public int compare(Annotation o1, Annotation o2) {
            if (!(o1 instanceof MarkerAnnotation) || !(o2 instanceof MarkerAnnotation)) {
                return 0;
            }
            MarkerAnnotation o1Marker = (MarkerAnnotation)o1;
            MarkerAnnotation o2Marker = (MarkerAnnotation)o2;
            int o1Sev = o1Marker.getMarker().getAttribute("severity", 0);
            int o2Sev = o2Marker.getMarker().getAttribute("severity", 0);
            return o2Sev - o1Sev;
        }
    };

    public static boolean shouldShowQuickFixLinks(ITextEditor fTextEditor, IRegion hoverRegion, Set<String> problemsCategories) {
        IAnnotationModel annotationModel = EditorQuickFixProcessor.getAnnotationModel(fTextEditor);
        if (annotationModel == null || hoverRegion == null || hoverRegion.getOffset() < 0) {
            return false;
        }
        int offset = hoverRegion.getOffset();
        Iterator iter = annotationModel.getAnnotationIterator();
        while (iter.hasNext()) {
            Annotation annotation = (Annotation)iter.next();
            if (!(annotation instanceof MarkerAnnotation)) continue;
            IMarker marker = ((MarkerAnnotation)annotation).getMarker();
            Position position = annotationModel.getPosition(annotation);
            try {
                if (marker == null || !marker.exists() || ((MarkerAnnotation)annotation).getText() == null || !problemsCategories.contains(marker.getType())) continue;
                int markerPosStart = position.getOffset();
                int markerPosEnd = markerPosStart + position.getLength();
                if (offset < markerPosStart || offset > markerPosEnd) continue;
                return true;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return false;
    }

    public static CompileIndexEnrichedMessage addFileCompileIndexNoteToMessage(Annotation annotation, String message, ITextViewer textViewer) {
        CompileIndexEnrichedMessage result = new CompileIndexEnrichedMessage(message, null);
        if (message == null || message.isEmpty()) {
            return result;
        }
        if (!(annotation instanceof MarkerAnnotation)) {
            return result;
        }
        IMarker marker = ((MarkerAnnotation)annotation).getMarker();
        if (marker == null) {
            return result;
        }
        String compileIndexMessage = DVTProblemHoverUtils.getCompileIndexMessageSuffix(textViewer);
        if (compileIndexMessage == null) {
            return result;
        }
        try {
            if (!DVTProblemHoverUtils.shouldShowCompileIndexes(marker)) {
                return result;
            }
            result.message = String.valueOf(message) + NEW_LINE + NOTE + compileIndexMessage;
            result.styleRange = new StyleRange(message.length() + 1, NOTE.length(), null, null, 1);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return result;
    }

    private static boolean shouldShowCompileIndexes(IMarker marker) throws CoreException {
        if (ST_MARKER_IDS.contains(marker.getType())) {
            return true;
        }
        if (!SM_MARKER_IDS.contains(marker.getType())) {
            return false;
        }
        for (Pattern p : SM_PATTERNS) {
            if (!p.matcher(marker.getAttribute("message", "")).find()) continue;
            return true;
        }
        return false;
    }

    private static String getCompileIndexMessageSuffix(ITextViewer textViewer) {
        if (!(textViewer instanceof DVTProjectionViewer)) {
            return null;
        }
        DVTEditor editor = ((DVTProjectionViewer)textViewer).getEditor();
        if (!(editor instanceof IResource)) {
            return null;
        }
        IResource file = (IResource)editor.getAdapter(IResource.class);
        if (!(file instanceof IFile)) {
            return null;
        }
        FileCompileInfo compileInfo = DVTInspectViewUtils.getInstance().getCompileInfo((IFile)file);
        if (compileInfo == null) {
            return null;
        }
        String compileIndexInfo = compileInfo.getCompileIndicesString();
        if (compileInfo.getCompileIndices().size() < 2) {
            return null;
        }
        return COMPILE_INDEXES_MESSAGE + compileIndexInfo;
    }

    public static class CompileIndexEnrichedMessage {
        public String message;
        public StyleRange styleRange;

        public CompileIndexEnrichedMessage(String message, StyleRange styleRange) {
            this.message = message;
            this.styleRange = styleRange;
        }
    }
}

