/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.problem.hover;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.source.Annotation;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.problem.hover.DVTProblemHoverAnnotationInfo;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.Utils;

public class DvtProblemHoverInput {
    private final ITextViewer viewer;
    private final String extraTooltipInfo;
    private Map<Annotation, DVTProblemHoverAnnotationInfo> annotationInfos;

    public DvtProblemHoverInput(ITextViewer viewer, String extraToolTipInfo, Map<Annotation, DVTProblemHoverAnnotationInfo> allAnnotationInfos) {
        this.viewer = viewer;
        this.extraTooltipInfo = extraToolTipInfo;
        this.annotationInfos = allAnnotationInfos;
    }

    public ITextViewer getViewer() {
        return this.viewer;
    }

    public String getExtraTooltipInfo() {
        return this.extraTooltipInfo;
    }

    public Map<Annotation, DVTProblemHoverAnnotationInfo> getAnnotationInfos() {
        return this.annotationInfos;
    }

    public void setAnnotationInfos(Map<Annotation, DVTProblemHoverAnnotationInfo> annotationInfos) {
        this.annotationInfos = annotationInfos;
    }

    public void testAddCopyTooltipButton(ToolBarManager manager) {
        TestCopyHoverToClipboard action = new TestCopyHoverToClipboard(this);
        manager.add((IAction)action);
    }

    public String testGetTooltipString() {
        ArrayList<String> allStrings = new ArrayList<String>();
        if (this.annotationInfos != null && !this.annotationInfos.isEmpty()) {
            for (Map.Entry<Annotation, DVTProblemHoverAnnotationInfo> annotationInfoEntry : this.annotationInfos.entrySet()) {
                Annotation annotation = annotationInfoEntry.getKey();
                DVTProblemHoverAnnotationInfo annotationInfo = annotationInfoEntry.getValue();
                allStrings.add(annotation.getText());
                ICompletionProposal[] allProposals = annotationInfo.getCompletionProposals();
                if (allProposals == null || allProposals.length == 0) continue;
                ICompletionProposal[] iCompletionProposalArray = allProposals;
                int n = allProposals.length;
                int n2 = 0;
                while (n2 < n) {
                    ICompletionProposal proposal = iCompletionProposalArray[n2];
                    allStrings.add(proposal.getDisplayString());
                    ++n2;
                }
            }
        }
        if (this.extraTooltipInfo != null && !this.extraTooltipInfo.isEmpty()) {
            String trimmedTooltip = this.extraTooltipInfo;
            if ((trimmedTooltip = trimmedTooltip.replaceAll("&lt;", "<").replaceAll("&gt;", ">")) != null) {
                trimmedTooltip = trimmedTooltip.replaceAll("[ ]+", " ");
                if ((trimmedTooltip = trimmedTooltip.replaceAll("<br>", "\n").replaceAll("</?b>", "").trim()) != null) {
                    allStrings.add(trimmedTooltip);
                }
            }
        }
        if (allStrings.isEmpty()) {
            return "";
        }
        return DVTStringUtil.join(allStrings, System.lineSeparator());
    }

    private static final class TestCopyHoverToClipboard
    extends Action {
        private final DvtProblemHoverInput annotationInput;

        public TestCopyHoverToClipboard(DvtProblemHoverInput annotationInput) {
            this.annotationInput = annotationInput;
            this.setImageDescriptor(DVTImages.INFORMATION);
            this.setToolTipText("Test Mode: Copy tooltip to clipboard");
        }

        public void run() {
            String content = this.annotationInput.testGetTooltipString();
            Utils.copyToClipboard(content, 3);
        }
    }
}

