/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quick.proposals;

import java.util.Comparator;
import ro.amiq.dvt.ui.editor.quick.proposals.QuickProposalPriorityByType;
import ro.amiq.dvt.ui.editor.quick.proposals.QuickProposalsWrapper;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixAnnotationPriority;

public class QuickProposalsPriorityComparator
implements Comparator<QuickProposalsWrapper> {
    private boolean fQuickAssistFirst;

    public QuickProposalsPriorityComparator(boolean quickAssistFirst) {
        this.fQuickAssistFirst = quickAssistFirst;
    }

    @Override
    public int compare(QuickProposalsWrapper o1, QuickProposalsWrapper o2) {
        QuickProposalPriorityByType o1ProposalType = o1.getQuickProposalType();
        int o1TypePriority = o1ProposalType.ordinal();
        QuickProposalPriorityByType o2ProposalType = o2.getQuickProposalType();
        int o2TypePriority = o2ProposalType.ordinal();
        if (o1ProposalType == QuickProposalPriorityByType.CREATE_WAIVER) {
            return 1;
        }
        if (o2ProposalType == QuickProposalPriorityByType.CREATE_WAIVER) {
            return -1;
        }
        if (this.fQuickAssistFirst) {
            if (o1ProposalType == QuickProposalPriorityByType.QUICK_ASSIST && o2ProposalType == QuickProposalPriorityByType.QUICK_FIX) {
                highestPriority = o2TypePriority;
                o2TypePriority = o1TypePriority;
                o1TypePriority = highestPriority;
            } else if (o1ProposalType == QuickProposalPriorityByType.QUICK_FIX && o2ProposalType == QuickProposalPriorityByType.QUICK_ASSIST) {
                highestPriority = o1TypePriority;
                o1TypePriority = o2TypePriority;
                o2TypePriority = highestPriority;
            }
        }
        if (o1TypePriority == o2TypePriority) {
            if (o1.getQuickProposalType() == QuickProposalPriorityByType.QUICK_FIX) {
                QuickFixAnnotationPriority o1QuickFixAnnoPriority = o1.getQuickFixAnnotationPriority();
                QuickFixAnnotationPriority o2QuickFixAnnoPriority = o2.getQuickFixAnnotationPriority();
                if (o1QuickFixAnnoPriority != null && o2QuickFixAnnoPriority != null && o1QuickFixAnnoPriority != o2QuickFixAnnoPriority) {
                    return o1QuickFixAnnoPriority.ordinal() - o2QuickFixAnnoPriority.ordinal();
                }
            }
            int o1ProposalOffset = o1.getProposalOffset();
            int o2ProposalOffset = o2.getProposalOffset();
            return o1ProposalOffset - o2ProposalOffset;
        }
        return o1TypePriority - o2TypePriority;
    }

    public boolean isSelection() {
        return this.fQuickAssistFirst;
    }

    public void setIsSelection(boolean isSelection) {
        this.fQuickAssistFirst = isSelection;
    }
}

