/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.DVTAbstractQuickAssistProposal;
import ro.amiq.dvt.ui.editor.quickassist.IQuickCompletion;

public abstract class DVTAbstractQuickAssistProcessorCommon
implements IQuickCompletion {
    protected ITextViewer fViewer;
    protected IDocument fDocument;
    protected IFile fFile;
    protected DVTEditor fEditor;
    protected int fCursorOffset;
    protected int fTooltipCursorOffset = -1;
    protected IProject fProject;

    public void setTooltipOffset(int tooltipOffset) {
        this.fTooltipCursorOffset = tooltipOffset;
    }

    public DVTAbstractQuickAssistProposal[] getProposals(boolean tooltipTriggered) {
        try {
            if (!this.init()) {
                return new DVTAbstractQuickAssistProposal[0];
            }
            if (!this.validate()) {
                return new DVTAbstractQuickAssistProposal[0];
            }
            List<DVTAbstractQuickAssistProposal> proposals = this.makeProposals();
            ArrayList result = new ArrayList(proposals.size());
            proposals.forEach(p -> {
                if (!p.hasError(tooltipTriggered)) {
                    result.add(p);
                }
            });
            return result.toArray(new DVTAbstractQuickAssistProposal[result.size()]);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new DVTAbstractQuickAssistProposal[0];
        }
    }

    public abstract boolean initRfProject();

    public abstract boolean validate();

    public abstract List<DVTAbstractQuickAssistProposal> makeProposals();

    protected abstract boolean init();
}

