/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickassist;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.IQuickCompletion;
import ro.amiq.dvt.ui.editor.quickassist.util.CreateChangeStatus;
import ro.amiq.dvt.ui.editor.quickassist.util.DVTQuickAssistUtil;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;

public abstract class DVTAbstractQuickAssistProposal
implements ICompletionProposal,
IQuickCompletion {
    private AtomicBoolean errorFlag;
    protected DVTEditor editor;
    protected IFile file;
    protected IDocument document;
    protected DVTTextFileChange textFileChange;
    protected CompositeChange compositeChange;
    private String vscodeRefactorKind = "refactor";

    public boolean hasError(boolean tooltipTriggered) {
        if (this.errorFlag == null && tooltipTriggered) {
            this.getDisplayString();
        }
        if (this.errorFlag == null) {
            return false;
        }
        return this.errorFlag.get();
    }

    public void apply(IDocument document) {
        try {
            this.preApplyQuickAssist(document);
            CreateChangeStatus status = this.createQuickAssistChanges();
            switch (status) {
                case CANCEL: {
                    return;
                }
                case ERROR: {
                    DVTQuickAssistUtil.popSomethingWentWrong(this.getDisplayString());
                    return;
                }
            }
            IFile[] affectedFiles = this.getAffectedFiles();
            if (affectedFiles == null) {
                throw new Exception();
            }
            DVTFileModificationValidator.validateEdit(null, affectedFiles);
            this.applyQuickAssist(document);
        }
        catch (Exception e) {
            if (e instanceof CoreException && ((CoreException)((Object)e)).getStatus() == Status.CANCEL_STATUS) {
                return;
            }
            DVTQuickAssistUtil.popSomethingWentWrong(this.getDisplayString());
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getAdditionalProposalInfo() {
        if (this.hasError(false)) {
            String message = "An internal error has occured while computing the quick assist proposal. <br><br> Please send an issue report from menu <b>Help > DVT Quick Help > Report an issue.</b>";
            return message;
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        if (this.errorFlag == null) {
            this.errorFlag = new AtomicBoolean();
        }
        String result = null;
        try {
            result = this.getDisplayStringInternal();
        }
        catch (Exception e) {
            this.errorFlag.set(true);
            DVTLogger.INSTANCE.logError((Throwable)e);
            result = String.valueOf(this.getProposalName()) + " - Internal error occured";
        }
        return result;
    }

    protected void preApplyQuickAssist(IDocument document) throws Exception {
    }

    public Change getChange() {
        block4: {
            try {
                if (!(this.textFileChange != null && this.textFileChange.getEdit() != null && this.textFileChange.getEdit().getChildren().length != 0 || this.compositeChange != null && this.compositeChange.getChildren().length != 0)) {
                    this.preApplyQuickAssist(this.document);
                    this.createQuickAssistChanges();
                }
                if (this.textFileChange != null || this.compositeChange != null) break block4;
                return null;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return null;
            }
        }
        this.applyQuickAssist(this.document);
        return this.textFileChange != null ? this.textFileChange : this.compositeChange;
    }

    protected abstract CreateChangeStatus createQuickAssistChanges() throws Exception;

    protected abstract IFile[] getAffectedFiles() throws Exception;

    protected abstract void applyQuickAssist(IDocument var1) throws Exception;

    protected abstract String getDisplayStringInternal() throws Exception;

    protected abstract String getProposalName();

    public String getVscodeRefactorKind() {
        return this.vscodeRefactorKind;
    }

    public void setVscodeRefactorKind(String vscodeRefactorKind) {
        this.vscodeRefactorKind = vscodeRefactorKind;
    }

    public IDocument getTriggerDocument() {
        return this.document;
    }

    public void setTriggerDocument(IDocument document) {
        this.document = document;
    }
}

