/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickassist;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;

public class QuickAssistCreateWaiverProposal
implements ICompletionProposal {
    private static final String DISPLAY_STRING_MF = "Waive ''{0}'' {1}";
    private static final String INFO_STRING_MF = "<b>Waive {0}:</b><br>{1}<br><b>In file:</b><br>{2}";
    private static final String UNKNOWN_PROBLEM = "UNKNOWN_PROBLEM";
    private static final Pattern FIRST_WORD = Pattern.compile("\\s*(\\w+)");
    private IMarker fMarker;

    public QuickAssistCreateWaiverProposal(IMarker marker) {
        this.fMarker = marker;
    }

    public void apply(IDocument document) {
        String ID = "ro.amiq.dvt.problems.CreateWaiverFromProblem";
        IWorkbenchWindow activeWorkbenchWindow = Utils.getActiveWorkbenchWindow();
        IHandlerService handlerService = (IHandlerService)activeWorkbenchWindow.getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)activeWorkbenchWindow.getService(ICommandService.class);
        ParameterizedCommand createWaiversCommand = ParameterizedCommand.generateCommand((Command)commandService.getCommand(ID), null);
        try {
            Event event = new Event();
            event.data = this.fMarker;
            handlerService.executeCommand(createWaiversCommand, event);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String getDisplayString() {
        Matcher matcher;
        block5: {
            String message;
            block4: {
                try {
                    message = (String)this.fMarker.getAttribute("message");
                    if (message != null) break block4;
                    return UNKNOWN_PROBLEM;
                }
                catch (CoreException coreException) {
                    return UNKNOWN_PROBLEM;
                }
            }
            matcher = FIRST_WORD.matcher(message);
            if (matcher.find()) break block5;
            return UNKNOWN_PROBLEM;
        }
        return MessageFormat.format(DISPLAY_STRING_MF, matcher.group(1), this.markerSeverityToText(this.fMarker));
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.WAIVE);
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        try {
            String message = (String)this.fMarker.getAttribute("message");
            String severity = this.markerSeverityToText(this.fMarker);
            String path = this.fMarker.getResource().getLocation().toOSString();
            return MessageFormat.format(INFO_STRING_MF, severity, message, path);
        }
        catch (CoreException coreException) {
            return "";
        }
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    private String markerSeverityToText(IMarker marker) {
        int severity = 0;
        try {
            severity = (Integer)marker.getAttribute("severity");
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        switch (severity) {
            case 1: {
                return "warning";
            }
            case 2: {
                return "error";
            }
        }
        return "problem";
    }
}

