/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickassist.util;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DVTExtractToVariableDialog
extends TrayDialog {
    private Button fExtractToLocalVariableReplaceAll;
    private boolean fIsExtractToLocalVariableReplaceAll;
    private Text fVarNameText;
    private String fVarName;
    private String fSelection;
    private String fShellText;

    public DVTExtractToVariableDialog(Shell shell, String selection, String shellText) {
        super(shell);
        this.setHelpAvailable(false);
        this.fSelection = selection;
        this.fShellText = shellText;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fShellText);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite mainComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)mainComposite);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        Label replaceLabel = new Label(mainComposite, 0);
        replaceLabel.setText("Extract '" + this.fSelection.replaceAll("\\R", " ") + "' to local variable.");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)replaceLabel);
        Label varNameLabel = new Label(mainComposite, 0);
        varNameLabel.setText("Variable name:");
        GridDataFactory.fillDefaults().align(1, 0x1000000).grab(false, false).applyTo((Control)varNameLabel);
        this.fVarNameText = new Text(mainComposite, 2048);
        this.fVarNameText.setText("var_name");
        this.setVarName("var_name");
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fVarNameText);
        this.fVarNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DVTExtractToVariableDialog.this.setVarName(DVTExtractToVariableDialog.this.fVarNameText.getText());
            }
        });
        this.fExtractToLocalVariableReplaceAll = new Button(mainComposite, 32);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)this.fExtractToLocalVariableReplaceAll);
        this.fExtractToLocalVariableReplaceAll.setText("Replace all occurrences of the selected expression with references to the local variable");
        this.fExtractToLocalVariableReplaceAll.setVisible(true);
        this.fExtractToLocalVariableReplaceAll.setSelection(true);
        this.setIsExtractToLocalVariableReplaceAll(true);
        this.fExtractToLocalVariableReplaceAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (DVTExtractToVariableDialog.this.fExtractToLocalVariableReplaceAll.getSelection()) {
                    DVTExtractToVariableDialog.this.setIsExtractToLocalVariableReplaceAll(true);
                } else {
                    DVTExtractToVariableDialog.this.setIsExtractToLocalVariableReplaceAll(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public boolean isReplaceAll() {
        return this.fIsExtractToLocalVariableReplaceAll;
    }

    public void setIsExtractToLocalVariableReplaceAll(boolean fIsExtractToLocalVariableReplaceAll) {
        this.fIsExtractToLocalVariableReplaceAll = fIsExtractToLocalVariableReplaceAll;
    }

    public String getVarName() {
        return this.fVarName;
    }

    public void setVarName(String varNameString) {
        this.fVarName = varNameString;
    }
}

