/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickassist.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidVisitor;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;

public class DVTQuickAssistUtil {
    public static final String QUICK_ASSIST_PROPOSAL_CATEGORY = "QuickAssistProposalCategory_";
    public static final String BIND_METHOD_CALL_ARGUMENTS_BY_NAME = "Bind method call arguments by name";
    public static final String BIND_METHOD_CALL_ARGUMENTS_BY_POSITION = "Bind method call arguments by position";
    public static final String CONNECT_INSTANCE_PORTS_BY_NAME = "Connect instance ports by name";
    public static final String CONNECT_INSTANCE_PORTS_BY_POSITION = "Connect instance ports by position";
    public static final String EXPAND_PORT_CONNECTIONS = "Expand .* port connections";
    public static final String EXTRACT_TO_LOCAL_VARIABLE = "Extract to local variable";
    public static final String REPLACE_ALL_OCCURENCES = " (replace all occurrences)";
    public static final String EXTRACT_TO_MODULE = "Extract to module";
    public static final String ADD_PORT = "Add port";
    public static final String ADD_PARAMETER = "Add parameter";
    public static final String ADD_GENERIC = "Add generic";
    public static final String ADD_ARGUMENT = "Add argument";
    public static final String REMOVE_ARGUMENT = "Remove argument";
    public static final String REORDER_ARGUMENT = "Reorder argument";
    public static final String STR_SUBSTITUTOR_PREFIX = FindReplaceDocumentAdapter.escapeForRegExPattern((String)"$%^{");
    public static final String STR_SUBSTITUTOR_SUFFIX = FindReplaceDocumentAdapter.escapeForRegExPattern((String)"}^%$");
    public static final String EXPAND_MACRO = "Expand macro";
    public static final String COLLAPSE_MACRO = "Collapse macro";
    public static final String SPLIT_CONSTRAINT = "Split constraint into extern prototype and implementation";
    public static final String JOIN_CONSTRAINT = "Join extern constraint prototype and implementation";
    public static final String MOVE_SELECTION_TO_NEW_FILE = "Move selection to new file...";
    public static final String FORWARD_ALL_IMPLICIT_PORT_CONNECTIONS = "Forward all implicit port connections to";
    public static final String FORWARD_IMPLICIT_PORT_CONNECTION = "Forward implicit port connection ";

    public static void popSomethingWentWrong(final String proposalName) {
        if (TestHelper.isTestMode()) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), proposalName, null, "An error occurred while trying to apply the Quick Assist proposal: '" + proposalName + "'", 2, new String[]{"OK"}, 0);
                dialog.open();
            }
        });
    }

    public static void addFileEdit(DVTTextFileChange textFileChange, int editOffset, int editLength, String editText, int changeRelativeOffset, FileEditType textFileEditType, String varName) {
        switch (textFileEditType) {
            case INSERT: {
                InsertEdit initialisation = new InsertEdit(editOffset, editText);
                textFileChange.addEdit((TextEdit)initialisation, (IRegion)new Region(changeRelativeOffset, varName.length()));
                break;
            }
            case REPLACE: {
                ReplaceEdit replaceEdit = new ReplaceEdit(editOffset, editLength, varName);
                textFileChange.addEdit((TextEdit)replaceEdit, (IRegion)new Region(0, varName.length()));
            }
        }
    }

    public static boolean hasSemicolon(IDocument document, int startOffset, int endOffset, String partitioningType) throws BadLocationException, BadPartitioningException {
        int currentOffset = startOffset;
        while (currentOffset < endOffset) {
            char currentChar = document.getChar(currentOffset);
            String currentOffsetContentType = ((IDocumentExtension3)document).getContentType(partitioningType, currentOffset, false);
            if (currentChar == ';' && currentOffsetContentType.equals("__dftl_partition_content_type")) {
                return true;
            }
            ++currentOffset;
        }
        return false;
    }

    public static boolean selectionContainsOnlyLastPartOfHid(final IRfDefElement container, final int startOffset, final int endOffset) {
        final AtomicBoolean check = new AtomicBoolean();
        IRfNamedElement namedElement = container.getNamedElement();
        if (namedElement instanceof IRfLibraryElement) {
            return false;
        }
        namedElement.visitHidObject(null, new IHidVisitor<Hid>(){
            private ParserPath parserPath;

            @Override
            public void setParserPath(ParserPath parserPath) {
                this.parserPath = parserPath;
            }

            @Override
            public boolean visit(Hid hidObject) {
                if (!this.parserPath.equals(container.getParserPath())) {
                    return true;
                }
                if (DVTQuickFixUtil.isHidInSelection(hidObject, startOffset, endOffset)) {
                    Hid parent = hidObject;
                    while ((parent = parent.getParentHidIgnoreAccess(4)) != null) {
                        if (DVTQuickFixUtil.isHidInSelection(parent, startOffset, endOffset)) continue;
                        check.set(true);
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Class<Hid> getType() {
                return Hid.class;
            }
        });
        return check.get();
    }

    public static List<IRegion> getMultipleOccurrences(String selectedText, int startOffset, String scopeBody, String partitioning, IDocument document) throws BadLocationException, BadPartitioningException {
        String trimmedSelectedText = selectedText.replaceAll("\\b", " ").trim();
        String regexEscaped = FindReplaceDocumentAdapter.escapeForRegExPattern((String)trimmedSelectedText);
        regexEscaped = regexEscaped.replaceAll("\\\\R", " ");
        regexEscaped = regexEscaped.replaceAll("\\s+", "\\\\s\\*");
        if (Character.isJavaIdentifierPart(trimmedSelectedText.charAt(0))) {
            regexEscaped = "\\b" + regexEscaped;
        }
        if (Character.isJavaIdentifierPart(trimmedSelectedText.charAt(trimmedSelectedText.length() - 1))) {
            regexEscaped = String.valueOf(regexEscaped) + "\\b";
        }
        Matcher m = Pattern.compile(regexEscaped).matcher(scopeBody);
        ArrayList<IRegion> result = new ArrayList<IRegion>();
        while (m.find()) {
            Region region = new Region(startOffset + m.start(), m.end() - m.start());
            String regionOffsetContentType = ((IDocumentExtension3)document).getContentType(partitioning, region.getOffset(), false);
            if (!regionOffsetContentType.equals("__dftl_partition_content_type")) continue;
            result.add(0, (IRegion)region);
        }
        return result;
    }

    public static Map<String, String> makeCommentSubstMap(List<String> keys, List<String> values) {
        if (keys == null || values == null || keys.size() != values.size()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        int i = 0;
        while (i < keys.size()) {
            result.put(keys.get(i), values.get(i));
            ++i;
        }
        return result;
    }

    public static enum FileEditType {
        REPLACE,
        INSERT;

    }
}

