/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.quickfix.ExplainWithAIAssistantProposal;
import ro.amiq.dvt.ui.editor.quickfix.FixWithAIAssistantProposal;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtil;

public enum AIProblemAutocorrectUtils {
    INSTANCE;

    private static final String COMPUTING_AI_QUICK_FIX_PROPOSALS = "Computing AI Assistant problem auto-correct proposals...";
    private static final long COMPUTE_AI_QUICK_FIXES_JOB_TIMEOUT_MS = 5000L;

    public List<ICompletionProposal> getAIProposalsForMarker(final IMarker marker) {
        if (marker == null || !marker.exists()) {
            return null;
        }
        final String markerMessage = marker.getAttribute("message", null);
        if (markerMessage == null) {
            return null;
        }
        final IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor == null || !aiHostContributor.isAIModelsAvailable()) {
            return null;
        }
        final String filePath = this.getFilePathFromMarker(marker);
        IResource resource = marker.getResource();
        if (resource == null) {
            return null;
        }
        if (aiHostContributor.isFileProtected(filePath, resource.getProject())) {
            return null;
        }
        final ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        final AtomicBoolean jobDone = new AtomicBoolean(false);
        Job computeAIQFProposalsJob = new Job("Compute AI Assistant Problem Auto-correct Proposals Job"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    List<String> blueprintNames = aiHostContributor.getBlueprintsForProblem(markerMessage);
                    if (blueprintNames == null || blueprintNames.isEmpty()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    List proposals = blueprintNames.stream().map(blueprintName -> new FixWithAIAssistantProposal(marker, filePath, (String)blueprintName, blueprintNames.size() == 1)).collect(Collectors.toList());
                    if (monitor.isCanceled()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    result.addAll(proposals);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                finally {
                    jobDone.set(true);
                }
            }
        };
        computeAIQFProposalsJob.schedule();
        if (DVTUiUtils.isUiThread()) {
            DVTUiUtils.showBusyIndAndProgressMonitorAfterTImeout((Job)computeAIQFProposalsJob, (AtomicBoolean)jobDone, (String)COMPUTING_AI_QUICK_FIX_PROPOSALS, (long)(System.currentTimeMillis() + 1500L));
            result.add(new ExplainWithAIAssistantProposal(marker, filePath));
            return result;
        }
        DVTQuickFixUtil.busyWaitOnJob(jobDone, System.currentTimeMillis() + 5000L);
        result.add(new ExplainWithAIAssistantProposal(marker, filePath));
        return result;
    }

    public boolean isProblemAutocorrectAvailable(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return false;
        }
        IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor == null || !aiHostContributor.isAIModelsAvailable()) {
            return false;
        }
        String filePath = this.getFilePathFromMarker(marker);
        if (filePath == null) {
            return false;
        }
        IResource resource = marker.getResource();
        if (resource == null) {
            return false;
        }
        return !aiHostContributor.isFileProtected(filePath, resource.getProject());
    }

    public String getFilePathFromMarker(IMarker marker) {
        if (marker == null || !marker.exists()) {
            return null;
        }
        IPath location = marker.getResource().getLocation();
        return location != null ? location.toOSString() : null;
    }

    public boolean areModelsAvailableForQuickfix() {
        IAIHostContributor contributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (contributor == null) {
            return false;
        }
        return contributor.isAIModelsAvailable();
    }
}

