/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IMarkerResolution;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.semantic.extension2.DummyElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickfix.BCQuickFixUtil;
import ro.amiq.dvt.ui.editor.quickfix.ProblemsViewQuickFixGenerator;

public class BCProblemsViewQuickFixGenerator
extends ProblemsViewQuickFixGenerator {
    @Override
    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            if (!marker.exists()) {
                return new IMarkerResolution[0];
            }
            IResource resource = marker.getResource();
            if (resource == null) {
                return new IMarkerResolution[0];
            }
            if (!(resource instanceof IFile)) {
                return new IMarkerResolution[0];
            }
            IProject project = resource.getProject();
            if (project == null) {
                return new IMarkerResolution[0];
            }
            String elementName = (String)marker.getAttribute("QUICKFIX_ELEMENT_NAME");
            Integer quickFixKind = (Integer)marker.getAttribute("QUICKFIX_KIND");
            boolean isHierarchical = marker.getAttribute("QUICKFIX_HIERARCHICAL_ID", false);
            if (elementName == null || quickFixKind == null) {
                return new IMarkerResolution[0];
            }
            List<ICompletionProposal> proposalsByKind = this.getProposalsByKind(quickFixKind, isHierarchical, marker, null, null, -1, null, elementName);
            return proposalsByKind.toArray(new IMarkerResolution[proposalsByKind.size()]);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new IMarkerResolution[0];
        }
    }

    @Override
    public List<ICompletionProposal> getProposalsByKind(int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, IRfScopeElement scope, int offset, Position position, String elementName) {
        return BCQuickFixUtil.getInstance().getProposalsByKind(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, new ArrayList<ICompletionProposal>());
    }

    @Override
    public IRfScopeElement getRfScope(IResource file, int offset) {
        return new DummyElement("BCEditor");
    }
}

