/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.quickfix.BCQuickFixUtilCommon;
import ro.amiq.dvt.utils.DVTBuildUtils;

public class BCQuickFixUtil
extends BCQuickFixUtilCommon {
    private static BCQuickFixUtil INSTANCE;
    private static final Object SYNC_OBJECT;

    static {
        SYNC_OBJECT = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BCQuickFixUtil getInstance() {
        if (INSTANCE == null) {
            Object object = SYNC_OBJECT;
            synchronized (object) {
                INSTANCE = new BCQuickFixUtil();
            }
        }
        return INSTANCE;
    }

    @Override
    protected Image getImageDescriptor(String elementName, IMarker marker, java.nio.file.Path filePath, String languageSyntaxId) {
        try {
            IBuildConfigParserConstants.LanguageSyntax langSyntax = IBuildConfigParserConstants.LanguageSyntax.from(languageSyntaxId);
            IEditorRegistry editorRegistry = PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor defaultEditor = IDE.getEditorDescriptor((String)filePath.getFileName().toString());
            String editorId = langSyntax == null || langSyntax.languageKind == null ? defaultEditor.getId() : langSyntax.languageKind.EDITOR_ID;
            IEditorDescriptor editorDescriptor = editorRegistry.findEditor(editorId);
            ImageDescriptor imageDescriptor = editorDescriptor == null ? null : editorDescriptor.getImageDescriptor();
            return imageDescriptor == null ? null : DVTImages.imageCache.getImage(imageDescriptor);
        }
        catch (PartInitException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    @Override
    public List<ICompletionProposal> getProposalsByKind(final int quickFixKind, final boolean isHierarchical, final IMarker marker, final ITextViewer viewer, IRfScopeElement scope, final int offset, final Position position, final String elementName, final List<ICompletionProposal> proposals) {
        final ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        final AtomicBoolean done = new AtomicBoolean(false);
        Job computingQuickFixProposalJob = new Job("Compute Quick Fix Proposals Job"){

            protected IStatus run(IProgressMonitor monitor) {
                List<ICompletionProposal> proposalsByKindInternal = BCQuickFixUtil.this.getProposalsByKindInternal(quickFixKind, isHierarchical, marker, viewer, offset, position, elementName, proposals, monitor);
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                result.addAll(proposalsByKindInternal);
                done.set(true);
                return Status.OK_STATUS;
            }
        };
        computingQuickFixProposalJob.schedule();
        long busyIndicatorTimeout = System.currentTimeMillis() + 1500L;
        DVTUiUtils.showBusyIndAndProgressMonitorAfterTImeout((Job)computingQuickFixProposalJob, (AtomicBoolean)done, (String)"Computing quick fix proposals...", (long)busyIndicatorTimeout);
        return result;
    }

    @Override
    public CompletableFuture<Boolean> doProposeRebuild(IProject project, Path filePath) throws CoreException {
        int doBuild = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, "The error you are trying to fix might be obsolete. This file already exists:\n\n " + filePath.toOSString() + "\n\nIt is recommended to rebuild the project.", 4, new String[]{"Build Now", "Cancel"}, 0).open();
        if (doBuild == 0) {
            DVTBuildUtils.buildWithProgressDialog(project);
        }
        return CompletableFuture.completedFuture(doBuild == 0);
    }
}

