/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix;

import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.CreateFileFromBuildConfigQuickFix;

public abstract class BCQuickFixUtilCommon {
    protected List<ICompletionProposal> getProposalsByKindInternal(int quickFixKind, boolean isHierarchical, IMarker marker, ITextViewer viewer, int offset, Position position, String elementName, List<ICompletionProposal> existingProposals, IProgressMonitor monitor) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        try {
            switch (quickFixKind) {
                case 39: {
                    IPath location;
                    IProject project;
                    IResource resource = marker.getResource();
                    if (!(resource instanceof IFile) || (project = resource.getProject()) == null || (location = project.getLocation()) == null) break;
                    List<CreateFileFromBuildConfigQuickFix> createFileProposals = this.collectCreateFileProposals(elementName, (IFile)resource, marker, viewer, offset, position, project, location);
                    if (createFileProposals != null && !createFileProposals.isEmpty()) {
                        proposals.addAll(createFileProposals);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return proposals;
    }

    private List<CreateFileFromBuildConfigQuickFix> collectCreateFileProposals(String elementName, IFile buildFile, IMarker marker, ITextViewer viewer, int offset, Position position, IProject project, IPath projectLocation) throws Exception {
        ArrayList<CreateFileFromBuildConfigQuickFix> proposals = new ArrayList<CreateFileFromBuildConfigQuickFix>();
        LinkedHashSet<java.nio.file.Path> includingDirPaths = new LinkedHashSet<java.nio.file.Path>();
        String pathRootsString = marker.getAttribute("BUILD_CONFIG_ROOT_PATHS", null);
        String[] pathRoots = pathRootsString == null ? null : pathRootsString.split("\n");
        java.nio.file.Path filePath = Paths.get(elementName, new String[0]);
        int line = marker.getAttribute("lineNumber", -1);
        if (line < 0) {
            return proposals;
        }
        String languageSyntaxId = marker.getAttribute("LANGUAGE_SYNTAX_INFO", null);
        Image image = this.getImageDescriptor(elementName, marker, filePath, languageSyntaxId);
        if (pathRoots != null) {
            String[] stringArray = pathRoots;
            int n = pathRoots.length;
            int n2 = 0;
            while (n2 < n) {
                String pathRoot = stringArray[n2];
                includingDirPaths.add(Paths.get(pathRoot, new String[0]));
                ++n2;
            }
        } else {
            includingDirPaths.add(filePath);
        }
        if (includingDirPaths.isEmpty()) {
            return proposals;
        }
        java.nio.file.Path includePath = filePath.normalize();
        if (includePath.getFileName() == null) {
            return proposals;
        }
        HashSet<java.nio.file.Path> proposalFilePaths = new HashSet<java.nio.file.Path>();
        for (java.nio.file.Path includingDir : includingDirPaths) {
            java.nio.file.Path filePathInIncDir = includingDir.resolve(includePath);
            java.nio.file.Path normalizedFilePathInIncDir = filePathInIncDir.normalize();
            java.nio.file.Path parentOfFileInIncDir = filePathInIncDir.getParent();
            if (proposalFilePaths.contains(normalizedFilePathInIncDir) || parentOfFileInIncDir == null || !Files.isWritable(parentOfFileInIncDir) || !Files.isExecutable(parentOfFileInIncDir)) continue;
            proposalFilePaths.add(normalizedFilePathInIncDir);
            CreateFileFromBuildConfigQuickFix proposal = new CreateFileFromBuildConfigQuickFix(marker, viewer, filePathInIncDir.toFile(), languageSyntaxId, image);
            proposal.setParameters(offset, position, buildFile, elementName);
            proposals.add(proposal);
        }
        final java.nio.file.Path proposalToPromote = pathRoots != null && pathRoots.length > 0 ? Paths.get(pathRoots[0], new String[0]) : Paths.get(projectLocation.toOSString(), new String[0]);
        proposals.sort(new Comparator<CreateFileFromBuildConfigQuickFix>(){

            @Override
            public int compare(CreateFileFromBuildConfigQuickFix o1, CreateFileFromBuildConfigQuickFix o2) {
                String parentDir1 = o1.getFileParentDir();
                String parentDir2 = o2.getFileParentDir();
                if (parentDir1.equals(proposalToPromote.toString())) {
                    return -1;
                }
                if (parentDir2.equals(proposalToPromote.toString())) {
                    return 1;
                }
                return parentDir1.compareTo(parentDir2);
            }
        });
        return proposals;
    }

    protected abstract Image getImageDescriptor(String var1, IMarker var2, java.nio.file.Path var3, String var4);

    public abstract CompletableFuture<Boolean> doProposeRebuild(IProject var1, Path var2) throws CoreException;

    public abstract List<ICompletionProposal> getProposalsByKind(int var1, boolean var2, IMarker var3, ITextViewer var4, IRfScopeElement var5, int var6, Position var7, String var8, List<ICompletionProposal> var9);
}

