/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.model.reflection.RfMixedLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quick.proposals.QuickProposalPriorityByType;
import ro.amiq.dvt.ui.editor.quick.proposals.QuickProposalsPriorityComparator;
import ro.amiq.dvt.ui.editor.quick.proposals.QuickProposalsWrapper;
import ro.amiq.dvt.ui.editor.quickassist.QuickAssistCreateWaiverProposal;
import ro.amiq.dvt.ui.editor.quickfix.AIProblemAutocorrectUtils;
import ro.amiq.dvt.ui.editor.quickfix.ExplainWithAIAssistantProposal;
import ro.amiq.dvt.ui.editor.quickfix.FixWithAIAssistantProposal;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixAnnotationPriority;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixAnnotationWrapper;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixConstants;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtilCommon;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class EditorQuickFixProcessor
implements IContentAssistProcessor {
    protected ITextEditor fTextEditor;

    public EditorQuickFixProcessor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        List<QuickProposalsWrapper> createWaiverQuickAssistProposals;
        List<QuickProposalsWrapper> quickAssistProposals;
        String selectionText;
        IDocument document = ((DVTEditor)this.fTextEditor).getDocument();
        int lineOfOffset = -1;
        try {
            lineOfOffset = document.getLineOfOffset(offset);
        }
        catch (BadLocationException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        boolean isSelection = false;
        ISelection selection = viewer.getSelectionProvider().getSelection();
        if (selection instanceof ITextSelection && (selectionText = ((ITextSelection)selection).getText()) != null && !selectionText.isEmpty()) {
            isSelection = true;
        }
        ArrayList<QuickProposalsWrapper> quickProposalsByPriority = new ArrayList<QuickProposalsWrapper>();
        IAnnotationModel annotationModel = EditorQuickFixProcessor.getAnnotationModel(this.fTextEditor);
        List<QuickFixAnnotationWrapper> annotationsAndPriority = null;
        if (annotationModel != null) {
            annotationsAndPriority = this.collectQuickFixMarkers(offset, document, lineOfOffset, annotationModel);
            List<QuickProposalsWrapper> quickFixProposals = this.collectQuickFixProposalsFromMarkers(viewer, offset, document, annotationModel, annotationsAndPriority);
            if (!quickFixProposals.isEmpty()) {
                quickProposalsByPriority.addAll(quickFixProposals);
            }
            IProject project = ((DVTEditor)this.fTextEditor).getProject();
            RfMixedLangProject rfProject = RfMixedLangManager.getInstance().getRfMixedLangProject(project, false);
            if (rfProject == null) {
                return null;
            }
            boolean isLinting = rfProject.isLinting();
            if (isLinting) {
                List<QuickProposalsWrapper> lintingAutofixProposals;
                List<QuickFixAnnotationWrapper> lintingAnnotations = this.collectLintingMarkers(offset, document, lineOfOffset, annotationModel);
                List<QuickProposalsWrapper> lintingWaiveProposals = this.getLintingWaiveHitsProposalsFromMarkers(lintingAnnotations);
                if (lintingWaiveProposals != null && !lintingWaiveProposals.isEmpty()) {
                    quickProposalsByPriority.addAll(lintingWaiveProposals);
                }
                if ((lintingAutofixProposals = this.getLintingAutofixProposalsFromMarkers(lintingAnnotations)) != null && !lintingAutofixProposals.isEmpty()) {
                    quickProposalsByPriority.addAll(lintingAutofixProposals);
                }
                String filePath = this.fTextEditor instanceof DVTEditor ? DVTFileUtils.getInstance().getFilePath((DVTEditor)this.fTextEditor) : null;
                IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
                if (aiHostContributor != null && !aiHostContributor.isFileProtected(filePath, project) && aiHostContributor.isAIModelsAvailable()) {
                    List<QuickProposalsWrapper> explainAIProposals;
                    List<QuickProposalsWrapper> lintingAIAutofixProposals = this.getLintingAIAutofixProposalsFromMarkers(lintingAnnotations);
                    if (lintingAIAutofixProposals != null && !lintingAIAutofixProposals.isEmpty()) {
                        quickProposalsByPriority.addAll(lintingAIAutofixProposals);
                    }
                    if ((explainAIProposals = this.getLintingAIExplainProposalsFromMarkers(lintingAnnotations)) != null && !explainAIProposals.isEmpty()) {
                        quickProposalsByPriority.addAll(explainAIProposals);
                    }
                }
            }
        }
        if ((quickAssistProposals = this.collectQuickAssistProposals(viewer, offset)) != null && !quickAssistProposals.isEmpty()) {
            quickProposalsByPriority.addAll(quickAssistProposals);
        }
        if (annotationsAndPriority != null && !annotationsAndPriority.isEmpty() && (createWaiverQuickAssistProposals = this.collectCreateWaiverQuickAssistProposals(annotationsAndPriority, offset)) != null && !createWaiverQuickAssistProposals.isEmpty()) {
            quickProposalsByPriority.addAll(createWaiverQuickAssistProposals);
        }
        List<ICompletionProposal> allProposalsSorted = this.getAllProposalsSorted(quickProposalsByPriority, isSelection);
        return allProposalsSorted.toArray(new ICompletionProposal[allProposalsSorted.size()]);
    }

    private List<ICompletionProposal> getAllProposalsSorted(List<QuickProposalsWrapper> quickProposalsByPriority, boolean isSelection) {
        ArrayList<ICompletionProposal> proposalsResult = new ArrayList<ICompletionProposal>();
        QuickProposalsPriorityComparator quickProposalsPriorityComparator = new QuickProposalsPriorityComparator(isSelection);
        Collections.sort(quickProposalsByPriority, quickProposalsPriorityComparator);
        for (QuickProposalsWrapper quickProposalByPriority : quickProposalsByPriority) {
            proposalsResult.add(quickProposalByPriority.getQuickProposal());
        }
        return proposalsResult;
    }

    public List<QuickProposalsWrapper> collectQuickAssistProposals(ITextViewer viewer, int offset) {
        ArrayList<QuickProposalsWrapper> result = new ArrayList<QuickProposalsWrapper>();
        ICompletionProposal[] quickAssistProposalsArray = this.getQuickAssistProposals(viewer);
        if (quickAssistProposalsArray == null) {
            return null;
        }
        List<ICompletionProposal> quickAssistProposals = Arrays.asList(quickAssistProposalsArray);
        for (ICompletionProposal quickAssistProposal : quickAssistProposals) {
            result.add(new QuickProposalsWrapper(quickAssistProposal, QuickProposalPriorityByType.QUICK_ASSIST, offset));
        }
        return result;
    }

    private List<QuickProposalsWrapper> collectQuickFixProposalsFromMarkers(ITextViewer viewer, int offset, IDocument document, IAnnotationModel annotationModel, List<QuickFixAnnotationWrapper> annotationsAndPriority) {
        ArrayList<QuickProposalsWrapper> quickFixProposals = new ArrayList<QuickProposalsWrapper>();
        ArrayList<ICompletionProposal> existingProposals = new ArrayList<ICompletionProposal>();
        for (QuickFixAnnotationWrapper annotationAndPriority : annotationsAndPriority) {
            try {
                if (annotationAndPriority.getQuickFixProposalPriority() == QuickFixAnnotationPriority.WAIVER_AT_CURSOR || annotationAndPriority.getQuickFixProposalPriority() == QuickFixAnnotationPriority.WAIVER_AT_LINE) continue;
                MarkerAnnotation annotation = annotationAndPriority.getAnnotation();
                List<ICompletionProposal> proposalsByKind = this.getProposalsFromMarker(annotationModel, annotation, viewer, offset, existingProposals, true);
                existingProposals.addAll(proposalsByKind);
                for (ICompletionProposal proposalByKind : proposalsByKind) {
                    QuickProposalsWrapper quickFixWrapper = proposalByKind instanceof FixWithAIAssistantProposal || proposalByKind instanceof ExplainWithAIAssistantProposal ? new QuickProposalsWrapper(proposalByKind, QuickProposalPriorityByType.AI_FIX_AND_EXPLAIN, annotationAndPriority.getMarkerOffset()) : new QuickProposalsWrapper(proposalByKind, QuickProposalPriorityByType.QUICK_FIX, annotationAndPriority.getMarkerOffset());
                    quickFixWrapper.setQuickFixAnnotationPriority(annotationAndPriority.getQuickFixProposalPriority());
                    quickFixProposals.add(quickFixWrapper);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        HashSet<String> duplicatePrecompiledQuickFixes = new HashSet<String>();
        Iterator it = quickFixProposals.iterator();
        while (it.hasNext()) {
            QuickProposalsWrapper wrapper = (QuickProposalsWrapper)it.next();
            ICompletionProposal proposal = wrapper.getQuickProposal();
            if (!(proposal instanceof DVTQuickFixUtilCommon.PrecompiledQuickFix)) continue;
            String displayString = proposal.getDisplayString();
            if (duplicatePrecompiledQuickFixes.contains(displayString)) {
                it.remove();
                continue;
            }
            duplicatePrecompiledQuickFixes.add(displayString);
        }
        return quickFixProposals;
    }

    public List<ICompletionProposal> getProposalsFromMarker(IAnnotationModel annotationModel, MarkerAnnotation annotation, ITextViewer viewer, int offset, List<ICompletionProposal> existingProposals, boolean startMonitorJob) throws BadLocationException {
        IDocument document;
        if (viewer == null || annotation == null) {
            return Collections.emptyList();
        }
        IMarker marker = annotation.getMarker();
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        List<ICompletionProposal> aiProposals = this.getAIProposalsForMarker(marker, annotation);
        if (aiProposals != null && !aiProposals.isEmpty()) {
            HashSet existingAiProposals = new HashSet();
            existingProposals.stream().filter(proposal -> this.isAiAssistantProposal((ICompletionProposal)proposal)).forEach(aiProposal -> existingAiProposals.add(aiProposal.getDisplayString()));
            result.addAll(aiProposals.stream().filter(aiProposal -> !existingAiProposals.contains(aiProposal.getDisplayString())).collect(Collectors.toList()));
        }
        if ((document = viewer.getDocument()) == null) {
            return result;
        }
        Position position = annotationModel.getPosition((Annotation)annotation);
        String elementName = marker.getAttribute("QUICKFIX_ELEMENT_NAME", "");
        int scopeOffset = marker.getAttribute("charStart", -1);
        if (scopeOffset == -1) {
            int line = marker.getAttribute("lineNumber", 1);
            scopeOffset = document.getLineOffset(line - 1);
        }
        int quickFixKind = marker.getAttribute("QUICKFIX_KIND", -1);
        boolean isHierarchical = marker.getAttribute("QUICKFIX_HIERARCHICAL_ID", false);
        if (elementName == null || quickFixKind == -1) {
            return result;
        }
        if (!QuickFixConstants.IMPLEMENTED_QUICK_FIXES.contains(quickFixKind)) {
            return result;
        }
        IRfScopeElement scope = this.getRfScope(this.fTextEditor, document, scopeOffset);
        if (scope == null) {
            return result;
        }
        List<ICompletionProposal> proposalsByKind = this.getProposalsByKind(quickFixKind, isHierarchical, marker, viewer, scope, offset, position, elementName, existingProposals, startMonitorJob);
        if (proposalsByKind != null) {
            result.addAll(proposalsByKind);
        }
        return result;
    }

    private List<ICompletionProposal> getAIProposalsForMarker(IMarker marker, MarkerAnnotation annotation) {
        if (marker == null || annotation == null) {
            return null;
        }
        if (this.isLintingMarker(annotation)) {
            return null;
        }
        return AIProblemAutocorrectUtils.INSTANCE.getAIProposalsForMarker(marker);
    }

    private List<QuickProposalsWrapper> collectCreateWaiverQuickAssistProposals(List<QuickFixAnnotationWrapper> annotationsAndPriority, int offset) {
        ArrayList<QuickProposalsWrapper> result = new ArrayList<QuickProposalsWrapper>();
        QuickProposalsWrapper firstProposalAtLine = null;
        for (QuickFixAnnotationWrapper annotationAndPriority : annotationsAndPriority) {
            QuickAssistCreateWaiverProposal createWaiverQuickAssist;
            if (this.isLintingMarker(annotationAndPriority.getAnnotation())) continue;
            if (annotationAndPriority.getQuickFixProposalPriority() == QuickFixAnnotationPriority.WAIVER_AT_CURSOR) {
                createWaiverQuickAssist = new QuickAssistCreateWaiverProposal(annotationAndPriority.getAnnotation().getMarker());
                result.add(new QuickProposalsWrapper(createWaiverQuickAssist, QuickProposalPriorityByType.CREATE_WAIVER, annotationAndPriority.getMarkerOffset()));
                break;
            }
            if (annotationAndPriority.getQuickFixProposalPriority() != QuickFixAnnotationPriority.WAIVER_AT_LINE) continue;
            createWaiverQuickAssist = new QuickAssistCreateWaiverProposal(annotationAndPriority.getAnnotation().getMarker());
            if (firstProposalAtLine != null && firstProposalAtLine.getProposalOffset() <= annotationAndPriority.getMarkerOffset()) continue;
            firstProposalAtLine = new QuickProposalsWrapper(createWaiverQuickAssist, QuickProposalPriorityByType.CREATE_WAIVER, annotationAndPriority.getMarkerOffset());
        }
        if (result.isEmpty() && firstProposalAtLine != null) {
            result.add(firstProposalAtLine);
        }
        return result;
    }

    private List<QuickFixAnnotationWrapper> collectQuickFixMarkers(int offset, IDocument document, int lineOfOffset, IAnnotationModel annotationModel) {
        ArrayList<QuickFixAnnotationWrapper> annotationsAndPriority = new ArrayList<QuickFixAnnotationWrapper>();
        Iterator iter = annotationModel.getAnnotationIterator();
        while (iter.hasNext()) {
            Annotation annotation = (Annotation)iter.next();
            if (!(annotation instanceof MarkerAnnotation)) continue;
            IMarker marker = ((MarkerAnnotation)annotation).getMarker();
            Position position = annotationModel.getPosition(annotation);
            try {
                if (!this.getProblemMarkerIds().contains(marker.getType())) continue;
                int markerPositionOffset = position.getOffset();
                if (offset >= markerPositionOffset && offset <= markerPositionOffset + position.getLength()) {
                    annotationsAndPriority.add(new QuickFixAnnotationWrapper((MarkerAnnotation)annotation, QuickFixAnnotationPriority.WAIVER_AT_CURSOR, markerPositionOffset));
                } else if (lineOfOffset == document.getLineOfOffset(markerPositionOffset)) {
                    annotationsAndPriority.add(new QuickFixAnnotationWrapper((MarkerAnnotation)annotation, QuickFixAnnotationPriority.WAIVER_AT_LINE, markerPositionOffset));
                }
                if (!this.getQuickFixMarkerIds().contains(marker.getType())) continue;
                if (offset >= markerPositionOffset && offset <= markerPositionOffset + position.getLength()) {
                    annotationsAndPriority.add(new QuickFixAnnotationWrapper((MarkerAnnotation)annotation, QuickFixAnnotationPriority.CURSOR, markerPositionOffset));
                    continue;
                }
                if (lineOfOffset != document.getLineOfOffset(markerPositionOffset)) continue;
                annotationsAndPriority.add(new QuickFixAnnotationWrapper((MarkerAnnotation)annotation, QuickFixAnnotationPriority.LINE, markerPositionOffset));
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
        return annotationsAndPriority;
    }

    public abstract ICompletionProposal[] getQuickAssistProposals(ITextViewer var1);

    public abstract Set<String> getQuickFixMarkerIds();

    public abstract Set<String> getProblemMarkerIds();

    public abstract List<ICompletionProposal> getProposalsByKind(int var1, boolean var2, IMarker var3, ITextViewer var4, IRfScopeElement var5, int var6, Position var7, String var8, List<ICompletionProposal> var9, boolean var10);

    public abstract IRfScopeElement getRfScope(ITextEditor var1, IDocument var2, int var3);

    public abstract Comparator<? super ICompletionProposal> getProposalsSorter();

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public static IAnnotationModel getAnnotationModel(ITextEditor textEditor) {
        IDocumentProvider documentProvider = textEditor.getDocumentProvider();
        if (documentProvider != null) {
            return documentProvider.getAnnotationModel((Object)textEditor.getEditorInput());
        }
        return null;
    }

    public List<QuickFixAnnotationWrapper> collectLintingMarkers(int offset, IDocument document, int lineOfOffset, IAnnotationModel annotationModel) {
        return null;
    }

    public List<QuickProposalsWrapper> getLintingAutofixProposalsFromMarkers(List<QuickFixAnnotationWrapper> lintingAnnotations) {
        return null;
    }

    public List<QuickProposalsWrapper> getLintingAIAutofixProposalsFromMarkers(List<QuickFixAnnotationWrapper> lintingAnnotations) {
        return null;
    }

    public List<QuickProposalsWrapper> getLintingAIExplainProposalsFromMarkers(List<QuickFixAnnotationWrapper> lintingAnnotations) {
        return null;
    }

    public List<QuickProposalsWrapper> getLintingWaiveHitsProposalsFromMarkers(List<QuickFixAnnotationWrapper> lintingAnnotations) {
        return null;
    }

    public boolean isLintingMarker(MarkerAnnotation annotation) {
        return false;
    }

    public boolean isAiAssistantProposal(ICompletionProposal proposal) {
        Class<?> class1 = proposal.getClass();
        return class1.equals(FixWithAIAssistantProposal.class) || class1.equals(ExplainWithAIAssistantProposal.class);
    }
}

