/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution2;
import ro.amiq.dvt.ai.AIHostContributorManager;
import ro.amiq.dvt.ai.IAIHostContributor;
import ro.amiq.dvt.ui.DVTImages;

public class ExplainWithAIAssistantProposal
implements ICompletionProposal,
IMarkerResolution2 {
    private IMarker fMarker;
    private String fFilePath;

    public ExplainWithAIAssistantProposal(IMarker marker, String filePath) {
        this.fMarker = marker;
        this.fFilePath = filePath;
    }

    public void apply(IDocument document) {
        this.runInternal();
    }

    public void run(IMarker marker) {
        this.runInternal();
    }

    private void runInternal() {
        final IAIHostContributor aiHostContributor = AIHostContributorManager.INSTANCE.getAiHostContributor();
        if (aiHostContributor == null) {
            return;
        }
        Job fixWithAIAssistantJob = new Job("Explain Problem using AI Assistant Job"){

            protected IStatus run(IProgressMonitor monitor) {
                aiHostContributor.explainProblem(ExplainWithAIAssistantProposal.this.fMarker, ExplainWithAIAssistantProposal.this.fFilePath);
                return Status.OK_STATUS;
            }
        };
        fixWithAIAssistantJob.schedule();
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        String message = this.fMarker.getAttribute("message", null);
        int severity = this.fMarker.getAttribute("severity", 0);
        String severityString = null;
        if (severity == 2) {
            severityString = "error";
        } else if (severity == 1) {
            severityString = "warning";
        } else {
            return null;
        }
        return "Explain '" + message.split(":")[0] + "' " + severityString + " using DVT AI Assistant";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.AI_ASSISTANT);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getLabel() {
        return this.getDisplayString();
    }

    public String getDescription() {
        return this.getDisplayString();
    }
}

