/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import ro.amiq.dvt.model.problems.EProblemCategories;
import ro.amiq.dvt.model.problems.VhdlProblemCategories;
import ro.amiq.dvt.model.problems.VlogProblemCategories;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.quickfix.AIProblemAutocorrectUtils;
import ro.amiq.dvt.ui.editor.quickfix.QuickFixConstants;

public abstract class ProblemsViewQuickFixGenerator
implements IMarkerResolutionGenerator2 {
    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            if (!marker.exists()) {
                return new IMarkerResolution[0];
            }
            IResource resource = marker.getResource();
            if (resource == null) {
                return new IMarkerResolution[0];
            }
            IProject project = resource.getProject();
            if (project == null) {
                return new IMarkerResolution[0];
            }
            String elementName = (String)marker.getAttribute("QUICKFIX_ELEMENT_NAME");
            Integer scopeOffset = (Integer)marker.getAttribute("charStart");
            Integer quickFixKind = (Integer)marker.getAttribute("QUICKFIX_KIND");
            boolean isHierarchical = marker.getAttribute("QUICKFIX_HIERARCHICAL_ID", false);
            ArrayList<ICompletionProposal> allProposals = new ArrayList<ICompletionProposal>();
            List<ICompletionProposal> aiProposals = AIProblemAutocorrectUtils.INSTANCE.getAIProposalsForMarker(marker);
            if (aiProposals != null) {
                allProposals.addAll(aiProposals);
            }
            if (elementName == null || scopeOffset == null || quickFixKind == null) {
                return allProposals.toArray(new IMarkerResolution[allProposals.size()]);
            }
            IRfScopeElement scope = this.getRfScope(resource, scopeOffset);
            if (scope == null) {
                return allProposals.toArray(new IMarkerResolution[allProposals.size()]);
            }
            Integer endOffset = (Integer)marker.getAttribute("charEnd");
            DVTPosition position = new DVTPosition(scopeOffset, endOffset - scopeOffset);
            List<ICompletionProposal> proposalsByKind = this.getProposalsByKind(quickFixKind, isHierarchical, marker, null, scope, scopeOffset + 1, position, elementName);
            if (proposalsByKind != null) {
                allProposals.addAll(proposalsByKind);
            }
            return allProposals.toArray(new IMarkerResolution[allProposals.size()]);
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return new IMarkerResolution[0];
        }
    }

    public abstract List<ICompletionProposal> getProposalsByKind(int var1, boolean var2, IMarker var3, ITextViewer var4, IRfScopeElement var5, int var6, Position var7, String var8);

    public abstract IRfScopeElement getRfScope(IResource var1, int var2);

    public boolean hasResolutions(IMarker marker) {
        return ProblemsViewQuickFixGenerator.isQuickfixable(marker);
    }

    public static boolean isQuickfixable(IMarker marker) {
        int quickFixKind;
        block16: {
            block15: {
                block14: {
                    block13: {
                        try {
                            if (marker.exists()) break block13;
                            return false;
                        }
                        catch (CoreException coreException) {
                            return false;
                        }
                    }
                    boolean result = false;
                    if (marker.getResource().getProject().hasNature("ro.amiq.vlogdt.VlogNature") && VlogProblemCategories.QUICKFIXABLE_PROBLEMS.contains(marker.getType())) {
                        result = true;
                    }
                    if (marker.getResource().getProject().hasNature("ro.amiq.edt.enature") && EProblemCategories.QUICKFIXABLE_PROBLEMS.contains(marker.getType())) {
                        result = true;
                    }
                    if (marker.getResource().getProject().hasNature("ro.amiq.slndt.slnnature") && EProblemCategories.QUICKFIXABLE_PROBLEMS.contains(marker.getType())) {
                        result = true;
                    }
                    if (marker.getResource().getProject().hasNature("ro.amiq.msdldt.msdlnature") && EProblemCategories.QUICKFIXABLE_PROBLEMS.contains(marker.getType())) {
                        result = true;
                    }
                    if (marker.getResource().getProject().hasNature("ro.amiq.pssdt.pssnature") && EProblemCategories.QUICKFIXABLE_PROBLEMS.contains(marker.getType())) {
                        result = true;
                    }
                    if (marker.getResource().getProject().hasNature("ro.amiq.vhdldt.VhdlNature") && VhdlProblemCategories.QUICKFIXABLE_PROBLEMS.contains(marker.getType())) {
                        result = true;
                    }
                    if (marker.getType().equals("ro.amiq.vlogdt.LintingErrorMarker")) {
                        boolean hasAutofixImplemented = marker.getAttribute("ro.amiq.vlogdt.linter.ui.LintingProblemsManager.ImplementedAutofixAttribute", false);
                        boolean AIAvailable = AIProblemAutocorrectUtils.INSTANCE.areModelsAvailableForQuickfix();
                        return result && (hasAutofixImplemented || AIAvailable);
                    }
                    if (result) break block14;
                    return false;
                }
                if (!AIProblemAutocorrectUtils.INSTANCE.isProblemAutocorrectAvailable(marker)) break block15;
                return true;
            }
            Object attribute = marker.getAttribute("QUICKFIX_ELEMENT_NAME");
            quickFixKind = marker.getAttribute("QUICKFIX_KIND", -1);
            if (attribute != null && quickFixKind != -1) break block16;
            return false;
        }
        return QuickFixConstants.IMPLEMENTED_QUICK_FIXES.contains(quickFixKind);
    }
}

