/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix.quickfixes;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickfix.EditorQuickFixProcessor;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.AbstractQuickFixCommon;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;

public abstract class AbstractQuickFix
extends AbstractQuickFixCommon {
    protected AbstractQuickFix(IMarker marker, ITextViewer viewer) {
        super(marker, viewer);
    }

    public final void apply(IDocument document) {
        try {
            boolean editorChanged = this.initFieldsAndCreateQuickFixChanges(document);
            IFile[] affectedFiles = this.getAffectedFiles();
            if (affectedFiles == null) {
                throw new Exception();
            }
            DVTFileModificationValidator.validateEdit(null, affectedFiles);
            this.applyQuickFix(document, editorChanged);
        }
        catch (Exception e) {
            if (e instanceof CoreException && ((CoreException)((Object)e)).getStatus() == Status.CANCEL_STATUS) {
                return;
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
            MessageDialog.open((int)1, (Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"QuickFix Error", (String)"An error occurred while trying to apply the QuickFix proposal.", (int)0);
        }
    }

    protected IRfDefElement getDeclarationInFile(IRfNamedElement element, int includeOffset) {
        Collection<? extends IRfDefElement> declarations = element.getDeclarations();
        for (IRfDefElement iRfDefElement : declarations) {
            IResource declResource = (IResource)iRfDefElement.getDefFile().getAdapter(IResource.class);
            if (declResource == null || !declResource.equals((Object)this.marker.getResource()) || includeOffset < iRfDefElement.getStartOffset() || includeOffset > iRfDefElement.getEndOffset()) continue;
            return iRfDefElement;
        }
        return null;
    }

    protected IRfDefElement getDeclarationInFile(IRfNamedElement element) {
        Collection<? extends IRfDefElement> declarations = element.getDeclarations();
        for (IRfDefElement iRfDefElement : declarations) {
            IResource declResource = (IResource)iRfDefElement.getDefFile().getAdapter(IResource.class);
            if (declResource == null || !declResource.equals((Object)this.marker.getResource())) continue;
            return iRfDefElement;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DVTEditor getTextEditor() {
        try {
            if (!this.triggerResource.equals((Object)this.targetResource)) {
                if (this.targetResource == null || !(this.targetResource instanceof IFile)) {
                    return null;
                }
                IEditorPart textEditor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)this.targetResource));
                if (!(textEditor instanceof DVTEditor)) {
                    return null;
                }
                return (DVTEditor)textEditor;
            }
            IEditorPart textEditor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IMarker)this.marker);
            if (!(textEditor instanceof DVTEditor)) {
                return null;
            }
            return (DVTEditor)textEditor;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public void run(IMarker marker) {
        try {
            this.initTriggerAndTarget(null);
            DVTEditor textEditor = this.getTextEditor();
            if (textEditor == null) {
                return;
            }
            IDocument document = textEditor.getDocument();
            this.viewer = textEditor.getTextViewer();
            this.triggerDocument = this.targetDocument = document;
            this.preApplyQuickFix(document);
            textEditor = this.getTextEditor();
            if (textEditor == null) {
                return;
            }
            this.targetEditor = textEditor;
            ITextViewer tmpViewer = textEditor.getTextViewer();
            this.tabWidth = textEditor.getTabWidth();
            boolean editorChanged = tmpViewer != this.viewer && this.viewer != null && tmpViewer != null;
            this.viewer = tmpViewer;
            String elementName = (String)marker.getAttribute("QUICKFIX_ELEMENT_NAME");
            Integer scopeOffset = (Integer)marker.getAttribute("charStart");
            Position updatedPosition = this.updatePositionUsingAnnotation((IEditorPart)textEditor, marker, this.position);
            if (this.enclosingScope != null) {
                this.setParameters((int)scopeOffset, updatedPosition, this.enclosingScope, elementName);
            } else {
                this.setParameters(scopeOffset == null ? -1 : scopeOffset, updatedPosition, this.buildFile, elementName);
            }
            this.targetDocument = document = textEditor.getDocument();
            this.createQuickFixChanges(document, editorChanged);
            IFile[] affectedFiles = this.getAffectedFiles();
            if (affectedFiles == null) {
                throw new Exception();
            }
            DVTFileModificationValidator.validateEdit(null, affectedFiles);
            this.applyQuickFix(document, editorChanged);
        }
        catch (Exception e) {
            if (e instanceof CoreException && ((CoreException)((Object)e)).getStatus() == Status.CANCEL_STATUS) {
                return;
            }
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private Position updatePositionUsingAnnotation(IEditorPart textEditor, IMarker markerToFind, Position defaultPosition) {
        try {
            IAnnotationModel annotationModel = EditorQuickFixProcessor.getAnnotationModel((ITextEditor)textEditor);
            if (annotationModel != null) {
                Iterator iter = annotationModel.getAnnotationIterator();
                while (iter.hasNext()) {
                    IMarker marker;
                    Annotation annotation = (Annotation)iter.next();
                    if (!(annotation instanceof MarkerAnnotation) || !(marker = ((MarkerAnnotation)annotation).getMarker()).equals((Object)markerToFind)) continue;
                    return annotationModel.getPosition(annotation);
                }
            }
        }
        catch (Exception exception) {}
        return defaultPosition;
    }

    @Override
    protected DVTEditor getTextEditor(IDocument document) {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            return null;
        }
        return (DVTEditor)activeEditor;
    }

    @Override
    public DVTEditor getAndOpenEditor(IResource instanceDesignElementFileAdapter) throws PartInitException {
        IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)((IFile)instanceDesignElementFileAdapter));
        if (!(openEditor instanceof DVTEditor)) {
            return null;
        }
        return (DVTEditor)openEditor;
    }

    @Override
    public DVTEditor getOpenEditor(IResource openResource) {
        IEditorPart activeEditor = DVTUiUtils.getActivePage().getActiveEditor();
        if (!(activeEditor instanceof DVTEditor)) {
            return null;
        }
        return (DVTEditor)activeEditor;
    }

    public String getDescription() {
        return this.getAdditionalProposalInfo();
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getLabel() {
        return this.getDisplayString();
    }

    @Override
    public abstract void preApplyQuickFix(IDocument var1) throws Exception;

    @Override
    public abstract void createQuickFixChanges(IDocument var1, boolean var2) throws Exception;

    @Override
    public abstract IFile[] getAffectedFiles() throws Exception;

    @Override
    public abstract void applyQuickFix(IDocument var1, boolean var2) throws Exception;

    @Override
    public abstract IFile getResource(IProject var1, String var2);

    public abstract IMarker[] findOtherMarkers(IMarker[] var1);
}

