/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix.quickfixes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickassist.IQuickCompletion;
import ro.amiq.dvt.ui.refactor.DVTTextFileChange;
import ro.amiq.dvt.ui.refactor.linkedpositions.DVTLinkedPositionProvider;

public abstract class AbstractQuickFixCommon
extends WorkbenchMarkerResolution
implements ICompletionProposal,
IQuickCompletion {
    protected IMarker marker;
    protected int offset;
    protected IRfDefElement enclosingScope;
    protected IFile buildFile;
    protected String elementName;
    protected Position position;
    protected ITextViewer viewer;
    protected int tabWidth;
    protected DVTEditor targetEditor;
    protected DVTEditor triggerEditor;
    protected IDocument targetDocument;
    protected IDocument triggerDocument;
    protected IResource triggerResource;
    protected IResource targetResource;
    protected IProject project;
    protected LinkedModeModel linkedProposalModel;
    protected DVTLinkedPositionProvider linkedPositionProvider;
    protected DVTTextFileChange textFileChange;
    protected CompositeChange compositeTextChange;

    protected AbstractQuickFixCommon(IMarker marker, ITextViewer viewer) {
        this.marker = marker;
        this.viewer = viewer;
    }

    public void setParameters(int offset, Position position, IFile buildFile, String elementName) {
        this.offset = offset;
        this.buildFile = buildFile;
        this.elementName = elementName;
        this.position = position;
    }

    public void setParameters(int offset, Position position, IRfDefElement enclosingScope, String elementName) {
        this.offset = offset;
        this.enclosingScope = enclosingScope;
        this.elementName = elementName;
        this.position = position;
    }

    protected boolean initFieldsAndCreateQuickFixChanges(IDocument document) throws Exception {
        boolean editorChanged = false;
        this.initTriggerAndTarget(document);
        this.preApplyQuickFix(document);
        InitQuickFixInfo initInfo = this.initElementsFromMarker(this.marker, document, editorChanged);
        if (initInfo != null) {
            editorChanged = initInfo.isEditorChanged();
            document = initInfo.getDocument();
        }
        this.createQuickFixChanges(document, editorChanged);
        return editorChanged;
    }

    public String getAdditionalProposalInfo() {
        return this.getDisplayString();
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    protected InitQuickFixInfo initElementsFromMarker(IMarker marker, IDocument initialDocument, boolean initialEditorChanged) {
        IDocument document = initialDocument;
        boolean editorChanged = initialEditorChanged;
        if (marker == null) {
            return new InitQuickFixInfo(document, editorChanged);
        }
        DVTEditor textEditor = this.getTextEditor();
        if (textEditor == null) {
            return new InitQuickFixInfo(document, editorChanged);
        }
        this.targetEditor = textEditor;
        ITextViewer tmpViewer = textEditor.getTextViewer();
        this.tabWidth = textEditor.getTabWidth();
        editorChanged = tmpViewer != this.viewer && this.viewer != null && tmpViewer != null;
        this.viewer = tmpViewer;
        this.targetDocument = document = textEditor.getDocument();
        return new InitQuickFixInfo(document, editorChanged);
    }

    public void initTriggerAndTarget(IDocument document) throws CoreException {
        this.initTriggerAndTarget(document, this.getTextEditor(document));
    }

    protected void initTriggerAndTarget(IDocument document, DVTEditor editor) throws CoreException {
        this.triggerEditor = this.targetEditor = editor;
        if (this.triggerEditor == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.triggerDocument = this.targetDocument = document;
        if (this.enclosingScope == null && this.buildFile != null) {
            this.triggerResource = this.targetResource = this.buildFile;
        } else if (this.enclosingScope != null) {
            IRfFileDef enclosingScopeFile;
            IRfFileDef iRfFileDef = enclosingScopeFile = this.enclosingScope instanceof IRfFileDef ? (IRfFileDef)((Object)this.enclosingScope) : this.enclosingScope.getDefFile();
            if (enclosingScopeFile == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            this.triggerResource = this.targetResource = (IResource)enclosingScopeFile.getAdapter(IResource.class);
        }
        if (this.triggerResource == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        this.project = this.triggerResource.getProject();
    }

    public abstract void preApplyQuickFix(IDocument var1) throws Exception;

    public abstract void createQuickFixChanges(IDocument var1, boolean var2) throws Exception;

    public abstract IFile getResource(IProject var1, String var2);

    public abstract DVTEditor getTextEditor();

    protected abstract DVTEditor getTextEditor(IDocument var1);

    public abstract DVTEditor getOpenEditor(IResource var1);

    public abstract DVTEditor getAndOpenEditor(IResource var1) throws PartInitException;

    public abstract void applyQuickFix(IDocument var1, boolean var2) throws Exception;

    protected abstract TemplateContext createContext(IDocument var1, IRegion var2);

    public abstract IFile[] getAffectedFiles() throws Exception;

    static class InitQuickFixInfo {
        private IDocument document;
        private boolean editorChanged;

        public InitQuickFixInfo(IDocument document, boolean editorChanged) {
            this.document = document;
            this.editorChanged = editorChanged;
        }

        public IDocument getDocument() {
            return this.document;
        }

        public boolean isEditorChanged() {
            return this.editorChanged;
        }
    }
}

