/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix.quickfixes;

import java.io.File;
import java.util.Map;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.AutoLinkRoot;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.builders.DVTAutoLinkManager;
import ro.amiq.dvt.resourcefilters.ApplyFilterOnNewResourceJob;
import ro.amiq.dvt.resources.properties.PropertiesManager;
import ro.amiq.dvt.resources.properties.PropertyTypes;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.CreateFileFromBuildConfigQuickFixCommon;
import ro.amiq.dvt.utils.DVTFileUtils;

public class CreateFileFromBuildConfigQuickFix
extends CreateFileFromBuildConfigQuickFixCommon {
    public CreateFileFromBuildConfigQuickFix(IMarker marker, ITextViewer viewer, File fileToCreate, String languageSyntaxId, Image image) {
        super(marker, viewer, fileToCreate, languageSyntaxId, image);
    }

    @Override
    public void createFile() {
        IBuildConfigParserConstants.LanguageSyntax languageSyntax = IBuildConfigParserConstants.LanguageSyntax.from(this.languageSyntaxId);
        this.isEFile = languageSyntax != null && (LanguageKind.E == languageSyntax.languageKind || LanguageKind.SLN == languageSyntax.languageKind);
        DVTFileUtils.getInstance().writeStringToFile(this.fileToCreate, this.isEFile ? E_FILE_TEXT : "", false);
    }

    @Override
    public void applyQuickFix(IDocument document, boolean editorChanged) throws Exception {
        final IProject project = this.buildFile.getProject();
        if (project == null) {
            return;
        }
        IPath projectLocation = project.getLocation();
        if (projectLocation == null) {
            return;
        }
        this.createFile();
        if (projectLocation.isPrefixOf((IPath)this.filePath)) {
            IFile file = project.getFile(this.filePath.makeRelativeTo(projectLocation));
            ApplyFilterOnNewResourceJob.runJob((IResource)file, true);
            file.refreshLocal(1, null);
            if (this.languageSyntaxId != null) {
                if ("BUILD_CONFIG_FILE".equals(this.languageSyntaxId)) {
                    PropertiesManager.addSessionProperty((IResource)file, PropertyTypes.QN_IMPORTED_FILE, "ro.amiq.dvt.ui.editor.BuildConfigEditor");
                } else {
                    PropertiesManager.addSessionProperty((IResource)file, PropertyTypes.QN_IMPORTED_FILE, this.languageSyntaxId);
                }
            }
            this.openFile(file);
            this.triggerReparse();
        } else {
            ResourcesPlugin.getWorkspace().run(monitor -> {
                DVTAutoLinkManager.IAutoLinkOperation op = new DVTAutoLinkManager.IAutoLinkOperation(){

                    @Override
                    public void run(Map<IPath, LinkDescription> cachedLinksMap) throws CoreException {
                        Map<String, AutoLinkRoot> autoLinkedRoots = BuildConfigManager.getAutoLinkedRoots(project);
                        IFile file = DVTAutoLinkManager.getInstance().createAutoLink(project, (IPath)CreateFileFromBuildConfigQuickFix.this.filePath, autoLinkedRoots, null, false);
                        if (file == null) {
                            return;
                        }
                        CreateFileFromBuildConfigQuickFix.this.openFile(file);
                        CreateFileFromBuildConfigQuickFix.this.triggerReparse();
                    }
                };
                DVTAutoLinkManager.getInstance().modifyWorkspaceOperation(project, "QUICK_FIX", op, false);
            }, null);
        }
    }
}

