/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix.quickfixes;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.quickfix.BCQuickFixUtil;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.BaseAbstractQuickFix;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.ICreateFileQuickFixProposal;
import ro.amiq.dvt.utils.DVTFileUtils;

public abstract class CreateFileFromBuildConfigQuickFixCommon
extends BaseAbstractQuickFix
implements ICreateFileQuickFixProposal {
    protected static final String FILE_TEXT = "";
    protected static final String E_FILE_TEXT = "<'" + System.lineSeparator() + System.lineSeparator() + "'>";
    protected File fileToCreate;
    Path filePath;
    protected String languageSyntaxId;
    private Image image;
    protected boolean isEFile;

    protected CreateFileFromBuildConfigQuickFixCommon(IMarker marker, ITextViewer viewer, File fileToCreate, String languageSyntaxId, Image image) {
        super(marker, viewer);
        this.fileToCreate = fileToCreate;
        this.languageSyntaxId = languageSyntaxId;
        this.filePath = new Path(fileToCreate.getAbsolutePath());
        this.image = image;
    }

    @Override
    public void preApplyQuickFix(IDocument document) throws Exception {
        this.triggerEditor = this.getOpenEditor(this.triggerResource);
        super.preApplyQuickFix(document);
    }

    @Override
    public IFile[] getAffectedFiles() throws Exception {
        return new ArrayList().toArray(new IFile[0]);
    }

    public void triggerReparse() {
        try {
            if (this.buildFile != null) {
                this.buildFile.touch(null);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public void openFile(IFile file) {
        try {
            IEditorPart openEditor = IDE.openEditor((IWorkbenchPage)DVTUiUtils.getActivePage(), (IFile)file, (boolean)true);
            if (!(openEditor instanceof DVTEditor)) {
                return;
            }
            this.targetEditor = (DVTEditor)openEditor;
            if (this.targetEditor == null) {
                return;
            }
            this.targetDocument = this.targetEditor.getDocument();
            this.targetEditor.doSave(null);
            this.targetEditor.setCursor(this.isEFile ? this.targetDocument.getLineOffset(1) : 0);
            this.targetEditor.showContentAssistProposalsForCreatedFile();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    @Override
    public void createQuickFixChanges(IDocument document, boolean editorChanged) throws Exception {
        IProject project = this.buildFile.getProject();
        if (project == null) {
            return;
        }
        IPath projectLocation = project.getLocation();
        if (projectLocation == null) {
            return;
        }
        IFile file = DVTFileUtils.getInstance().getProjectFile(project, this.filePath.toOSString());
        if (file == null) {
            return;
        }
        if (this.fileToCreate.exists()) {
            BCQuickFixUtil.getInstance().doProposeRebuild(project, this.filePath).thenAccept(wasBuildStarted -> {
                if (!wasBuildStarted.booleanValue()) {
                    return;
                }
                this.openFile(file);
            });
            return;
        }
        IBuildConfigParserConstants.LanguageSyntax languageSyntax = IBuildConfigParserConstants.LanguageSyntax.from(this.languageSyntaxId);
        this.isEFile = languageSyntax != null && (LanguageKind.E == languageSyntax.languageKind || LanguageKind.SLN == languageSyntax.languageKind);
    }

    public String getDisplayString() {
        return "Create file '" + this.filePath.lastSegment() + "' in '" + this.filePath.removeLastSegments(1) + "'";
    }

    public Image getImage() {
        if (this.image == null) {
            return DVTImages.imageCache.getImage(DVTImages.OUTLINE_FILE);
        }
        return this.image;
    }

    public String getFileParentDir() {
        if (this.filePath == null) {
            return FILE_TEXT;
        }
        return this.filePath.makeAbsolute().removeLastSegments(1).toOSString();
    }

    @Override
    public String getNewFilePath() {
        return this.fileToCreate.getAbsolutePath();
    }

    protected abstract void createFile();
}

