/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix.quickfixes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.ITextViewer;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfInstanceElement;
import ro.amiq.dvt.model.reflection.IRfPortElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.AbstractQuickFix;
import ro.amiq.dvt.ui.editor.quickfix.quickfixes.IDesignElementQuickFixContributor;

public class DesignElementQuickFixProxy {
    public static final String DVT_DESIGN_ELEM_QUICK_FIX_CONTRIBUTOR_EXTENSION_POINT_ID = "ro.amiq.dvt.designElementQuickFixContributor";
    public static final String DVT_DESIGN_ELEM_QUICK_FIX_CONTRIBUTOR_ELEMENT = "designElementQuickFixContributor";
    private IMarker marker;
    private ITextViewer viewer;
    private IRfInstanceElement instance;
    private IRfDesignElement designElement;
    private IRfDesignElement triggerDesignScope;

    public DesignElementQuickFixProxy(IMarker marker, ITextViewer viewer, IRfInstanceElement instance, IRfDesignElement designElement, IRfDesignElement triggerDesignScope) {
        this.setMarker(marker);
        this.setViewer(viewer);
        this.setInstance(instance);
        this.setDesignElement(designElement);
        this.setTriggerDesignScope(triggerDesignScope);
    }

    public AbstractQuickFix getAddPortQuickFix(Set<IHid> undeclaredPortConnections) {
        IDesignElementQuickFixContributor contributor = this.getContributorByDesignElemNature(this.getDesignElementNature());
        if (contributor == null) {
            return null;
        }
        return contributor.getAddPortQuickFix(this.marker, this.viewer, this.instance, this.designElement, this.triggerDesignScope, undeclaredPortConnections);
    }

    public AbstractQuickFix getAddGenericQuickFix() {
        IDesignElementQuickFixContributor contributor = this.getContributorByDesignElemNature(this.getDesignElementNature());
        if (contributor == null) {
            return null;
        }
        return contributor.getAddGenericQuickFix(this.marker, this.viewer, this.instance, this.designElement, this.triggerDesignScope);
    }

    public AbstractQuickFix getUpdateInstanceQuickFix(List<IHidOperator> instancePortConnections, Collection<? extends IRfPortElement> designPorts) {
        IRfDefElement instanceDeclaration = this.instance.getDeclaration();
        if (instanceDeclaration == null) {
            return null;
        }
        LanguageKind languageKind = instanceDeclaration.getLanguageKind();
        if (languageKind == null) {
            return null;
        }
        IDesignElementQuickFixContributor contributor = this.getContributorByDesignElemNature(languageKind.NATURE_ID);
        if (contributor == null) {
            return null;
        }
        return contributor.getUpdateInstanceQuickFix(this.marker, this.viewer, this.instance, this.designElement, this.triggerDesignScope, instancePortConnections, designPorts == null ? Collections.emptyList() : designPorts);
    }

    private List<IDesignElementQuickFixContributor> getDesignElementQuickFixContributors() {
        ArrayList<IDesignElementQuickFixContributor> delegates = new ArrayList<IDesignElementQuickFixContributor>();
        try {
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DVT_DESIGN_ELEM_QUICK_FIX_CONTRIBUTOR_EXTENSION_POINT_ID);
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    if (!DVT_DESIGN_ELEM_QUICK_FIX_CONTRIBUTOR_ELEMENT.equals(configurationElement.getName())) {
                        DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + "for extension point: " + DVT_DESIGN_ELEM_QUICK_FIX_CONTRIBUTOR_EXTENSION_POINT_ID));
                    }
                    IDesignElementQuickFixContributor quickFixContributor = (IDesignElementQuickFixContributor)configurationElement.createExecutableExtension("class");
                    delegates.add(quickFixContributor);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return delegates;
    }

    private IDesignElementQuickFixContributor getContributorByDesignElemNature(String nature) {
        if (nature == null || nature.isEmpty()) {
            return null;
        }
        for (IDesignElementQuickFixContributor contributor : this.getDesignElementQuickFixContributors()) {
            if (!nature.equals(contributor.getNature())) continue;
            return contributor;
        }
        return null;
    }

    public String getDesignElementNature() {
        switch (this.getDesignElement().getKind()) {
            case VHDL_ENTITY: {
                return "ro.amiq.vhdldt.VhdlNature";
            }
            case VLOG_MODULE: {
                return "ro.amiq.vlogdt.VlogNature";
            }
        }
        return null;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public void setMarker(IMarker marker) {
        this.marker = marker;
    }

    public ITextViewer getViewer() {
        return this.viewer;
    }

    public void setViewer(ITextViewer viewer) {
        this.viewer = viewer;
    }

    public IRfDesignElement getTriggerDesignScope() {
        return this.triggerDesignScope;
    }

    public void setTriggerDesignScope(IRfDesignElement triggerDesignScope) {
        this.triggerDesignScope = triggerDesignScope;
    }

    public IRfDesignElement getDesignElement() {
        return this.designElement;
    }

    public void setDesignElement(IRfDesignElement designElement) {
        this.designElement = designElement;
    }

    public IRfInstanceElement getInstance() {
        return this.instance;
    }

    public void setInstance(IRfInstanceElement instance) {
        this.instance = instance;
    }
}

