/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix.util;

import java.util.concurrent.CompletableFuture;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.quickfix.util.DVTQuickFixUtilCommon;
import ro.amiq.dvt.utils.DVTBuildUtils;

public class DVTQuickFixUtil
extends DVTQuickFixUtilCommon {
    @Override
    public CompletableFuture<Boolean> doProposeRebuild(IProject project, Path filePath) throws CoreException {
        int doBuild = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), null, null, "The error you are trying to fix might be obsolete. This file already exists:\n\n " + filePath.toOSString() + "\n\nIt is recommended to rebuild the project.", 4, new String[]{"Build Now", "Cancel"}, 0).open();
        if (doBuild == 0) {
            DVTBuildUtils.buildWithProgressDialog(project);
        }
        return CompletableFuture.completedFuture(doBuild == 0);
    }

    @Override
    public IEditorPart openEditor(IFile file) {
        try {
            return IDE.openEditor((IWorkbenchPage)DVTUiUtils.getActivePage(), (IFile)file, (boolean)true);
        }
        catch (PartInitException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

