/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.quickfix.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorQualifier;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOccurrenceHolder;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.quickfix.util.IDVTQuickFixUtil;

public abstract class DVTQuickFixUtilCommon
implements IDVTQuickFixUtil {
    public static final String VLOG_INPUT_PORT_DIRECTION = "input";
    public static final String VHDL_INPUT_PORT_DIRECTION = "in";
    public static final String WORK = "work";
    public static final String QUICK_FIX_PROPOSAL_CATEGORY = "QuickFixCategory_";
    public static final String COMPUTING_QUICK_FIX_PROPOSALS = "Computing quick fix proposals...";
    public static final String COMPUTING_AI_QUICK_FIX_PROPOSALS = "Computing AI Assistant problem autocorrect proposals...";
    public static final long BUSY_INDICATOR_TIMEOUT = 1500L;
    public static final long COMPUTE_AI_QUICK_FIXES_JOB_TIMEOUT_MS = 5000L;
    public static final int QUICKFIX_SEARCH_BUFFER_SIZE = 1000;
    public static final int QUICK_FIX_TOOLTIP_TIMEOUT = 200;
    public static final int NOF_DID_YOU_MEAN_PROPOSALS = 3;
    public static final int MIN_DID_YOU_MEAN_WORD_LENGTH = 2;
    public static final String NEW_LINE = System.lineSeparator();
    public static final Set<HidFlatteningOption> FLATTENING_OPTIONS = Collections.unmodifiableSet(EnumSet.of(HidFlatteningOption.IGNORE_OBJECTS_IN_SELECTS, HidFlatteningOption.IGNORE_METHOD_CALL_ARGUMENTS));
    public static final HidOperatorQualifier[] ASSIGN_EXPRESSIONS;

    static {
        HidOperatorQualifier[] hidOperatorQualifierArray = new HidOperatorQualifier[9];
        hidOperatorQualifierArray[0] = HidOperatorQualifier.IS_DECLARATION_EXPRESSION;
        hidOperatorQualifierArray[1] = HidOperatorQualifier.IS_CONTINUOUS_ASSIGN;
        hidOperatorQualifierArray[2] = HidOperatorQualifier.IS_ALIAS;
        hidOperatorQualifierArray[3] = HidOperatorQualifier.IS_BLOCKING_ASSIGN;
        hidOperatorQualifierArray[4] = HidOperatorQualifier.IS_NONBLOCKING_ASSIGN;
        hidOperatorQualifierArray[5] = HidOperatorQualifier.IS_SELECT_CONTINUOUS_ASSIGN;
        hidOperatorQualifierArray[6] = HidOperatorQualifier.IS_SELECT_NONBLOCKING_ASSIGN;
        hidOperatorQualifierArray[7] = HidOperatorQualifier.IS_SELECT_BLOCKING_ASSIGN;
        ASSIGN_EXPRESSIONS = hidOperatorQualifierArray;
    }

    public static boolean isHidInRegion(IHidOccurrenceHolder hidObject, IRegion region) {
        HidOccurrence occurence = hidObject.getOccurrence();
        if (occurence == null) {
            return false;
        }
        int occOffset = occurence.getOffset();
        return region.getOffset() <= occOffset && occOffset <= region.getOffset() + region.getLength();
    }

    public static List<IRegion> computeLinkedRegionsForWord(String text, String word, int insertOffset) {
        ArrayList<IRegion> linkedPositionRegions = new ArrayList<IRegion>();
        String regexEscaped = FindReplaceDocumentAdapter.escapeForRegExPattern((String)word);
        Matcher matcher = Pattern.compile("\\b" + regexEscaped).matcher("");
        int regionOffset = 0;
        int regionLength = word.length();
        matcher.reset(text);
        while (matcher.find()) {
            regionOffset = matcher.start();
            Region wordRegion = new Region(insertOffset + regionOffset, regionLength);
            linkedPositionRegions.add((IRegion)wordRegion);
        }
        return linkedPositionRegions;
    }

    public int getHidOffsetInRegion(IHid hid, IRegion region) {
        int regionOffset;
        HidOccurrence occurrence = hid.getOccurrence();
        if (occurrence == null) {
            return -1;
        }
        int occurrenceOffset = occurrence.getOffset();
        if (occurrenceOffset >= (regionOffset = region.getOffset()) && occurrenceOffset <= regionOffset + region.getLength()) {
            return occurrenceOffset;
        }
        return -1;
    }

    protected static void scheduleTimeoutWatchDog(final IProgressMonitor progressMonitor, int timeoutMilliseconds) {
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                progressMonitor.setCanceled(true);
            }
        };
        new Timer().schedule(tt, timeoutMilliseconds);
    }

    protected static boolean containsProposal(List<Class<?>> proposalsToCheck, List<ICompletionProposal> existingProposals, String elementName) {
        for (ICompletionProposal existingProposal : existingProposals) {
            if (!proposalsToCheck.contains(existingProposal.getClass())) continue;
            return true;
        }
        return false;
    }

    public static boolean isHidInSelection(IHid hid, int startOffset, int endOffset) {
        if (hid == null || hid.getOccurrence() == null) {
            return false;
        }
        HidOccurrence occurrence = hid.getOccurrence();
        if (occurrence == null) {
            return false;
        }
        int occurenceOffset = occurrence.getOffset();
        return occurenceOffset >= startOffset && occurenceOffset <= endOffset;
    }

    public static boolean isOperatorInSelection(HidOperator operator, int startOffset, int endOffset) {
        if (operator == null || operator.getOccurrence() == null) {
            return false;
        }
        HidOperatorOccurrence occurrence = operator.getOccurrence();
        if (occurrence == null) {
            return false;
        }
        if (occurrence.getVirtualOffset() != -1) {
            return false;
        }
        int occurenceOffset = occurrence.getOffset();
        return occurenceOffset >= startOffset && occurenceOffset < endOffset;
    }

    public static void busyWaitOnJob(AtomicBoolean jobDone, long timeout) {
        while (!jobDone.get() && System.currentTimeMillis() < timeout) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public abstract CompletableFuture<Boolean> doProposeRebuild(IProject var1, Path var2) throws CoreException;

    public abstract IEditorPart openEditor(IFile var1);

    public static class PrecompiledQuickFix
    implements ICompletionProposal {
        private IRfNamedElement namedElement;
        private String name;

        public PrecompiledQuickFix(IRfNamedElement namedElement, String name) {
            this.namedElement = namedElement;
            this.name = name;
        }

        public Point getSelection(IDocument document) {
            return null;
        }

        public Image getImage() {
            return DVTImages.imageCache.getImage(DVTImages.INFORMATION);
        }

        public String getDisplayString() {
            return "No quick fix proposals for " + this.name + ".";
        }

        public IContextInformation getContextInformation() {
            return null;
        }

        public String getAdditionalProposalInfo() {
            if (this.namedElement == null) {
                return "";
            }
            IRfDefElement declaration = this.namedElement.getDeclaration();
            if (declaration == null) {
                return "";
            }
            ParserPath parserPath = declaration.getParserPath();
            if (parserPath == null) {
                return "";
            }
            return "Unable to apply quick fixes in precompiled file '" + parserPath.path + "'.";
        }

        public void apply(IDocument document) {
        }
    }
}

