/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.rules;

import java.util.HashSet;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.DVTFoldingPosition;
import ro.amiq.dvt.ui.preferences.PrefConst;

public abstract class CommentTaskRule
implements IRule,
IPropertyChangeListener {
    protected IToken fDefaultToken;
    protected IToken fPragmaToken;
    protected HashSet<String> fWords = new HashSet();
    protected StringBuilder fBuffer = new StringBuilder();
    protected boolean fEnable;
    protected boolean fCaseSensitive;

    public CommentTaskRule(IToken taskTagToken, IToken pragmaToken, boolean enable) {
        Assert.isNotNull((Object)taskTagToken);
        this.fDefaultToken = taskTagToken;
        this.fPragmaToken = pragmaToken == null ? this.fDefaultToken : pragmaToken;
        this.updateTaskNames();
        this.fEnable = enable;
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    protected void updateTaskNames() {
        this.fCaseSensitive = PrefConst.getTaskTagsCaseSensitive();
        String[] taskTags = PrefConst.getTaskTagsNames();
        if (taskTags == null) {
            return;
        }
        this.fWords.clear();
        int i = 0;
        while (i < taskTags.length) {
            if (this.fCaseSensitive) {
                this.fWords.add(taskTags[i]);
            } else {
                this.fWords.add(taskTags[i].toLowerCase());
            }
            ++i;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("taskTags") || event.getProperty().equals("taskTagsCase")) {
            this.updateTaskNames();
        }
    }

    protected void addPosition(IDocument document, DVTFoldingPosition.Type type, DVTFoldingPosition.SubType subType, int offset, int length) {
        try {
            if (document.containsPositionCategory("__dvt_macro_position") && !document.containsPosition("__dvt_macro_position", offset, length)) {
                document.addPosition("__dvt_macro_position", (Position)new DVTFoldingPosition(offset, length, type, subType));
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }
}

