/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.rules;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.ui.custompragma.CustomPragmaUtils;
import ro.amiq.dvt.ui.custompragma.ICustomPragmaStyleListener;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;
import ro.amiq.dvt.utils.DVTStringUtil;

public class CustomPragmaRule
implements IRule,
ICustomPragmaStyleListener {
    protected IToken fDefaultToken;
    protected Set<String> fCustomPragmas = new HashSet<String>();
    protected Set<String> fCustomPragmaFirstIdentifiers = new HashSet<String>();
    protected StringBuilder fBuffer = new StringBuilder();

    public CustomPragmaRule(IToken token, IProject project) {
        Assert.isNotNull((Object)token);
        this.fDefaultToken = token;
        CustomPragmaUtils.addListener(this);
        this.updateCustomPragmas(project);
    }

    @Override
    public void updateCustomPragmas(IProject project) {
        BuildConfigManager.getCustomPragmas(project).stream().forEach(pragma -> {
            if (!pragma.isOverriden() && pragma.isEnabled()) {
                this.fCustomPragmas.add(pragma.getStartPragma());
                this.fCustomPragmas.add(pragma.getEndPragma());
                this.fCustomPragmaFirstIdentifiers.add(DVTStringUtil.getFirstIdentifier(pragma.getStartPragma()));
                this.fCustomPragmaFirstIdentifiers.add(DVTStringUtil.getFirstIdentifier(pragma.getEndPragma()));
            }
        });
        BuildConfigManager.getPreprocessTranslatePragmas(project).stream().forEach(pragma -> {
            this.fCustomPragmas.add(String.valueOf(pragma) + " translate_off");
            this.fCustomPragmas.add(String.valueOf(pragma) + " translate_on");
            this.fCustomPragmaFirstIdentifiers.add(DVTStringUtil.getFirstIdentifier(pragma));
        });
    }

    public IToken evaluate(DVTBaseScanner scanner) {
        if (this.fCustomPragmas == null || this.fCustomPragmas.isEmpty()) {
            return Token.UNDEFINED;
        }
        int c = scanner.read();
        StringBuilder firstWord = new StringBuilder();
        boolean firstWordCreated = false;
        this.fBuffer.delete(0, this.fBuffer.length());
        do {
            this.fBuffer.append((char)c);
            if (firstWord.length() != 0 && Character.isWhitespace(c)) {
                firstWordCreated = true;
            }
            if (firstWordCreated || Character.isWhitespace(c)) continue;
            firstWord.append((char)c);
        } while ((c = scanner.read()) != -1 && c != 10 && c != 13);
        scanner.unread();
        if (!this.fCustomPragmaFirstIdentifiers.contains(firstWord.toString())) {
            scanner.unreadLength(this.fBuffer.length());
            return Token.UNDEFINED;
        }
        String text = DVTStringUtil.collapseWhitespaces(this.fBuffer.toString());
        if (this.fCustomPragmas.contains(text)) {
            return this.fDefaultToken;
        }
        scanner.unreadLength(this.fBuffer.length());
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate((DVTBaseScanner)scanner);
    }
}

