/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.rules;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.editor.DVTBaseScanner;

public class JavadocTagsRule
implements IRule,
IPropertyChangeListener {
    private IToken fDefaultToken;
    private StringBuilder fBuffer = new StringBuilder();
    private boolean fEnable;

    public JavadocTagsRule(IToken token, boolean enable) {
        Assert.isNotNull((Object)token);
        this.fDefaultToken = token;
        this.fEnable = enable;
        DVTPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public IToken evaluate(DVTBaseScanner scanner, boolean enable) {
        int c = scanner.read();
        if (Character.isJavaIdentifierPart((char)c) || c == 64) {
            this.fBuffer.setLength(0);
            do {
                this.fBuffer.append((char)c);
            } while ((c = scanner.read()) != -1 && (Character.isJavaIdentifierPart((char)c) || c == 95 || c == 64));
            scanner.unread();
            String text = this.fBuffer.toString();
            String lowerCaseText = text.toLowerCase();
            if (lowerCaseText.equals("@see")) {
                return this.fDefaultToken;
            }
            if (lowerCaseText.equals("@param")) {
                return this.fDefaultToken;
            }
            if (lowerCaseText.equals("@return")) {
                return this.fDefaultToken;
            }
            if (lowerCaseText.equals("@link")) {
                return this.fDefaultToken;
            }
            if (lowerCaseText.equals("@since")) {
                return this.fDefaultToken;
            }
            if (lowerCaseText.equals("@version")) {
                return this.fDefaultToken;
            }
            if (lowerCaseText.equals("@author")) {
                return this.fDefaultToken;
            }
            if (lowerCaseText.equals("@deprecated")) {
                return this.fDefaultToken;
            }
            if (lowerCaseText.equals("@literal")) {
                return this.fDefaultToken;
            }
            if (lowerCaseText.equals("@dvt_no_html_doc")) {
                return this.fDefaultToken;
            }
            scanner.unreadLength(this.fBuffer.length());
            return Token.UNDEFINED;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        return this.evaluate((DVTBaseScanner)scanner, this.fEnable);
    }

    public void propertyChange(PropertyChangeEvent event) {
    }
}

