/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.scopebreadcrumb;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BCDropDownContentProvider;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbViewer;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class ScopeBCLazyDropDownContentProvider
extends BCDropDownContentProvider
implements ILazyContentProvider {
    private ScopeBreadcrumbViewer scopeBreadcrumbViewer;
    private ScopeBreadcrumbUtils bcUtils;
    private TableViewer dropdownViewer;
    private Object[] elements;
    private String prefix;

    public ScopeBCLazyDropDownContentProvider(TableViewer viewer, ScopeBreadcrumbViewer scopeBreadcrumbViewer, ScopeBreadcrumbUtils scopeBreadcrumbUtils) {
        this.dropdownViewer = viewer;
        this.scopeBreadcrumbViewer = scopeBreadcrumbViewer;
        this.bcUtils = scopeBreadcrumbUtils;
    }

    public void dispose() {
        try {
            if (this.scopeBreadcrumbViewer != null) {
                this.scopeBreadcrumbViewer.disposeDropDownModel();
            }
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.elements = (Object[])newInput;
    }

    public void updateElement(int index) {
        try {
            if (index >= this.elements.length) {
                return;
            }
            if (this.bcUtils == null) {
                return;
            }
            if (this.bcUtils.isGUIFiltered(this.elements[index])) {
                this.dropdownViewer.getTable().getItem(index).setForeground(DVTUiUtils.COLOR_GRAY);
            }
            this.dropdownViewer.replace(this.elements[index], index);
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void filterInput(String text, List<?> dropdownElements) {
        try {
            if (this.bcUtils == null) {
                return;
            }
            if (dropdownElements == null || dropdownElements.isEmpty()) {
                return;
            }
            if (text == null) {
                return;
            }
            StringMatcher localMatcher = ViewsUtils.createCamelCaseOrRegexMatcher(text, true, false);
            ArrayList filteredList = new ArrayList();
            for (Object element : dropdownElements) {
                if (!(element instanceof IRfBreadcrumbElement) || !ViewsUtils.matchCamelCaseOrRegex(localMatcher, this.bcUtils.getElementName((IRfBreadcrumbElement)element))) continue;
                filteredList.add(element);
            }
            this.elements = filteredList.toArray();
            this.dropdownViewer.setInput((Object)filteredList.toArray());
            this.dropdownViewer.setItemCount(filteredList.size());
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    public Object[] testGetElements() {
        return (Object[])this.dropdownViewer.getInput();
    }
}

