/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.scopebreadcrumb;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.actions.breadcrumb.BreadcrumbMode;
import ro.amiq.dvt.ui.actions.history.HistoryItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbUtils;
import ro.amiq.dvt.ui.guifilters.DVTGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.DVTNamedElementGUIFilterMatcher;
import ro.amiq.dvt.ui.guifilters.ViewSet;
import ro.amiq.dvt.ui.views.DVTTreeElementWrapper;
import ro.amiq.dvt.ui.views.DVTViewEvent;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewDataContainer;
import ro.amiq.dvt.ui.views.ViewsUtils;

public abstract class ScopeBreadcrumbUtils
extends ThickBreadcrumbUtils {
    private static final int TRIM_THRESHOLD = 1024;

    @Override
    public BreadcrumbInput computeBreadcrumbInput(IDVTBreadcrumbHost activeEditor, AbstractBreadcrumbConfiguration cursorScope, boolean enabled) {
        try {
            BreadcrumbInput inputFromCursorScope = this.getInputFromCursorScope(cursorScope);
            if (inputFromCursorScope == null) {
                return BreadcrumbInput.REMOVE_BREADCRUMB;
            }
            return inputFromCursorScope;
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
            return null;
        }
    }

    private BreadcrumbInput getInputFromCursorScope(AbstractBreadcrumbConfiguration scope) {
        List<BreadcrumbSegment> scopeAncestors = this.computeScopeAncestors(scope);
        if (scopeAncestors == null || scopeAncestors.isEmpty()) {
            return null;
        }
        return new BreadcrumbInput(null, scopeAncestors, this.getBreadcrumbSerializer());
    }

    public boolean isSingleLibOrPackage(Object element) {
        if (!(element instanceof IRfNamedElement)) {
            return false;
        }
        if (!this.isLibOrPackage(element)) {
            return false;
        }
        IRfSingleLangProject rfProject = ((IRfNamedElement)element).getRfProject();
        if (rfProject == null) {
            return false;
        }
        IProject project = rfProject.getProject();
        if (project == null) {
            return false;
        }
        return this.computeValidLibsOrPacks(project).size() == 1;
    }

    public boolean isGUIFiltered(Object element) {
        if (element instanceof IRfDefElement) {
            element = ((IRfDefElement)element).getNamedElement();
        }
        if (!(element instanceof IRfNamedElement)) {
            return false;
        }
        IRfNamedElement candidate = (IRfNamedElement)element;
        return DVTNamedElementGUIFilterMatcher.filterElement(ViewSet.ViewName.SCOPE_BREADCRUMB, candidate, () -> candidate.getName()) != DVTGUIFilterMatcher.GUIFilterResult.NOT_FILTERED;
    }

    public void showTypeHierarchy(IProject project, IRfNamedElement element) {
        HistoryItem hItem = this.createHistoryItem(project, element);
        if (hItem == null) {
            return;
        }
        ViewDataContainer dataContainer = new ViewDataContainer(project, hItem);
        ViewsUtils.notifyViewById("ro.amiq.dvt.ui.views.TypeHierarchyView", new DVTViewEvent(DVTViewEvent.EventKind.TRIGGER, "", dataContainer), true);
    }

    public String getText(Object element, boolean isForDropdown) {
        String nameAdditionalInfo;
        boolean isVlogOrVHDLLang;
        if (!(element instanceof IRfBreadcrumbElement)) {
            return "";
        }
        if (this.isActionBlock(element)) {
            return this.getActionBlockName((IRfActionBlockElement)element, isForDropdown);
        }
        if (this.isAssert(element)) {
            return this.getAssertExpectName(element, isForDropdown);
        }
        String prefix = "";
        boolean bl = isVlogOrVHDLLang = !"ro.amiq.edt.enature".equals(this.getLanguageNature()) && !"ro.amiq.slndt.slnnature".equals(this.getLanguageNature());
        if (isVlogOrVHDLLang && this.isInsideMacro(element) && !this.isMacro(element)) {
            prefix = String.valueOf(prefix) + "# ";
        }
        String suffix = "";
        if (this.isFunction(element)) {
            suffix = "()";
        }
        if ((nameAdditionalInfo = this.getNameAdditionalInfo((IRfBreadcrumbElement)element, isForDropdown)) == null || nameAdditionalInfo.isEmpty()) {
            return this.trimElementName(String.valueOf(prefix) + ((IRfBreadcrumbElement)element).getName() + suffix);
        }
        if (isForDropdown) {
            suffix = "";
        }
        return this.trimElementName(String.valueOf(prefix) + nameAdditionalInfo + suffix);
    }

    protected String trimElementName(String name) {
        if (name == null) {
            return "";
        }
        if (name.length() > 1024) {
            return String.valueOf(name.substring(0, 1024)) + "...";
        }
        return name;
    }

    public ElementPath getQualifiedNamed(BreadcrumbInput input, IRfBreadcrumbElement upToElement) {
        List<BreadcrumbSegment> inputSegments = input.getInputSegments();
        if (inputSegments == null || upToElement == null) {
            return null;
        }
        ElementPath instancePath = ElementPath.EMPTY_PATH;
        for (BreadcrumbSegment segment : inputSegments) {
            IRfBreadcrumbElement element = segment.getElement();
            if (element == null) {
                return null;
            }
            if (this.isRootItem(element)) continue;
            instancePath = ElementPath.join(instancePath, this.getText(element, false));
            if (upToElement != element) continue;
            return instancePath;
        }
        return instancePath;
    }

    public String getElementName(IRfBreadcrumbElement element) {
        boolean isAssert = this.isAssert(element);
        if (!this.isActionBlock(element) && !isAssert) {
            return element.getName();
        }
        if (isAssert) {
            return this.getAssertExpectName(element, true);
        }
        return this.getActionBlockName((IRfActionBlockElement)element, true);
    }

    @Override
    public String getBCType() {
        return BreadcrumbMode.SCOPE.getName();
    }

    @Override
    public boolean isDummyRootItem(AbstractBreadcrumbItem item) {
        if (item == null) {
            return false;
        }
        Object data = item.getData();
        if (!(data instanceof IRfNamedElement)) {
            return false;
        }
        if (this.isRootItem(data)) {
            return true;
        }
        if (this.isSingleLibOrPackage(data)) {
            return true;
        }
        return this.isLibOrPackage(data) && !this.isSingleLibOrPackage(data);
    }

    public IDVTElementWrapper createShowDiagramWrapper(IRfBreadcrumbElement bcElement) {
        return new DVTTreeElementWrapper(bcElement);
    }

    protected abstract List<BreadcrumbSegment> computeScopeAncestors(AbstractBreadcrumbConfiguration var1);

    protected abstract List<IRfBreadcrumbElement> computeValidLibsOrPacks(IProject var1);

    protected abstract HistoryItem createHistoryItem(IProject var1, IRfNamedElement var2);

    protected abstract IRfNamedElement getTypeHierarchyElement(IRfBreadcrumbElement var1);

    public abstract List<? extends IRfBreadcrumbElement> computeScopeChildren(IRfBreadcrumbElement var1, IProject var2, int var3);

    public abstract String getNameAdditionalInfo(IRfBreadcrumbElement var1, boolean var2);

    public abstract void openElement(IDVTBreadcrumbHost var1, Object var2);

    public abstract boolean isInsideMacro(Object var1);

    public abstract boolean isMacro(Object var1);

    public abstract boolean isRootItem(Object var1);

    public abstract boolean isFunction(Object var1);

    public abstract Image getImage(Object var1);

    public abstract boolean isLibElement(IRfBreadcrumbElement var1);

    public abstract String getLanguageNature();

    public abstract IRfBreadcrumbElement resolveFunctionHolder(IRfBreadcrumbElement var1);

    public abstract boolean isLibOrPackage(Object var1);

    public abstract boolean copyQNExcludeParent(IRfScopeElement var1);

    public abstract boolean getShowUnnamedActionBlocks();

    public abstract void setShowUnnamedActionBlocks(boolean var1);

    public abstract String getActionBlockName(IRfActionBlockElement var1, boolean var2);

    public abstract String getAssertExpectName(Object var1, boolean var2);

    public abstract boolean isAnonymousElement(IRfBreadcrumbElement var1);

    public abstract boolean isActionBlock(Object var1);

    public abstract boolean isAssert(Object var1);

    public abstract IRfBreadcrumbElement getScopeForBreadcrumb(ITextEditor var1, int var2, boolean var3);
}

