/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.scopebreadcrumb;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfLibraryElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.Utils;
import ro.amiq.dvt.ui.actions.IMenuCommandDelegate;
import ro.amiq.dvt.ui.actions.MenuCommandDelegatesManager;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.ScopeBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBCDropDownLabelProvider;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBCInputContentProvider;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBCInputLabelProvider;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBCLazyDropDownContentProvider;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBCToolTipProvider;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.scopebreadcrumb.ScopeBreadcrumbUtils;
import ro.amiq.dvt.ui.utils.DVTColorUtil;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTDocumentCommon;

public class ScopeBreadcrumbViewer
extends ThickBreadcrumbViewer {
    public static final String ID = "ro.amiq.dvt.ui.editor.breadcrumb.ScopeBreadcrumbViewer";
    private static final String SHOW_TYPE_HIERARCHY_TEXT = "Show Type Hierarchy";
    private static final String SHOW_DIAGRAM_TEXT = "Show Diagram";
    private static final String SHOW_SCENARIO_TEXT = "Show Scenario";
    private static final String COPY_SCOPE_TEXT = "Copy";
    private static final String COPY_QUALIFIED_NAME_TEXT = "Copy Qualified Name";
    private static final String OPERATION_NOT_POSSIBLE_WARNING = "Operation not possible.";
    private static boolean isReadOnly;
    private boolean openingLibraryDropdown;
    private IRfBreadcrumbElement preLibSelectionLeafSegment;
    private DisplayActionBlocksAction displayActionBlocksButton;
    private final String SHOW_UNNAMED_ACTION_BLOCKS = "Show/Hide Unnamed Action Blocks";
    private IPropertyChangeListener fActionBlockButtonThemeListener;
    private SelectionListener testCopyScopeSelectionListener;
    private SelectionListener testCopyQualifiedNameSelectionListener;
    private SelectionListener testShowDiagramListener;
    private SelectionListener testShowScenarioDiagramListener;
    private Table testTableViewer;

    public ScopeBreadcrumbViewer(IDVTBreadcrumbHost editor, Composite topContainer) {
        super(editor, topContainer);
    }

    @Override
    public boolean isReadOnly() {
        return isReadOnly;
    }

    public static void setReadOnly(boolean readOnlyState) {
        isReadOnly = readOnlyState;
    }

    @Override
    public void setModelReady(boolean isModelReady) {
        ScopeBreadcrumbViewer.setReadOnly(!isModelReady);
    }

    @Override
    public void updateGuiPart(boolean enabled, BreadcrumbInput bcInput) {
        super.updateGuiPart(enabled, bcInput);
        if (this.forceUpdate) {
            this.refresh();
        }
        this.setDisplayActionBlocksState();
    }

    @Override
    public void createBreadcrumbSWTComponents(Composite topContainer) {
        super.createBreadcrumbSWTComponents(topContainer);
        if (!this.shouldDisplayActionBlocksButton()) {
            return;
        }
        ToolBar actionBlockToolbar = new ToolBar(this.fBreadcrumbHostComposite, -1);
        actionBlockToolbar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        DVTColorUtil.INSTANCE.setBackground((Control)actionBlockToolbar, JFaceResources.getColorRegistry().get("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor"));
        ToolBarManager actionBlockToolbarManager = new ToolBarManager(actionBlockToolbar);
        actionBlockToolbarManager.setStyle(0x2000000);
        this.displayActionBlocksButton = new DisplayActionBlocksAction();
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)actionBlockToolbar);
        actionBlockToolbarManager.add((IAction)this.displayActionBlocksButton);
        actionBlockToolbarManager.update(true);
        if (this.fActionBlockButtonThemeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fActionBlockButtonThemeListener);
        }
        this.fActionBlockButtonThemeListener = e -> {
            if (e.getProperty().equals("ro.amiq.dvt.ui.editor.breadcrumb.backgroundColor")) {
                DVTColorUtil.INSTANCE.setBackground((Control)actionBlockToolbar, DVTColorUtil.INSTANCE.getColor((RGB)e.getNewValue()));
            }
        };
        PlatformUI.getWorkbench().getThemeManager().addPropertyChangeListener(this.fActionBlockButtonThemeListener);
    }

    private boolean shouldDisplayActionBlocksButton() {
        ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
        if (breadcrumbUtils == null) {
            return false;
        }
        return breadcrumbUtils.getLanguageNature().equals("ro.amiq.vlogdt.VlogNature");
    }

    private void setDisplayActionBlocksState() {
        if (this.displayActionBlocksButton == null) {
            return;
        }
        if (this.fActiveEditor == null) {
            return;
        }
        ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
        if (breadcrumbUtils == null) {
            return;
        }
        this.displayActionBlocksButton.setChecked(breadcrumbUtils.getShowUnnamedActionBlocks());
    }

    @Override
    public void createListeners() {
        super.createListeners();
        this.fContextMenuListener = e -> {
            ISelection selection = this.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object bcElement = ((IStructuredSelection)selection).getFirstElement();
            if (!(bcElement instanceof IRfBreadcrumbElement)) {
                return;
            }
            ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
            if (breadcrumbUtils == null) {
                return;
            }
            if (breadcrumbUtils.isAnonymousElement((IRfBreadcrumbElement)bcElement)) {
                return;
            }
            Menu contextMenu = new Menu((Control)this.getContainer());
            boolean addSeparator = this.addShowTypeHierarchyMenuItem((IRfBreadcrumbElement)bcElement, contextMenu) | this.addShowDiagramMenuItem(contextMenu, (IRfBreadcrumbElement)bcElement) | this.addShowScenarioDiagramMenuItem(contextMenu, (IRfBreadcrumbElement)bcElement);
            if (addSeparator) {
                new MenuItem(contextMenu, 2);
            }
            this.addCopyScopeMenuItem((IRfBreadcrumbElement)bcElement, contextMenu);
            this.addCopyQualifiedNameMenuItem((IRfBreadcrumbElement)bcElement, contextMenu, false);
            contextMenu.setLocation(e.x, e.y);
            contextMenu.setVisible(true);
        };
        this.fElementClickListener = e -> {
            Object eventSource = e.getSource();
            if (!(eventSource instanceof ScopeBreadcrumbViewer)) {
                return;
            }
            Object scopeElement = ((IStructuredSelection)e.getSelection()).getFirstElement();
            if (!(scopeElement instanceof IRfBreadcrumbElement) || scopeElement instanceof IRfLibraryElement) {
                return;
            }
            ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
            if (breadcrumbUtils == null) {
                return;
            }
            breadcrumbUtils.openElement(this.fActiveEditor, scopeElement);
        };
        this.fOpenFromDropDownListener = e -> {
            try {
                Object eventSource = e.getSource();
                if (!(eventSource instanceof ScopeBreadcrumbViewer)) {
                    return;
                }
                ISelection selection = e.getSelection();
                if (!(selection instanceof StructuredSelection)) {
                    return;
                }
                Object selectedElement = ((StructuredSelection)selection).getFirstElement();
                if (!(selectedElement instanceof IRfBreadcrumbElement)) {
                    return;
                }
                IRfBreadcrumbElement selectedScope = (IRfBreadcrumbElement)selectedElement;
                ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
                if (breadcrumbUtils == null) {
                    return;
                }
                IFile file = (IFile)((DVTEditor)this.fActiveEditor).getAdapter(IResource.class);
                if (!breadcrumbUtils.isLibElement(selectedScope)) {
                    selectedScope = breadcrumbUtils.resolveFunctionHolder(selectedScope);
                    breadcrumbUtils.openElement(this.fActiveEditor, selectedScope);
                    if (this.openingLibraryDropdown) {
                        ScopeBreadcrumbConfiguration configuration = new ScopeBreadcrumbConfiguration(this.preLibSelectionLeafSegment, file, true);
                        this.updateNonGUIPart(ScopeBreadcrumbViewer.class, configuration, true);
                        this.openingLibraryDropdown = false;
                    }
                    return;
                }
                ArrayList<BreadcrumbSegment> inputSegments = new ArrayList<BreadcrumbSegment>(2);
                inputSegments.add(new BreadcrumbSegment(this.fBreadcrumbInput.getSegment(0)));
                inputSegments.add(new BreadcrumbSegment(selectedScope));
                AbstractBreadcrumbItem oldItem = this.getItem(0);
                oldItem.closeDropDownMenu();
                this.openingLibraryDropdown = true;
                this.preLibSelectionLeafSegment = this.fBreadcrumbInput.getLeafSegment();
                ScopeBreadcrumbConfiguration configuration = new ScopeBreadcrumbConfiguration((IRfBreadcrumbElement)selectedElement, file, true);
                this.updateNonGUIPart(ScopeBreadcrumbViewer.class, configuration, true);
            }
            catch (Throwable ex) {
                DVTLogger.INSTANCE.logError(ex);
            }
        };
    }

    private boolean addShowTypeHierarchyMenuItem(IRfBreadcrumbElement bcElement, Menu contextMenu) {
        AbstractBreadcrumbUtils breadcrumbUtils = this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
        if (!(breadcrumbUtils instanceof ScopeBreadcrumbUtils)) {
            return false;
        }
        final IRfNamedElement typeHierarchyElement = ((ScopeBreadcrumbUtils)breadcrumbUtils).getTypeHierarchyElement(bcElement);
        if (typeHierarchyElement == null) {
            return false;
        }
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText(SHOW_TYPE_HIERARCHY_TEXT);
        mi.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractBreadcrumbUtils breadcrumbUtils = ScopeBreadcrumbViewer.this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
                if (!(breadcrumbUtils instanceof ScopeBreadcrumbUtils)) {
                    return;
                }
                IProject project = ScopeBreadcrumbViewer.this.getEditor().getProject();
                if (project == null) {
                    return;
                }
                ((ScopeBreadcrumbUtils)breadcrumbUtils).showTypeHierarchy(project, typeHierarchyElement);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return true;
    }

    private void addCopyScopeMenuItem(final IRfBreadcrumbElement bcElement, Menu contextMenu) {
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText(COPY_SCOPE_TEXT);
        this.testCopyScopeSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ro.amiq.dvt.utils.Utils.copyToClipboard(ScopeBreadcrumbViewer.this.fInputLabelProvider.getText(bcElement), 3);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        mi.addSelectionListener(this.testCopyScopeSelectionListener);
    }

    private void addCopyQualifiedNameMenuItem(final IRfBreadcrumbElement bcElement, Menu contextMenu, final boolean fromDropDown) {
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText(COPY_QUALIFIED_NAME_TEXT);
        this.testCopyQualifiedNameSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ScopeBreadcrumbViewer.this.fActiveEditor == null) {
                    return;
                }
                ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)ScopeBreadcrumbViewer.this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
                if (breadcrumbUtils == null) {
                    return;
                }
                ElementPath path = ElementPath.EMPTY_PATH;
                IRfScopeElement elementParent = bcElement.getEnclosingScope();
                if (fromDropDown && elementParent instanceof IRfBreadcrumbElement) {
                    if (!breadcrumbUtils.copyQNExcludeParent(elementParent)) {
                        path = breadcrumbUtils.getQualifiedNamed(ScopeBreadcrumbViewer.this.fBreadcrumbInput, (IRfBreadcrumbElement)((Object)elementParent));
                    }
                    path = ElementPath.join(path, breadcrumbUtils.getText(bcElement, fromDropDown));
                } else {
                    path = breadcrumbUtils.getQualifiedNamed(ScopeBreadcrumbViewer.this.fBreadcrumbInput, bcElement);
                }
                String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(ScopeBreadcrumbViewer.this.getEditor().getProject());
                String fullPath = String.valueOf(path.toString()) + lineDelimiter;
                ro.amiq.dvt.utils.Utils.copyToClipboard(fullPath.trim(), 3);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        mi.addSelectionListener(this.testCopyQualifiedNameSelectionListener);
    }

    private boolean addShowDiagramMenuItem(final Menu contextMenu, IRfBreadcrumbElement bcElement) {
        ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
        final IDVTElementWrapper wrapper = breadcrumbUtils.createShowDiagramWrapper(bcElement);
        final IMenuCommandDelegate delegate = MenuCommandDelegatesManager.getCommandDelegate(wrapper);
        if (delegate == null || !delegate.canShowDiagram(wrapper, ID)) {
            return false;
        }
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText(SHOW_DIAGRAM_TEXT);
        this.testShowDiagramListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Shell dropDownShell;
                if (!delegate.showDiagram(wrapper, ScopeBreadcrumbViewer.ID)) {
                    MessageDialog.openInformation((Shell)contextMenu.getShell(), (String)"Info", (String)ScopeBreadcrumbViewer.OPERATION_NOT_POSSIBLE_WARNING);
                }
                if ((dropDownShell = ScopeBreadcrumbViewer.this.getDropDownShell()) != null) {
                    dropDownShell.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        mi.addSelectionListener(this.testShowDiagramListener);
        return true;
    }

    private boolean addShowScenarioDiagramMenuItem(final Menu contextMenu, IRfBreadcrumbElement bcElement) {
        ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
        final IDVTElementWrapper wrapper = breadcrumbUtils.createShowDiagramWrapper(bcElement);
        final IMenuCommandDelegate delegate = MenuCommandDelegatesManager.getCommandDelegate(wrapper);
        if (delegate == null || !delegate.canShowScenarioDiagram(wrapper)) {
            return false;
        }
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText(SHOW_SCENARIO_TEXT);
        this.testShowScenarioDiagramListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Shell dropDownShell;
                if (!delegate.showScenarioDiagram(wrapper, ScopeBreadcrumbViewer.ID)) {
                    MessageDialog.openInformation((Shell)contextMenu.getShell(), (String)"Info", (String)ScopeBreadcrumbViewer.OPERATION_NOT_POSSIBLE_WARNING);
                }
                if ((dropDownShell = ScopeBreadcrumbViewer.this.getDropDownShell()) != null) {
                    dropDownShell.setVisible(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        mi.addSelectionListener(this.testShowScenarioDiagramListener);
        return true;
    }

    public void refresh() {
        List<AbstractBreadcrumbItem> breadcrumbItems = this.getItems();
        if (breadcrumbItems == null) {
            return;
        }
        for (AbstractBreadcrumbItem item : breadcrumbItems) {
            if (item.isDisposed()) {
                return;
            }
            this.filterItem(item, item.getData());
        }
        super.refresh();
        if (this.openingLibraryDropdown) {
            this.getItem(1).openDropDownMenu();
        }
    }

    @Override
    public void createBreadcrumbDropDownProviders() {
        this.fInputTooltipProvider = new ScopeBCToolTipProvider();
        this.fDropDownLabelProvider = new ScopeBCDropDownLabelProvider((ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class), this.fInputTooltipProvider);
    }

    @Override
    public void createBreadcrumbInputProviders() {
        this.fInputContentProvider = new ScopeBCInputContentProvider(this);
        this.fInputLabelProvider = new ScopeBCInputLabelProvider((ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class));
    }

    @Override
    public void configureDropDownViewer(ColumnViewer viewer, Object input) {
        if (!(viewer instanceof TableViewer) || !(input instanceof IRfBreadcrumbElement)) {
            return;
        }
        this.testTableViewer = ((TableViewer)viewer).getTable();
        this.testTableViewer.addMenuDetectListener(e -> {
            ISelection selection = viewer.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object bcElement = ((IStructuredSelection)selection).getFirstElement();
            if (!(bcElement instanceof IRfBreadcrumbElement)) {
                return;
            }
            if (this.fActiveEditor == null) {
                return;
            }
            ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
            if (breadcrumbUtils == null) {
                return;
            }
            if (breadcrumbUtils.isAnonymousElement((IRfBreadcrumbElement)bcElement)) {
                return;
            }
            Menu contextMenu = new Menu((Control)this.getContainer());
            boolean addSeparator = this.addShowTypeHierarchyMenuItem((IRfBreadcrumbElement)bcElement, contextMenu) | this.addShowDiagramMenuItem(contextMenu, (IRfBreadcrumbElement)bcElement) | this.addShowScenarioDiagramMenuItem(contextMenu, (IRfBreadcrumbElement)bcElement);
            if (addSeparator) {
                new MenuItem(contextMenu, 2);
            }
            this.addCopyScopeMenuItem((IRfBreadcrumbElement)bcElement, contextMenu);
            this.addCopyQualifiedNameMenuItem((IRfBreadcrumbElement)bcElement, contextMenu, true);
            contextMenu.setLocation(e.x, e.y);
            contextMenu.setVisible(true);
        });
        this.fDropDownContentProvider = new ScopeBCLazyDropDownContentProvider((TableViewer)viewer, this, (ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class));
        viewer.setContentProvider(this.fDropDownContentProvider);
        viewer.setUseHashlookup(true);
        viewer.setInput(this.fDropdownElements != null ? this.fDropdownElements.toArray() : null);
        ((TableViewer)viewer).setItemCount(this.fDropdownElements == null ? 0 : this.fDropdownElements.size());
        viewer.setLabelProvider((IBaseLabelProvider)this.fDropDownLabelProvider);
    }

    @Override
    public void computeDropdownElements(Object input) {
        if (!(input instanceof IRfBreadcrumbElement)) {
            return;
        }
        if (this.fActiveEditor == null) {
            return;
        }
        ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
        if (breadcrumbUtils == null) {
            return;
        }
        List<? extends IRfBreadcrumbElement> children = breadcrumbUtils.computeScopeChildren((IRfBreadcrumbElement)input, this.getEditor().getProject(), Integer.MAX_VALUE);
        if (children == null) {
            return;
        }
        children.sort((o1, o2) -> o1.getName().compareToIgnoreCase(o2.getName()));
        this.fDropdownElements = children;
    }

    @Override
    protected AbstractBreadcrumbItem createItem() {
        return new ScopeBreadcrumbItem(this, this.getContainer());
    }

    @Override
    protected void filterItem(AbstractBreadcrumbItem item, Object element) {
        ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
        if (breadcrumbUtils == null) {
            return;
        }
        if (breadcrumbUtils.isRootItem(element)) {
            item.setShowText(false);
        }
        if (breadcrumbUtils.isSingleLibOrPackage(element)) {
            item.setShowText(false);
        }
        if (breadcrumbUtils.isLibOrPackage(element) && !breadcrumbUtils.isSingleLibOrPackage(element)) {
            item.setDetailsEnabled(false);
        } else if (!item.isEnabled()) {
            item.setDetailsEnabled(true);
        }
        item.setGrayedOut(breadcrumbUtils.isGUIFiltered(element));
    }

    @Override
    protected int getWidthOfExtraWidgets() {
        return 0;
    }

    @Override
    public void setBackgroundImageForErrorComposites(Image image) {
    }

    @Override
    public void scheduleComputeOtherInstancesJob() {
    }

    @Override
    public void setSelectOtherInstancesButtonEnable(boolean isReadOnly) {
    }

    public void disposeDropDownModel() {
        if (this.fDropdownElements == null) {
            return;
        }
        this.fDropdownElements.clear();
        this.fDropdownElements = null;
    }

    @Override
    public void dispose() {
        if (this.fActionBlockButtonThemeListener != null) {
            PlatformUI.getWorkbench().getThemeManager().removePropertyChangeListener(this.fActionBlockButtonThemeListener);
        }
        super.dispose();
    }

    @Override
    protected AbstractBreadcrumbUtils getUtils() {
        if (this.fActiveEditor == null) {
            return null;
        }
        return this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
    }

    @Override
    public void hideBreadcrumb() {
        super.hideBreadcrumb();
        ObjectionManager.getInstance().clear(Objection.SCOPE_BC);
    }

    public IOpenListener testGetClickFromDropDownListener() {
        return this.fOpenFromDropDownListener;
    }

    @Override
    public Button testGetSelectOtherInstanceButton() {
        return null;
    }

    public DisplayActionBlocksAction testGetDisplayActionBlocks() {
        return this.displayActionBlocksButton;
    }

    @Override
    public MenuDetectListener testGetMenuDetectListener() {
        return this.fContextMenuListener;
    }

    public SelectionListener testShowDiagramListener() {
        return this.testShowDiagramListener;
    }

    public SelectionListener testShowScenarioDiagramListener() {
        return this.testShowScenarioDiagramListener;
    }

    public SelectionListener testGetCopyListener() {
        return this.testCopyScopeSelectionListener;
    }

    public SelectionListener testGetCopyQualifiedNameListener() {
        return this.testCopyQualifiedNameSelectionListener;
    }

    public void testResetCopyListener() {
        this.testCopyScopeSelectionListener = null;
    }

    public void testResetCopyQualifiedNameListener() {
        this.testCopyQualifiedNameSelectionListener = null;
    }

    public Table testGetDropdownTable() {
        return this.testTableViewer;
    }

    public class DisplayActionBlocksAction
    extends Action {
        public DisplayActionBlocksAction() {
            super("Show/Hide Unnamed Action Blocks", 0);
            if (!(ScopeBreadcrumbViewer.this.fActiveEditor instanceof DVTEditor)) {
                return;
            }
            this.setDescription("Show/Hide Unnamed Action Blocks");
            this.setToolTipText("Show/Hide Unnamed Action Blocks");
            this.setImageDescriptor(DVTImages.SHOW_HIDE_UNNAMED_BLOCKS);
            ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)ScopeBreadcrumbViewer.this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
            if (breadcrumbUtils == null) {
                return;
            }
            this.setChecked(breadcrumbUtils.getShowUnnamedActionBlocks());
        }

        public void run() {
            ScopeBreadcrumbUtils breadcrumbUtils = (ScopeBreadcrumbUtils)ScopeBreadcrumbViewer.this.fActiveEditor.getBreadcrumbUtils(ScopeBreadcrumbViewer.class);
            if (breadcrumbUtils == null) {
                return;
            }
            breadcrumbUtils.setShowUnnamedActionBlocks(!breadcrumbUtils.getShowUnnamedActionBlocks());
            List<IEditorPart> visibleEditors = Utils.computeVisibleEditors();
            for (IEditorPart editor : visibleEditors) {
                Object candidateEditor = editor;
                if (candidateEditor instanceof MultiPageEditorPart) {
                    candidateEditor = ((MultiPageEditorPart)editor).getSelectedPage();
                }
                if (!(candidateEditor instanceof DVTEditor)) continue;
                DVTEditor dvtEditor = (DVTEditor)candidateEditor;
                int cursor = dvtEditor.getCursor();
                IRfBreadcrumbElement scope = breadcrumbUtils.getScopeForBreadcrumb((ITextEditor)dvtEditor, cursor, true);
                ScopeBreadcrumbConfiguration bcConfig = new ScopeBreadcrumbConfiguration(scope, cursor, (IFile)dvtEditor.getAdapter(IResource.class), true);
                dvtEditor.updateBreadcrumb(ScopeBreadcrumbViewer.class, bcConfig);
                AbstractBreadcrumbViewer breadcrumbViewer = dvtEditor.getBreadcrumbViewer(ScopeBreadcrumbViewer.class);
                if (!(breadcrumbViewer instanceof ScopeBreadcrumbViewer)) continue;
                ((ScopeBreadcrumbViewer)breadcrumbViewer).setDisplayActionBlocksState();
            }
        }
    }
}

