/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.spelling;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.spelling.SpellCheckEngine;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellCheckEngine;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellChecker;

public class AddWordProposal
implements ICompletionProposal {
    private final int fLength;
    private final int fOffset;
    private final String fWord;

    public AddWordProposal(String word, int offset, int length) {
        this.fWord = word;
        this.fOffset = offset;
        this.fLength = length;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.createSpellChecker(engine.getLocale(), DVTPlugin.getDefault().getPreferenceStore());
        if (checker != null) {
            checker.addWord(this.fWord);
            try {
                document.replace(this.fOffset, this.fLength, this.fWord);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public String getAdditionalProposalInfo() {
        return "Add the word '" + this.fWord + "' to dictionary";
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return "Add '" + this.fWord + "' to dictionary";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.DESC_ADD_CORRECTION);
    }

    public int getRelevance() {
        return Integer.MIN_VALUE;
    }

    public final Point getSelection(IDocument document) {
        return null;
    }
}

