/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.spelling;

import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.spelling.SpellCheckIterator;
import ro.amiq.dvt.ui.editor.spelling.SpellingEngine;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellChecker;

public class DVTSpellingEngine
extends SpellingEngine {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void check(IDocument document, IRegion[] regions, ISpellChecker checker, Locale locale, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        SpellingEngine.SpellEventListener listener = new SpellingEngine.SpellEventListener(collector);
        try {
            if (document instanceof IDocumentExtension4 && ((IDocumentExtension4)document).getActiveRewriteSession() != null) {
                return;
            }
            String[] patitionings = ((IDocumentExtension3)document).getPartitionings();
            if (patitionings == null) {
                return;
            }
            String partitioningType = null;
            int i = 0;
            while (i < patitionings.length) {
                if (patitionings[i].equals("__e_partitioning") || patitionings[i].equals("__vlog_partitioning") || patitionings[i].equals("__vhdl_partitioning") || patitionings[i].equals("__pss_partitioning") || patitionings[i].equals("__msdl_partitioning")) {
                    partitioningType = patitionings[i];
                }
                ++i;
            }
            if (partitioningType == null) {
                if (patitionings.length == 0) {
                    return;
                }
                partitioningType = patitionings[0];
            }
            checker.addListener(listener);
            try {
                i = 0;
                while (i < regions.length) {
                    IRegion region = regions[i];
                    if (region.getLength() > 0) {
                        ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)document, (String)partitioningType, (int)region.getOffset(), (int)region.getLength(), (boolean)false);
                        int index = 0;
                        while (index < partitions.length) {
                            if (monitor != null && monitor.isCanceled()) {
                                return;
                            }
                            ITypedRegion partition = partitions[index];
                            if (!(partition.getType().equals("__dftl_partition_content_type") || partition.getType().equals("__vlog_escaped_id") || partition.getType().equals("__vhdl_psl_code") || partition.getType().equals("__dftl_partition_content_type") || partition.getType().equals("__dftl_partition_content_type") || partition.getType().equals("__e_expansion"))) {
                                checker.execute(new SpellCheckIterator(document, (IRegion)partition, locale));
                            }
                            ++index;
                        }
                    }
                    ++i;
                }
                return;
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                return;
            }
        }
        finally {
            checker.removeListener(listener);
        }
    }
}

