/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.spelling;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import ro.amiq.dvt.ui.editor.DVTPosition;
import ro.amiq.dvt.ui.editor.spelling.DVTSpellingProblem;
import ro.amiq.dvt.ui.editor.spelling.SpellingProblemAnnotation;

public class DVTSpellingProblemCollector
implements ISpellingProblemCollector {
    private IAnnotationModel fAnnotationModel;
    private Map<Annotation, Position> fAddAnnotations;
    private Object fLockObject;

    public DVTSpellingProblemCollector(IAnnotationModel annotationModel) {
        Assert.isLegal((annotationModel != null ? 1 : 0) != 0);
        this.fAnnotationModel = annotationModel;
        this.fLockObject = this.fAnnotationModel instanceof ISynchronizable ? ((ISynchronizable)this.fAnnotationModel).getLockObject() : this.fAnnotationModel;
    }

    public void accept(SpellingProblem problem) {
        if (problem instanceof DVTSpellingProblem) {
            SpellingProblemAnnotation a = new SpellingProblemAnnotation((DVTSpellingProblem)problem);
            this.fAddAnnotations.put(a, new DVTPosition(problem.getOffset(), problem.getLength()));
        }
    }

    public void beginCollecting() {
        this.fAddAnnotations = new ConcurrentHashMap<Annotation, Position>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCollecting() {
        ArrayList<Annotation> toRemove = new ArrayList<Annotation>();
        Object object = this.fLockObject;
        synchronized (object) {
            Iterator<Annotation> iter = this.fAnnotationModel.getAnnotationIterator();
            while (iter.hasNext()) {
                Annotation annotation = (Annotation)iter.next();
                if (!"org.eclipse.ui.workbench.texteditor.spelling".equals(annotation.getType())) continue;
                toRemove.add(annotation);
            }
            Annotation[] annotationsToRemove = toRemove.toArray(new Annotation[toRemove.size()]);
            if (this.fAnnotationModel instanceof IAnnotationModelExtension) {
                ((IAnnotationModelExtension)this.fAnnotationModel).replaceAnnotations(annotationsToRemove, this.fAddAnnotations);
            } else {
                int i = 0;
                while (i < annotationsToRemove.length) {
                    this.fAnnotationModel.removeAnnotation(annotationsToRemove[i]);
                    ++i;
                }
                for (Annotation annotation : this.fAddAnnotations.keySet()) {
                    this.fAnnotationModel.addAnnotation(annotation, this.fAddAnnotations.get(annotation));
                }
            }
        }
        this.fAddAnnotations = null;
    }
}

