/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.spelling;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.editor.spelling.engine.DefaultSpellChecker;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellCheckEngine;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellChecker;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellDictionary;
import ro.amiq.dvt.ui.editor.spelling.engine.LocaleSensitiveSpellDictionary;
import ro.amiq.dvt.ui.editor.spelling.engine.PersistentSpellDictionary;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class SpellCheckEngine
implements ISpellCheckEngine,
IPropertyChangeListener {
    public static final String DICTIONARY_LOCATION = "dictionaries/";
    private static ISpellCheckEngine fgEngine = null;
    private final Set fGlobalDictionaries = new HashSet();
    private Locale fLocale = null;
    private ISpellChecker fChecker = null;
    private final Map fLocaleDictionaries = new HashMap();
    private IPreferenceStore fPreferences = null;
    private ISpellDictionary fUserDictionary = null;

    public static Set getAvailableLocales() {
        URL url = null;
        Locale locale = null;
        InputStream stream = null;
        HashSet<Locale> result = new HashSet<Locale>();
        try {
            URL location = SpellCheckEngine.getDictionaryLocation();
            if (location == null) {
                return Collections.EMPTY_SET;
            }
            Locale[] locales = Locale.getAvailableLocales();
            int index = 0;
            while (index < locales.length) {
                locale = locales[index];
                url = new URL(location, String.valueOf(locale.toString().toLowerCase()) + ".dictionary");
                try {
                    stream = url.openStream();
                    if (stream != null) {
                        result.add(locale);
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
                ++index;
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return result;
    }

    public static Locale getDefaultLocale() {
        return Locale.getDefault();
    }

    public static URL getDictionaryLocation() throws MalformedURLException {
        DVTPlugin plugin = DVTPlugin.getDefault();
        if (plugin != null) {
            return plugin.getBundle().getEntry("/dictionaries/");
        }
        return null;
    }

    public static final synchronized ISpellCheckEngine getInstance() {
        if (fgEngine == null) {
            fgEngine = new SpellCheckEngine();
        }
        return fgEngine;
    }

    private SpellCheckEngine() {
        try {
            Locale locale2 = null;
            URL location = SpellCheckEngine.getDictionaryLocation();
            for (Locale locale2 : SpellCheckEngine.getAvailableLocales()) {
                this.fLocaleDictionaries.put(locale2, new LocaleSensitiveSpellDictionary(locale2, location));
            }
        }
        catch (MalformedURLException malformedURLException) {}
    }

    @Override
    public final synchronized ISpellChecker createSpellChecker(Locale locale, IPreferenceStore store) {
        ISpellDictionary dictionary2;
        if (this.fLocale != null && this.fLocale.equals(locale)) {
            return this.fChecker;
        }
        if (this.fChecker == null) {
            this.fChecker = new DefaultSpellChecker(store);
            store.addPropertyChangeListener((IPropertyChangeListener)this);
            this.fPreferences = store;
            dictionary2 = null;
            for (ISpellDictionary dictionary2 : this.fGlobalDictionaries) {
                this.fChecker.addDictionary(dictionary2);
            }
        }
        dictionary2 = null;
        if (this.fLocale != null && (dictionary2 = (ISpellDictionary)this.fLocaleDictionaries.get(this.fLocale)) != null) {
            this.fChecker.removeDictionary(dictionary2);
            dictionary2.unload();
        }
        this.fLocale = locale;
        dictionary2 = (ISpellDictionary)this.fLocaleDictionaries.get(locale);
        if (dictionary2 == null) {
            if (!SpellCheckEngine.getDefaultLocale().equals(locale)) {
                if (this.fPreferences != null) {
                    this.fPreferences.removePropertyChangeListener((IPropertyChangeListener)this);
                }
                this.fChecker = null;
                this.fLocale = null;
            }
        } else {
            this.fChecker.addDictionary(dictionary2);
        }
        if (this.fPreferences != null) {
            this.propertyChange(new PropertyChangeEvent((Object)this, "spelling_user_dictionary", null, (Object)this.fPreferences.getString("spelling_user_dictionary")));
        }
        return this.fChecker;
    }

    @Override
    public final Locale getLocale() {
        return this.fLocale;
    }

    public final void propertyChange(PropertyChangeEvent event) {
        block9: {
            if (this.fChecker != null && event.getProperty().equals("spelling_user_dictionary")) {
                String file;
                if (this.fUserDictionary != null) {
                    this.fChecker.removeDictionary(this.fUserDictionary);
                    this.fUserDictionary = null;
                }
                if ((file = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables((String)event.getNewValue())).length() > 0) {
                    try {
                        URL url = new URL("file", null, file);
                        InputStream stream = url.openStream();
                        if (stream == null) break block9;
                        try {
                            this.fUserDictionary = new PersistentSpellDictionary(url);
                            this.fChecker.addDictionary(this.fUserDictionary);
                        }
                        finally {
                            stream.close();
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public final synchronized void registerDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.add(dictionary);
        if (this.fChecker != null) {
            this.fChecker.addDictionary(dictionary);
        }
    }

    @Override
    public final synchronized void registerDictionary(Locale locale, ISpellDictionary dictionary) {
        this.fLocaleDictionaries.put(locale, dictionary);
        if (this.fChecker != null && this.fLocale != null && this.fLocale.equals(locale)) {
            this.fChecker.addDictionary(dictionary);
        }
    }

    @Override
    public final synchronized void unload() {
        ISpellDictionary dictionary2 = null;
        for (ISpellDictionary dictionary2 : this.fGlobalDictionaries) {
            dictionary2.unload();
        }
        for (ISpellDictionary dictionary2 : this.fLocaleDictionaries.values()) {
            dictionary2.unload();
        }
        if (this.fPreferences != null) {
            this.fPreferences.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fUserDictionary = null;
        this.fChecker = null;
    }

    @Override
    public final synchronized void unregisterDictionary(ISpellDictionary dictionary) {
        this.fGlobalDictionaries.remove(dictionary);
        this.fLocaleDictionaries.values().remove(dictionary);
        if (this.fChecker != null) {
            this.fChecker.removeDictionary(dictionary);
        }
        dictionary.unload();
    }
}

