/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.spelling;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.spelling.IHtmlTagConstants;
import ro.amiq.dvt.ui.editor.textchanges.DVTFileModificationValidator;

public class WordCorrectionProposal
implements ICompletionProposal,
IHtmlTagConstants {
    private final int fLength;
    private final int fOffset;
    private final int fRelevance;
    private final String fWord;
    private ITextViewer fViewer;

    public static String getHtmlRepresentation(String string) {
        int length = string.length();
        StringBuilder buffer = new StringBuilder(string);
        int offset = length - 1;
        while (offset >= 0) {
            int index = 0;
            while (index < HTML_ENTITY_CHARACTERS.length) {
                if (string.charAt(offset) == HTML_ENTITY_CHARACTERS[index]) {
                    buffer.replace(offset, offset + 1, String.valueOf(HTML_ENTITY_CODES[index]));
                    break;
                }
                ++index;
            }
            --offset;
        }
        return buffer.toString();
    }

    public WordCorrectionProposal(ITextViewer viewer, String word, int offset, int length, int relevance) {
        this.fViewer = viewer;
        this.fWord = Character.isUpperCase(word.charAt(0)) ? String.valueOf(Character.toUpperCase(word.charAt(0))) + word.substring(1) : word;
        this.fOffset = offset;
        this.fLength = length;
        this.fRelevance = relevance;
    }

    public final void apply(IDocument document) {
        try {
            DVTFileModificationValidator.validateEdit(this.fViewer);
            document.replace(this.fOffset, this.fLength, this.fWord);
        }
        catch (CoreException | BadLocationException throwable) {}
    }

    public String getAdditionalProposalInfo() {
        return "// " + this.fWord;
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return "Change to '" + this.fWord + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.DESC_CORRECTION_RENAME);
    }

    public final int getRelevance() {
        return this.fRelevance;
    }

    public final Point getSelection(IDocument document) {
        return null;
    }
}

