/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.spelling;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.editor.spelling.DVTSpellingProblem;
import ro.amiq.dvt.ui.editor.spelling.SpellCheckEngine;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellCheckEngine;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellChecker;

public class WordIgnoreProposal
implements ICompletionProposal {
    private String fWord;

    public WordIgnoreProposal(String word) {
        this.fWord = word;
    }

    public final void apply(IDocument document) {
        ISpellCheckEngine engine = SpellCheckEngine.getInstance();
        ISpellChecker checker = engine.createSpellChecker(engine.getLocale(), DVTPlugin.getDefault().getPreferenceStore());
        if (checker != null) {
            checker.ignoreWord(this.fWord);
            DVTSpellingProblem.removeAllInActiveEditor(this.fWord);
        }
    }

    public String getAdditionalProposalInfo() {
        return "Always ignore: '" + this.fWord + "' during the current session";
    }

    public final IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return "Always ignore: '" + this.fWord + "'";
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.DESC_NEVER_TRANSLATE);
    }

    public final int getRelevance() {
        return -2147483647;
    }

    public final Point getSelection(IDocument document) {
        return null;
    }
}

