/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.spelling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.editor.spelling.AddWordProposal;
import ro.amiq.dvt.ui.editor.spelling.ChangeCaseProposal;
import ro.amiq.dvt.ui.editor.spelling.DVTSpellingProblem;
import ro.amiq.dvt.ui.editor.spelling.SpellCheckEngine;
import ro.amiq.dvt.ui.editor.spelling.SpellingProblemAnnotation;
import ro.amiq.dvt.ui.editor.spelling.WordCorrectionProposal;
import ro.amiq.dvt.ui.editor.spelling.WordIgnoreProposal;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellCheckEngine;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellChecker;
import ro.amiq.dvt.ui.editor.spelling.engine.RankedWordProposal;

public class WordQuickFixProcessor
implements IContentAssistProcessor {
    private ITextEditor fTextEditor;

    public WordQuickFixProcessor(ITextEditor textEditor) {
        this.fTextEditor = textEditor;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        ICompletionProposal[] result = null;
        int threshold = DVTPlugin.getDefault().getPreferenceStore().getInt("spelling_proposal_threshold");
        IAnnotationModel annotationModel = this.getAnnotationModel(this.fTextEditor);
        if (annotationModel != null) {
            Iterator iter = annotationModel.getAnnotationIterator();
            while (iter.hasNext()) {
                boolean extendable;
                Annotation annotation = (Annotation)iter.next();
                if (!(annotation instanceof SpellingProblemAnnotation)) continue;
                SpellingProblemAnnotation spellingProblemAnnotation = (SpellingProblemAnnotation)annotation;
                DVTSpellingProblem spellingProblem = spellingProblemAnnotation.getSpellingProblem();
                Position position = annotationModel.getPosition(annotation);
                if (offset < position.getOffset() || offset > position.getOffset() + position.getLength()) continue;
                boolean match = spellingProblem.isDictionaryMatch();
                boolean sentence = spellingProblem.isSentenceStart();
                List proposals = null;
                RankedWordProposal proposal = null;
                ISpellCheckEngine engine = SpellCheckEngine.getInstance();
                ISpellChecker checker = engine.createSpellChecker(engine.getLocale(), DVTPlugin.getDefault().getPreferenceStore());
                if (sentence && match) {
                    result = new ICompletionProposal[]{new ChangeCaseProposal(viewer, spellingProblem.getWord(), spellingProblem.getOffset(), spellingProblem.getLength())};
                    continue;
                }
                proposals = new ArrayList(checker.getProposals(spellingProblem.getWord(), sentence));
                int size = proposals.size();
                int index = 0;
                if (threshold > 0 && size > threshold) {
                    Collections.sort(proposals);
                    proposals = proposals.subList(size - threshold - 1, size - 1);
                    size = proposals.size();
                }
                result = new ICompletionProposal[size + ((extendable = checker.acceptsWords()) ? 2 : 1)];
                index = 0;
                while (index < size) {
                    proposal = (RankedWordProposal)proposals.get(index);
                    result[index] = new WordCorrectionProposal(viewer, proposal.getText(), spellingProblem.getOffset(), spellingProblem.getLength(), proposal.getRank());
                    ++index;
                }
                if (extendable) {
                    result[index++] = new AddWordProposal(spellingProblem.getWord(), spellingProblem.getOffset(), spellingProblem.getLength());
                }
                result[index++] = new WordIgnoreProposal(spellingProblem.getWord());
            }
        }
        return result;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return null;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    protected IAnnotationModel getAnnotationModel(ITextEditor editor) {
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider != null) {
            return documentProvider.getAnnotationModel((Object)editor.getEditorInput());
        }
        return null;
    }
}

