/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.spelling.engine;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.spelling.engine.DefaultPhoneticHashProvider;
import ro.amiq.dvt.ui.editor.spelling.engine.IPhoneticHashProvider;
import ro.amiq.dvt.ui.editor.spelling.engine.ISpellDictionary;
import ro.amiq.dvt.ui.editor.spelling.engine.RankedWordProposal;
import ro.amiq.dvt.utils.DefaultPhoneticDistanceAlgorithm;
import ro.amiq.dvt.utils.IPhoneticDistanceAlgorithm;

public abstract class AbstractSpellDictionary
implements ISpellDictionary {
    protected static final int BUCKET_CAPACITY = 4;
    protected static final int BUFFER_CAPACITY = 32;
    protected static final int DISTANCE_THRESHOLD = 160;
    protected static final int HASH_CAPACITY = 22528;
    private IPhoneticDistanceAlgorithm fDistanceAlgorithm = new DefaultPhoneticDistanceAlgorithm();
    private final Map fHashBuckets = new HashMap(22528);
    private IPhoneticHashProvider fHashProvider = new DefaultPhoneticHashProvider();
    private boolean fLoaded = false;
    private boolean fMustLoad = true;

    protected final ArrayList getCandidates(String hash) {
        ArrayList list = (ArrayList)this.fHashBuckets.get(hash);
        if (list == null) {
            list = new ArrayList(0);
        }
        return list;
    }

    protected final HashSet getCandidates(String word, boolean sentence, ArrayList hashs) {
        int distance = 0;
        String hash = null;
        String candidate = null;
        ArrayList candidates = null;
        StringBuilder buffer = new StringBuilder(32);
        HashSet<RankedWordProposal> result = new HashSet<RankedWordProposal>(4 * hashs.size());
        int index = 0;
        while (index < hashs.size()) {
            hash = (String)hashs.get(index);
            candidates = this.getCandidates(hash);
            int offset = 0;
            while (offset < candidates.size()) {
                candidate = (String)candidates.get(offset);
                distance = this.fDistanceAlgorithm.getDistance(word, candidate);
                if (distance < 160) {
                    buffer.setLength(0);
                    buffer.append(candidate);
                    if (sentence) {
                        buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                    }
                    result.add(new RankedWordProposal(buffer.toString(), -distance));
                }
                ++offset;
            }
            ++index;
        }
        return result;
    }

    protected final void getCandidates(String word, boolean sentence, HashSet result) {
        int distance = 0;
        int minimum = Integer.MAX_VALUE;
        String candidate = null;
        StringBuilder buffer = new StringBuilder(32);
        ArrayList candidates = this.getCandidates(this.fHashProvider.getHash(word));
        ArrayList<RankedWordProposal> matches = new ArrayList<RankedWordProposal>(candidates.size());
        int index = 0;
        while (index < candidates.size()) {
            candidate = (String)candidates.get(index);
            distance = this.fDistanceAlgorithm.getDistance(word, candidate);
            if (distance <= minimum) {
                buffer.setLength(0);
                buffer.append(candidate);
                if (sentence) {
                    buffer.setCharAt(0, Character.toUpperCase(buffer.charAt(0)));
                }
                matches.add(new RankedWordProposal(buffer.toString(), -distance));
                minimum = distance;
            }
            ++index;
        }
        RankedWordProposal match = null;
        int index2 = 0;
        while (index2 < matches.size()) {
            match = (RankedWordProposal)matches.get(index2);
            if (match.getRank() == minimum) {
                result.add(match);
            }
            ++index2;
        }
    }

    protected final IPhoneticDistanceAlgorithm getDistanceAlgorithm() {
        return this.fDistanceAlgorithm;
    }

    protected final IPhoneticHashProvider getHashProvider() {
        return this.fHashProvider;
    }

    @Override
    public Set getProposals(String word, boolean sentence) {
        try {
            if (this.fMustLoad) {
                this.load(this.getURL());
            }
        }
        catch (MalformedURLException malformedURLException) {}
        String hash = this.fHashProvider.getHash(word);
        char[] mutators = this.fHashProvider.getMutators();
        ArrayList<String> neighborhood = new ArrayList<String>((word.length() + 1) * (mutators.length + 2));
        neighborhood.add(hash);
        HashSet candidates = this.getCandidates(word, sentence, neighborhood);
        neighborhood.clear();
        char previous = '\u0000';
        char next = '\u0000';
        char[] characters = word.toCharArray();
        int index = 0;
        while (index < word.length() - 1) {
            next = characters[index];
            characters[index] = previous = characters[index + 1];
            characters[index + 1] = next;
            neighborhood.add(this.fHashProvider.getHash(new String(characters)));
            characters[index] = next;
            characters[index + 1] = previous;
            ++index;
        }
        String sentinel = String.valueOf(word) + " ";
        characters = sentinel.toCharArray();
        int offset = characters.length - 1;
        while (true) {
            int index2 = 0;
            while (index2 < mutators.length) {
                characters[offset] = mutators[index2];
                neighborhood.add(this.fHashProvider.getHash(new String(characters)));
                ++index2;
            }
            if (offset == 0) break;
            characters[offset] = characters[offset - 1];
            --offset;
        }
        char mutated = '\u0000';
        characters = word.toCharArray();
        int index3 = 0;
        while (index3 < word.length()) {
            mutated = characters[index3];
            int mutator = 0;
            while (mutator < mutators.length) {
                characters[index3] = mutators[mutator];
                neighborhood.add(this.fHashProvider.getHash(new String(characters)));
                ++mutator;
            }
            characters[index3] = mutated;
            ++index3;
        }
        characters = word.toCharArray();
        char[] deleted = new char[characters.length - 1];
        int index4 = 0;
        while (index4 < deleted.length) {
            deleted[index4] = characters[index4];
            ++index4;
        }
        next = characters[characters.length - 1];
        offset = deleted.length;
        while (true) {
            neighborhood.add(this.fHashProvider.getHash(new String(characters)));
            if (offset == 0) break;
            previous = next;
            next = deleted[offset - 1];
            deleted[offset - 1] = previous;
            --offset;
        }
        neighborhood.remove(hash);
        HashSet matches = this.getCandidates(word, sentence, neighborhood);
        if (matches.isEmpty() && candidates.isEmpty()) {
            this.getCandidates(word, sentence, candidates);
        }
        candidates.addAll(matches);
        int i = 0;
        while (i < candidates.size()) {
            ++i;
        }
        return candidates;
    }

    protected abstract URL getURL() throws MalformedURLException;

    protected final void hashWord(String word) {
        String hash = this.fHashProvider.getHash(word);
        ArrayList<String> bucket = (ArrayList<String>)this.fHashBuckets.get(hash);
        if (bucket == null) {
            bucket = new ArrayList<String>(4);
            this.fHashBuckets.put(hash, bucket);
        }
        bucket.add(word);
    }

    @Override
    public boolean isCorrect(String word) {
        ArrayList candidates;
        try {
            if (this.fMustLoad) {
                this.load(this.getURL());
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return (candidates = this.getCandidates(this.fHashProvider.getHash(word))).contains(word) || candidates.contains(word.toLowerCase());
    }

    @Override
    public final synchronized boolean isLoaded() {
        return this.fLoaded || this.fHashBuckets.size() > 0;
    }

    /*
     * Loose catch block
     */
    protected synchronized boolean load(URL url) {
        if (url != null) {
            try {
                boolean bl;
                BufferedReader reader;
                InputStream stream;
                Throwable throwable;
                block25: {
                    block24: {
                        throwable = null;
                        Object var3_5 = null;
                        stream = url.openStream();
                        reader = new BufferedReader(new InputStreamReader(stream));
                        String word = null;
                        while ((word = reader.readLine()) != null) {
                            this.hashWord(word);
                        }
                        this.fLoaded = true;
                        bl = true;
                        if (reader == null) break block24;
                        reader.close();
                    }
                    if (stream == null) break block25;
                    stream.close();
                }
                return bl;
                {
                    catch (Throwable throwable2) {
                        try {
                            try {
                                try {
                                    if (reader != null) {
                                        reader.close();
                                    }
                                    throw throwable2;
                                }
                                catch (Throwable throwable3) {
                                    if (throwable == null) {
                                        throwable = throwable3;
                                    } else if (throwable != throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    if (stream != null) {
                                        stream.close();
                                    }
                                    throw throwable;
                                }
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            DVTLogger.INSTANCE.logError((Throwable)e);
                        }
                    }
                }
            }
            finally {
                this.fMustLoad = false;
            }
        }
        return false;
    }

    protected final void setDistanceAlgorithm(IPhoneticDistanceAlgorithm algorithm) {
        this.fDistanceAlgorithm = algorithm;
    }

    protected final void setHashProvider(IPhoneticHashProvider provider) {
        this.fHashProvider = provider;
    }

    @Override
    public synchronized void unload() {
        this.fLoaded = false;
        this.fHashBuckets.clear();
    }

    @Override
    public boolean acceptsWords() {
        return false;
    }

    @Override
    public void addWord(String word) {
    }
}

