/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.spelling.engine;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.URL;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.spelling.engine.AbstractSpellDictionary;

public class PersistentSpellDictionary
extends AbstractSpellDictionary {
    private final URL fLocation;

    public PersistentSpellDictionary(URL url) {
        this.fLocation = url;
    }

    @Override
    public boolean acceptsWords() {
        return new File(this.fLocation.getPath()).canWrite();
    }

    @Override
    public void addWord(String word) {
        if (!this.isCorrect(word)) {
            this.hashWord(word);
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.fLocation.getPath(), true));){
                    writer.write(word);
                    writer.write("\n");
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
            }
        }
    }

    @Override
    protected final URL getURL() {
        return this.fLocation;
    }
}

