/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.spelling.engine;

import java.io.File;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.texteditor.spelling.IPreferenceStatusMonitor;
import org.eclipse.ui.texteditor.spelling.ISpellingPreferenceBlock;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.ui.preferences.IStatusChangeListener;
import ro.amiq.dvt.ui.preferences.StatusInfo;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class SpellingPreferenceBlock
implements ISpellingPreferenceBlock {
    private Button SPELLING_IGNORE_DIGITS_FIELD;
    private Button SPELLING_IGNORE_MIXED_FIELD;
    private Button SPELLING_IGNORE_SENTENCE_FIELD;
    private Button SPELLING_IGNORE_UPPER_FIELD;
    private Label SPELLING_USER_DICTIONARY_LABEL;
    private Text SPELLING_USER_DICTIONARY_FIELD;
    private Button SPELLING_USER_DICTIONARY_BROWSE;
    private Label SPELLING_PROPOSAL_THRESHOLD_LABEL;
    private Text SPELLING_PROPOSAL_THRESHOLD_FIELD;
    private Label SPELLING_MAX_REPORTED_ERRORS_LABEL;
    private Text SPELLING_MAX_REPORTED_ERRORS_FIELD;
    private IPreferenceStore fStore = DVTPlugin.getDefault().getPreferenceStore();
    private StatusChangeListenerAdapter fStatusMonitor;
    private ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            StatusInfo dictionaryStatus = new StatusInfo();
            StatusInfo thresholdStatus = new StatusInfo();
            String text = SpellingPreferenceBlock.this.SPELLING_USER_DICTIONARY_FIELD.getText();
            if (text.length() != 0) {
                File file;
                String translatedPath = DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(text);
                if (translatedPath != null) {
                    text = translatedPath;
                }
                if (!((file = new File(text)).isFile() && file.isAbsolute() && file.exists() && file.canRead())) {
                    dictionaryStatus.setError("The dictionary file must be read accessible.");
                } else {
                    dictionaryStatus.setOK();
                }
            }
            int threshold = 0;
            text = SpellingPreferenceBlock.this.SPELLING_PROPOSAL_THRESHOLD_FIELD.getText();
            if (text.length() == 0) {
                thresholdStatus.setError("A maximum number of correction proposals must be specified.");
            } else {
                try {
                    threshold = Integer.parseInt(text);
                    if (threshold < 0) {
                        thresholdStatus.setError("'" + text + "' is not a valid maximum number of correction proposals.");
                    } else {
                        thresholdStatus.setOK();
                    }
                }
                catch (Exception exception) {
                    thresholdStatus.setError("'" + text + "' is not a valid maximum number of correction proposals.");
                }
            }
            SpellingPreferenceBlock.this.fStatusMonitor.statusChanged(SpellingPreferenceBlock.getMoreSevere(thresholdStatus, dictionaryStatus));
        }
    };

    public boolean canPerformOk() {
        return this.fStatusMonitor == null || this.fStatusMonitor.getStatus() == null || !this.fStatusMonitor.getStatus().matches(4);
    }

    private Group createGroup(int numColumns, Composite parent, String text) {
        Group group = new Group(parent, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = numColumns;
        gd.widthHint = 0;
        group.setLayoutData((Object)gd);
        group.setFont(parent.getFont());
        GridLayout layout = new GridLayout(numColumns, false);
        group.setLayout((Layout)layout);
        group.setText(text);
        return group;
    }

    protected Button addCheckBox(Composite composite, String labelText, int indentation) {
        Button checkBox = new Button(composite, 32);
        checkBox.setText(labelText);
        checkBox.setFont(composite.getFont());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        return checkBox;
    }

    protected Control[] addLabelledTextFieldBrowse(final Composite composite, String label, int indentation) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        labelControl.setFont(composite.getFont());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        final Text textControl = new Text(composite, 2052);
        gd = new GridData(768);
        textControl.setLayoutData((Object)gd);
        textControl.setFont(composite.getFont());
        Button browseButton = new Button(composite, 8);
        browseButton.setText("&Browse...");
        browseButton.setFont(composite.getFont());
        GridData specmanButtonGridData = new GridData(32);
        browseButton.setLayoutData((Object)specmanButtonGridData);
        browseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String filterPath = "";
                File f2 = new File(DVTUtilsCommon.INSTANCE.replaceAllSystemVariables(textControl.getText()));
                if (f2.exists()) {
                    filterPath = f2.getParent();
                }
                FileDialog fileDialog = new FileDialog(composite.getShell());
                fileDialog.setFilterPath(filterPath);
                String selectedFile = fileDialog.open();
                if (selectedFile != null) {
                    textControl.setText(selectedFile);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return new Control[]{labelControl, textControl, browseButton};
    }

    protected Control[] addLabelledTextField(Composite composite, String label, int textLimit, int indentation) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        labelControl.setFont(composite.getFont());
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = Dialog.convertWidthInCharsToPixels((FontMetrics)this.getFontMetrics((Control)composite), (int)(textLimit + 1));
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        textControl.setFont(composite.getFont());
        return new Control[]{labelControl, textControl};
    }

    private FontMetrics getFontMetrics(Control control) {
        GC gc = null;
        try {
            gc = new GC((Drawable)control);
            FontMetrics fontMetrics = gc.getFontMetrics();
            return fontMetrics;
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout(1, true);
        composite.setLayout((Layout)compositeLayout);
        Group optionsGroup = this.createGroup(1, composite, "&Options");
        this.SPELLING_IGNORE_DIGITS_FIELD = this.addCheckBox((Composite)optionsGroup, "Ignore &words with digits", 1);
        this.SPELLING_IGNORE_MIXED_FIELD = this.addCheckBox((Composite)optionsGroup, "Ignore &mixed case words", 1);
        this.SPELLING_IGNORE_SENTENCE_FIELD = this.addCheckBox((Composite)optionsGroup, "Ignore &sentence capitalization", 1);
        this.SPELLING_IGNORE_UPPER_FIELD = this.addCheckBox((Composite)optionsGroup, "Ignore u&pper case words", 1);
        Group languageGroup = this.createGroup(3, composite, "&Language");
        Control[] dictionaryField = this.addLabelledTextFieldBrowse((Composite)languageGroup, "&User defined dictionary:", 1);
        this.SPELLING_USER_DICTIONARY_LABEL = (Label)dictionaryField[0];
        this.SPELLING_USER_DICTIONARY_FIELD = (Text)dictionaryField[1];
        this.SPELLING_USER_DICTIONARY_BROWSE = (Button)dictionaryField[2];
        Group advancedGroup = this.createGroup(2, composite, "Ad&vanced");
        Control[] advancedField = this.addLabelledTextField((Composite)advancedGroup, "Maximum number of problems repor&ted per file:", 3, 1);
        this.SPELLING_MAX_REPORTED_ERRORS_LABEL = (Label)advancedField[0];
        this.SPELLING_MAX_REPORTED_ERRORS_FIELD = (Text)advancedField[1];
        advancedField = this.addLabelledTextField((Composite)advancedGroup, "Maximum &number of correction proposals:", 3, 1);
        this.SPELLING_PROPOSAL_THRESHOLD_LABEL = (Label)advancedField[0];
        this.SPELLING_PROPOSAL_THRESHOLD_FIELD = (Text)advancedField[1];
        return composite;
    }

    public void dispose() {
        this.SPELLING_USER_DICTIONARY_FIELD.removeModifyListener(this.fModifyListener);
        this.SPELLING_PROPOSAL_THRESHOLD_FIELD.removeModifyListener(this.fModifyListener);
        this.fModifyListener = null;
        this.SPELLING_IGNORE_DIGITS_FIELD.dispose();
        this.SPELLING_IGNORE_MIXED_FIELD.dispose();
        this.SPELLING_IGNORE_SENTENCE_FIELD.dispose();
        this.SPELLING_IGNORE_UPPER_FIELD.dispose();
        this.SPELLING_USER_DICTIONARY_LABEL.dispose();
        this.SPELLING_USER_DICTIONARY_FIELD.dispose();
        this.SPELLING_USER_DICTIONARY_BROWSE.dispose();
        this.SPELLING_PROPOSAL_THRESHOLD_LABEL.dispose();
        this.SPELLING_PROPOSAL_THRESHOLD_FIELD.dispose();
        this.SPELLING_MAX_REPORTED_ERRORS_LABEL.dispose();
        this.SPELLING_MAX_REPORTED_ERRORS_FIELD.dispose();
    }

    public void initialize(IPreferenceStatusMonitor statusMonitor) {
        this.fStatusMonitor = new StatusChangeListenerAdapter(statusMonitor);
        this.SPELLING_IGNORE_DIGITS_FIELD.setSelection(this.fStore.getBoolean("spelling_ignore_digits"));
        this.SPELLING_IGNORE_MIXED_FIELD.setSelection(this.fStore.getBoolean("spelling_ignore_mixed"));
        this.SPELLING_IGNORE_SENTENCE_FIELD.setSelection(this.fStore.getBoolean("spelling_ignore_sentence"));
        this.SPELLING_IGNORE_UPPER_FIELD.setSelection(this.fStore.getBoolean("spelling_ignore_upper"));
        this.SPELLING_USER_DICTIONARY_FIELD.setText(this.fStore.getString("spelling_user_dictionary"));
        this.SPELLING_PROPOSAL_THRESHOLD_FIELD.setText("" + this.fStore.getInt("spelling_proposal_threshold"));
        this.SPELLING_MAX_REPORTED_ERRORS_FIELD.setText("" + this.fStore.getInt("spelling_max_reported_errors"));
        this.SPELLING_USER_DICTIONARY_FIELD.addModifyListener(this.fModifyListener);
        this.SPELLING_PROPOSAL_THRESHOLD_FIELD.addModifyListener(this.fModifyListener);
        this.SPELLING_MAX_REPORTED_ERRORS_FIELD.addModifyListener(this.fModifyListener);
    }

    public void performDefaults() {
        this.SPELLING_IGNORE_DIGITS_FIELD.setSelection(this.fStore.getDefaultBoolean("spelling_ignore_digits"));
        this.SPELLING_IGNORE_MIXED_FIELD.setSelection(this.fStore.getDefaultBoolean("spelling_ignore_mixed"));
        this.SPELLING_IGNORE_SENTENCE_FIELD.setSelection(this.fStore.getDefaultBoolean("spelling_ignore_sentence"));
        this.SPELLING_IGNORE_UPPER_FIELD.setSelection(this.fStore.getDefaultBoolean("spelling_ignore_upper"));
        this.SPELLING_USER_DICTIONARY_FIELD.setText(this.fStore.getDefaultString("spelling_user_dictionary"));
        this.SPELLING_PROPOSAL_THRESHOLD_FIELD.setText("" + this.fStore.getDefaultInt("spelling_proposal_threshold"));
        this.SPELLING_MAX_REPORTED_ERRORS_FIELD.setText("" + this.fStore.getDefaultInt("spelling_max_reported_errors"));
    }

    public void performOk() {
        this.fStore.setValue("spelling_ignore_digits", this.SPELLING_IGNORE_DIGITS_FIELD.getSelection());
        this.fStore.setValue("spelling_ignore_mixed", this.SPELLING_IGNORE_MIXED_FIELD.getSelection());
        this.fStore.setValue("spelling_ignore_sentence", this.SPELLING_IGNORE_SENTENCE_FIELD.getSelection());
        this.fStore.setValue("spelling_ignore_upper", this.SPELLING_IGNORE_UPPER_FIELD.getSelection());
        this.fStore.setValue("spelling_user_dictionary", this.SPELLING_USER_DICTIONARY_FIELD.getText());
        this.fStore.setValue("spelling_proposal_threshold", Integer.parseInt(this.SPELLING_PROPOSAL_THRESHOLD_FIELD.getText()));
        this.fStore.setValue("spelling_max_reported_errors", Integer.parseInt(this.SPELLING_MAX_REPORTED_ERRORS_FIELD.getText()));
    }

    public void performRevert() {
        this.performDefaults();
    }

    public void setEnabled(boolean enabled) {
        this.SPELLING_IGNORE_DIGITS_FIELD.setEnabled(enabled);
        this.SPELLING_IGNORE_MIXED_FIELD.setEnabled(enabled);
        this.SPELLING_IGNORE_SENTENCE_FIELD.setEnabled(enabled);
        this.SPELLING_IGNORE_UPPER_FIELD.setEnabled(enabled);
        this.SPELLING_USER_DICTIONARY_LABEL.setEnabled(enabled);
        this.SPELLING_USER_DICTIONARY_FIELD.setEnabled(enabled);
        this.SPELLING_USER_DICTIONARY_BROWSE.setEnabled(enabled);
        this.SPELLING_PROPOSAL_THRESHOLD_LABEL.setEnabled(enabled);
        this.SPELLING_MAX_REPORTED_ERRORS_LABEL.setEnabled(enabled);
        this.SPELLING_PROPOSAL_THRESHOLD_FIELD.setEnabled(enabled);
        this.SPELLING_MAX_REPORTED_ERRORS_FIELD.setEnabled(enabled);
    }

    public static IStatus getMoreSevere(IStatus s1, IStatus s2) {
        if (s1.getSeverity() > s2.getSeverity()) {
            return s1;
        }
        return s2;
    }

    private static class StatusChangeListenerAdapter
    implements IStatusChangeListener {
        private IPreferenceStatusMonitor fMonitor;
        private IStatus fStatus;

        public StatusChangeListenerAdapter(IPreferenceStatusMonitor monitor) {
            this.fMonitor = monitor;
        }

        @Override
        public void statusChanged(IStatus status) {
            this.fStatus = status;
            this.fMonitor.statusChanged(status);
        }

        public IStatus getStatus() {
            return this.fStatus;
        }
    }
}

