/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.textchanges;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextViewer;
import ro.amiq.dvt.utils.DVTFileUtils;

public class DVTFileModificationValidator {
    private static boolean internalValidateEdit(IProgressMonitor monitor, final IFile[] filesAboutToChange) {
        return DVTFileUtils.getInstance().fixFileModificationValidatorPermissions((IResource[])filesAboutToChange, new Callable<IStatus>(){

            @Override
            public IStatus call() {
                List<IFile> onlyreadonly = Arrays.asList(filesAboutToChange).stream().filter(x -> x.isReadOnly()).collect(Collectors.toList());
                return ResourcesPlugin.getWorkspace().validateEdit(onlyreadonly.toArray(new IFile[onlyreadonly.size()]), (Object)FileModificationValidationContext.VALIDATE_PROMPT);
            }
        }, false, monitor);
    }

    private static boolean allWritable(IFile[] filesAboutToChange) {
        IFile[] iFileArray = filesAboutToChange;
        int n = filesAboutToChange.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            if (file.isReadOnly()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static void validateEdit(IProgressMonitor monitor, IFile[] filesAboutToChange, boolean throwExceptionForDecline) throws CoreException {
        boolean userDeclinedCheckingOutFiles = DVTFileModificationValidator.internalValidateEdit(null, filesAboutToChange);
        if (userDeclinedCheckingOutFiles && !throwExceptionForDecline) {
            return;
        }
        if (!DVTFileModificationValidator.allWritable(filesAboutToChange)) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
    }

    public static void validateEdit(IProgressMonitor monitor, IFile[] filesAboutToChange) throws CoreException {
        DVTFileModificationValidator.validateEdit(monitor, filesAboutToChange, true);
    }

    public static void validateEdit(IFile file) throws CoreException {
        if (file == null) {
            return;
        }
        IFile[] affectedFiles = new IFile[]{file};
        DVTFileModificationValidator.validateEdit(null, affectedFiles);
    }

    public static void validateEdit(ITextViewer viewer) throws CoreException {
        DVTFileModificationValidator.validateEdit(DVTFileUtils.getInstance().getFileFromViewer(viewer));
    }
}

