/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.vhbreadcrumb;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.editor.breadcrumb.BCDropDownContentProvider;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBCDropDownLabelProvider;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.ViewsUtils;
import ro.amiq.dvt.utils.StringMatcher;

public class VHBCLazyDropDownContentProvider
extends BCDropDownContentProvider
implements ILazyContentProvider {
    private VHBreadcrumbViewer vhBreadcrumbViewer;
    private TableViewer dropdownViewer;
    private Object[] elements;
    private String prefix;
    private boolean wasFiltered;

    public VHBCLazyDropDownContentProvider(TableViewer viewer, VHBreadcrumbViewer vhBreadcrumbViewer) {
        this.dropdownViewer = viewer;
        this.vhBreadcrumbViewer = vhBreadcrumbViewer;
    }

    public void dispose() {
        try {
            if (this.vhBreadcrumbViewer != null) {
                this.vhBreadcrumbViewer.disposeDropDownModel();
            }
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.elements = (Object[])newInput;
    }

    public void updateElement(int index) {
        try {
            if (index >= this.elements.length) {
                return;
            }
            this.dropdownViewer.replace(this.elements[index], index);
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public void setPrefix(String text) {
        this.prefix = text;
    }

    public void filterInput(String text, List<IDVTElementWrapper> dropdownElements) {
        try {
            if (text == null || text.equals("")) {
                if (!this.wasFiltered) {
                    return;
                }
                this.wasFiltered = false;
                this.dropdownViewer.setInput((Object)dropdownElements.toArray());
                this.dropdownViewer.setItemCount(dropdownElements.size());
            }
            if (dropdownElements == null) {
                return;
            }
            VHBCDropDownLabelProvider dropDownLabelProvider = (VHBCDropDownLabelProvider)this.vhBreadcrumbViewer.getDropDownLabelProvider();
            this.wasFiltered = true;
            StringMatcher localMatcher = ViewsUtils.createCamelCaseOrRegexMatcher(text, true, false);
            ArrayList<IDVTElementWrapper> filteredList = new ArrayList<IDVTElementWrapper>();
            for (IDVTElementWrapper element : dropdownElements) {
                if (!ViewsUtils.matchCamelCaseOrRegex(localMatcher, dropDownLabelProvider.getText(element))) continue;
                filteredList.add(element);
            }
            this.elements = filteredList.toArray();
            this.dropdownViewer.setInput((Object)filteredList.toArray());
            this.dropdownViewer.setItemCount(filteredList.size());
        }
        catch (Throwable t) {
            DVTLogger.INSTANCE.logError(t);
        }
    }
}

