/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.vhbreadcrumb;

import java.util.List;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;

public class VHBreadcrumbInstancePath {
    private IRfVHBreadcrumbElement top;
    private List<IRfVHBreadcrumbElement> paths;

    public VHBreadcrumbInstancePath(List<IRfVHBreadcrumbElement> resultPath, IRfVHBreadcrumbElement namedElement) {
        this.top = namedElement;
        this.paths = resultPath;
    }

    public IRfVHBreadcrumbElement getLeaf() {
        if (this.paths.isEmpty()) {
            return null;
        }
        return this.paths.get(this.paths.size() - 1);
    }

    public IRfVHBreadcrumbElement getTop() {
        return this.top;
    }

    public List<IRfVHBreadcrumbElement> getPath() {
        return this.paths;
    }

    public ElementPath getInstancePath() {
        ElementPath path = ElementPath.EMPTY_PATH;
        path = ElementPath.join(path, this.top instanceof IXXVMComponent ? BreadcrumbInput.getXXVMName((IXXVMComponent)this.top) : this.top.getName());
        for (IRfVHBreadcrumbElement instance : this.paths) {
            path = ElementPath.join(path, instance.getName());
        }
        return path;
    }

    public String getFullName() {
        if (this.paths == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.top.getName()).append(".");
        for (IRfVHBreadcrumbElement element : this.paths) {
            sb.append(element.getName()).append(".");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public String toString() {
        return this.getFullName();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.paths == null ? 0 : this.paths.hashCode());
        result = 31 * result + (this.top == null ? 0 : this.top.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VHBreadcrumbInstancePath)) {
            return false;
        }
        return this.getFullName().equals(((VHBreadcrumbInstancePath)obj).getFullName());
    }

    public IRfNamedElement getInstance() {
        if (this.paths.isEmpty()) {
            return this.top.getNamedElement();
        }
        return this.paths.get(this.paths.size() - 1).getNamedElement();
    }
}

