/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.vhbreadcrumb;

import java.util.List;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.BCDropDownContentProvider;
import ro.amiq.dvt.ui.editor.breadcrumb.BCDropDownTableViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbItemDropdown;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBCLazyDropDownContentProvider;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;

public class VHBreadcrumbItemDropDown
extends ThickBreadcrumbItemDropdown {
    private List<IDVTElementWrapper> fDropdownElements;

    public VHBreadcrumbItemDropDown(AbstractBreadcrumbItem parent, Composite composite) {
        super(parent, composite);
    }

    @Override
    protected void internalShowMenu() {
        Composite menuComposite = this.createMenuComposite();
        this.fDropDownViewer = new BCDropDownTableViewer(this, menuComposite, 268436228);
        this.fDropDownViewer.setUseHashlookup(true);
        Table table = (Table)this.fDropDownViewer.getControl();
        this.setDropDownViewerData((Composite)table);
        this.fDropdownElements = this.fParent.getDropDownElements();
        this.addListenersAndFilter((Composite)table);
        this.addTableListeners(table);
        int index = this.fParent.getViewer().getIndexOfItem(this.fParent);
        if (index < this.fParent.getViewer().getItemCount() - 1) {
            AbstractBreadcrumbItem childItem = this.fParent.getViewer().getItem(index + 1);
            Object child = childItem.getData();
            int childIndexInDropdown = this.fDropdownElements.indexOf(child);
            table.setSelection(childIndexInDropdown);
            table.setTopIndex(childIndexInDropdown);
        }
        this.fShell.setVisible(true);
        this.installCloser(this.fShell);
    }

    @Override
    public void setDropDownViewerData(Composite dropDownViewer) {
        super.setDropDownViewerData(dropDownViewer);
        this.updateDropDownViewer("");
        this.setShellBounds(this.fShell);
    }

    @Override
    public Composite getDropDownViewerComposite() {
        if (!(this.fDropDownViewer instanceof TableViewer)) {
            return null;
        }
        return ((TableViewer)this.fDropDownViewer).getTable();
    }

    @Override
    public void setShellBounds(Shell shell) {
        Rectangle rect = this.fParentComposite.getBounds();
        Rectangle toolbarBounds = this.fToolBar.getBounds();
        shell.pack();
        Point size = shell.getSize();
        int height = Math.max(Math.min(size.y, this.getMaxHeight()), 200);
        int width = Math.max(Math.min(size.x, 500), 250);
        int imageBoundsX = 0;
        if (((TableViewer)this.fDropDownViewer).getTable().getItemCount() > 0) {
            TableItem item = ((TableViewer)this.fDropDownViewer).getTable().getItem(0);
            imageBoundsX = item.getImageBounds((int)0).x;
        }
        Rectangle trim = this.fShell.computeTrim(0, 0, width, height);
        int x = toolbarBounds.x + toolbarBounds.width + 2 + trim.x - imageBoundsX;
        if (!this.isLTR()) {
            x += width;
        }
        Point pt = new Point(x, rect.y + rect.height);
        pt = this.fParentComposite.toDisplay(pt);
        Rectangle monitor = VHBreadcrumbItemDropDown.getClosestMonitor(shell.getDisplay(), pt).getClientArea();
        int overlap = pt.x + width - (monitor.x + monitor.width);
        if (overlap > 0) {
            pt.x -= overlap;
        }
        if (pt.x < monitor.x) {
            pt.x = monitor.x;
        }
        shell.setLocation(pt);
        shell.setSize(width, height);
    }

    @Override
    public void updateDropDownViewer(String searchText) {
        if (this.fDropDownViewer == null) {
            return;
        }
        IContentProvider contentProvider = this.fDropDownViewer.getContentProvider();
        if (!(contentProvider instanceof BCDropDownContentProvider)) {
            return;
        }
        ((VHBCLazyDropDownContentProvider)contentProvider).filterInput(searchText, this.fDropdownElements);
        Table table = ((TableViewer)this.fDropDownViewer).getTable();
        if (table == null) {
            return;
        }
        this.refreshDropDownViewer((Composite)table);
        if (table.getItemCount() == 0) {
            return;
        }
        TableItem item = table.getItem(0);
        table.setSelection(item);
    }

    @Override
    protected void clearObjection() {
        ObjectionManager.getInstance().clear(Objection.VERIFICATION_BC);
    }
}

