/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.vhbreadcrumb;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.diagrams.editor.DDiagramEditor;
import ro.amiq.dvt.diagrams.editor.DDiagramEditorInput;
import ro.amiq.dvt.model.reflection.DVTRfUtils;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfFileDef;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.SimpleDVTNotification;
import ro.amiq.dvt.ui.editor.DVTEditor;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbConfiguration;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbInstancePath;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbInstancePathsResult;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtilsCommon;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbViewer;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.IVHLabelProvider;

public abstract class VHBreadcrumbUtils
extends VHBreadcrumbUtilsCommon {
    private static final String BC_NOTIFICATION_MULTIPLE_VERIFICATION_ELEMENTS = "BC_NOTIFICATION_MULTIPLE_VERIFICATION_ELEMENTS";
    private static final String BC_NOTIFICATION_MULTIPLE_INSTANCES = "BC_NOTIFICATION_MULTIPLE_INSTANCES";

    @Override
    public BreadcrumbInput computeBreadcrumbInput(IDVTBreadcrumbHost editor, AbstractBreadcrumbConfiguration configuration, boolean enabled) {
        try {
            boolean hasVerificationElements = this.checkClassesInFile(editor);
            if (!hasVerificationElements) {
                return BreadcrumbInput.REMOVE_BREADCRUMB;
            }
            BreadcrumbInput inputFromMeta = this.getInputFromViewMeta(editor);
            if (inputFromMeta != null && inputFromMeta.getInputSegments() != null) {
                editor.setBCCache(inputFromMeta, VHBreadcrumbViewer.class);
                return inputFromMeta;
            }
            BreadcrumbInput inputFromCache = this.getInputFromCache(editor);
            if (inputFromCache != null) {
                editor.setBCCache(inputFromCache, VHBreadcrumbViewer.class);
                return inputFromCache;
            }
            BreadcrumbInput preservedInput = this.getPreservedInput(editor);
            if (preservedInput != null && preservedInput.getInputSegments() != null) {
                editor.setBCCache(preservedInput, VHBreadcrumbViewer.class);
                return preservedInput;
            }
            BreadcrumbInput inputFromFile = this.getInputFromFile(editor, enabled);
            if (inputFromFile != null) {
                editor.setBCCache(inputFromFile, VHBreadcrumbViewer.class);
                return inputFromFile;
            }
            return null;
        }
        catch (Throwable e) {
            DVTLogger.INSTANCE.logError(e);
            return null;
        }
    }

    @Override
    protected BreadcrumbInput getInputFromFile(IDVTBreadcrumbHost editor, boolean enabled) {
        List<IRfBreadcrumbElement> vClassesInFile = this.getVClassesInFile(editor, 2);
        if (vClassesInFile == null || vClassesInFile.isEmpty()) {
            return BreadcrumbInput.REMOVE_BREADCRUMB;
        }
        IRfBreadcrumbElement displayedClass = vClassesInFile.get(0);
        if (!(displayedClass instanceof IRfVHBreadcrumbElement)) {
            return null;
        }
        VHBreadcrumbInstancePathsResult result = this.computeVHBreadcrumbInstancePaths(null, (IRfVHBreadcrumbElement)displayedClass, 2, (IProgressMonitor)new NullProgressMonitor());
        if (result == null || result.isEmpty()) {
            return null;
        }
        AbstractBreadcrumbViewer breadcrumbViewer = editor.getBreadcrumbViewer(VHBreadcrumbViewer.class);
        if (!(breadcrumbViewer instanceof VHBreadcrumbViewer)) {
            return null;
        }
        VHBreadcrumbInstancePath displayedInstance = result.instancePaths.get(0);
        BreadcrumbInput inputFromFile = VHBreadcrumbUtils.toBreadcrumbInput(editor.getProject(), displayedInstance, editor.getBreadcrumbUtils(VHBreadcrumbViewer.class));
        if (!((VHBreadcrumbViewer)breadcrumbViewer).getNotificationsVisibility()) {
            return inputFromFile;
        }
        if (vClassesInFile.size() > 1 && enabled) {
            this.createNotification(editor, displayedClass, BC_NOTIFICATION_MULTIPLE_VERIFICATION_ELEMENTS);
        }
        if (result.instancePaths.size() > 1 && enabled) {
            this.createNotification(editor, displayedInstance, BC_NOTIFICATION_MULTIPLE_INSTANCES);
        }
        ((VHBreadcrumbViewer)breadcrumbViewer).setNotificationsVisibility(false);
        return inputFromFile;
    }

    private void createNotification(IDVTBreadcrumbHost editor, Object element, String family) {
        Display.getDefault().asyncExec(() -> {
            if (editor == null) {
                return;
            }
            if (BC_NOTIFICATION_MULTIPLE_VERIFICATION_ELEMENTS.equals(family)) {
                this.createMultipleVerificationElemNotification(editor, element);
                return;
            }
            if (BC_NOTIFICATION_MULTIPLE_INSTANCES.equals(family)) {
                this.createMultipleInstancesNotification(editor, element);
            }
        });
    }

    private void createMultipleVerificationElemNotification(IDVTBreadcrumbHost editor, Object element) {
        if (!(element instanceof IRfBreadcrumbElement)) {
            return;
        }
        IRfBreadcrumbElement displayedClass = (IRfBreadcrumbElement)element;
        String displayedClassName = displayedClass.getName();
        if (displayedClassName == null || displayedClassName.isEmpty()) {
            return;
        }
        String unitOrComponentLabel = this.getUnitOrComponentLabel();
        if (unitOrComponentLabel == null || unitOrComponentLabel.isEmpty()) {
            return;
        }
        new SimpleDVTNotification(editor, 256, BC_NOTIFICATION_MULTIPLE_VERIFICATION_ELEMENTS).setText("There are several " + unitOrComponentLabel + " declared in this file. Showing breadcrumb for '" + displayedClassName + "'").setShowPreferenceKey("show.breadcrumb.notifications").create();
    }

    private void createMultipleInstancesNotification(IDVTBreadcrumbHost editor, Object element) {
        if (!(element instanceof VHBreadcrumbInstancePath)) {
            return;
        }
        VHBreadcrumbInstancePath displayedInstance = (VHBreadcrumbInstancePath)element;
        String vElementName = this.getVElementName(displayedInstance.getLeaf());
        if (vElementName == null || vElementName.isEmpty()) {
            return;
        }
        new SimpleDVTNotification(editor, 256, BC_NOTIFICATION_MULTIPLE_INSTANCES).setText("There are multiple instances of '" + vElementName + "'. Use 'Select Instance' button to change.").setShowPreferenceKey("show.breadcrumb.notifications").create();
    }

    @Override
    protected BreadcrumbInput getInputFromCache(IDVTBreadcrumbHost editor) {
        BreadcrumbInput bcCache = editor.getBCCache(VHBreadcrumbViewer.class);
        if (bcCache == null) {
            return null;
        }
        List<BreadcrumbSegment> inputSegments = bcCache.getInputSegments();
        if (inputSegments == null) {
            return null;
        }
        return new BreadcrumbInput(editor.getProject(), inputSegments, editor.getBreadcrumbUtils(VHBreadcrumbViewer.class).getBreadcrumbSerializer());
    }

    private BreadcrumbInput getInputFromViewMeta(IDVTBreadcrumbHost editor) throws CoreException {
        if (editor instanceof DVTEditor) {
            IFile currentFile = (IFile)editor.getEditorInput().getAdapter(IFile.class);
            if (currentFile == null) {
                return null;
            }
            BreadcrumbInput result = (BreadcrumbInput)currentFile.getSessionProperty(IDVTConstants.VH_BREADCRUMB_QN);
            currentFile.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, null);
            return result;
        }
        if (editor instanceof DDiagramEditor) {
            DDiagramEditorInput editorInput = ((DDiagramEditor)editor).getInput();
            if (editorInput == null) {
                return null;
            }
            IResource adapter = (IResource)editorInput.getAdapter(IResource.class);
            if (adapter == null) {
                return null;
            }
            BreadcrumbInput result = (BreadcrumbInput)adapter.getSessionProperty(IDVTConstants.VH_BREADCRUMB_QN);
            adapter.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, null);
            return result;
        }
        return null;
    }

    public void openFieldDeclaration(IRfVHBreadcrumbElement element, BreadcrumbInput bcInput) throws CoreException {
        IResource file = this.getTargetFile(element);
        if (file == null) {
            return;
        }
        file.setSessionProperty(IDVTConstants.VH_BREADCRUMB_QN, (Object)bcInput);
        IRfNamedElement namedElement = element.getNamedElement();
        DVTRfUtils.goToDeclaration(namedElement, true);
    }

    protected IResource getTargetFile(IRfVHBreadcrumbElement element) {
        IRfDefElement declaration = this.getDeclaration(element);
        if (declaration == null) {
            return null;
        }
        IRfFileDef defFile = declaration.getDefFile();
        if (defFile == null) {
            return null;
        }
        return (IResource)defFile.getAdapter(IResource.class);
    }

    public void setPathForWrapper(IDVTElementWrapper wrapper, List<BreadcrumbSegment> segments) {
        IProject project = wrapper.getProject();
        if (project == null) {
            return;
        }
        IDVTElementWrapper preElementWrapper = wrapper;
        int i = segments.size() - 2;
        while (i >= 0) {
            BreadcrumbSegment breadcrumbSegment = segments.get(i);
            IRfBreadcrumbElement element = breadcrumbSegment.getElement();
            if (!(element instanceof IRfVHBreadcrumbElement)) {
                return;
            }
            IDVTElementWrapper elementWrapper = this.createElementWrapper(project, (IRfVHBreadcrumbElement)element);
            preElementWrapper.setParent(elementWrapper);
            elementWrapper.addChild(preElementWrapper);
            preElementWrapper = elementWrapper;
            --i;
        }
        this.setDummyParent(preElementWrapper);
    }

    public String getCHGText(IRfVHBreadcrumbElement element) {
        return "";
    }

    public IVHLabelProvider getXxvmLabelProvider() {
        return null;
    }

    public String getXXVMText(IRfVHBreadcrumbElement element) {
        return "";
    }

    public Image getCHGDiagramImage(CHUVMComponent element, boolean forceComponent) {
        return null;
    }

    protected abstract BreadcrumbInput getPreservedInput(IDVTBreadcrumbHost var1);

    public void initXVM(IProject project) {
    }
}

