/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.ui.editor.vhbreadcrumb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.WorkbenchPart;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.diagrams.ch.model.CHUVMComponent;
import ro.amiq.dvt.interpreter.IXXVMComponent;
import ro.amiq.dvt.model.DVTMixedLangModelManager;
import ro.amiq.dvt.model.IXvmFactoryInitListener;
import ro.amiq.dvt.model.reflection.ElementPath;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IRfBreadcrumbElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfVHBreadcrumbElement;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;
import ro.amiq.dvt.test.Objection;
import ro.amiq.dvt.test.ObjectionManager;
import ro.amiq.dvt.test.TestHelper;
import ro.amiq.dvt.ui.DVTImages;
import ro.amiq.dvt.ui.actions.IMenuCommandDelegate;
import ro.amiq.dvt.ui.actions.MenuCommandDelegatesManager;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbItem;
import ro.amiq.dvt.ui.editor.breadcrumb.AbstractBreadcrumbUtils;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbInput;
import ro.amiq.dvt.ui.editor.breadcrumb.BreadcrumbSegment;
import ro.amiq.dvt.ui.editor.breadcrumb.IDVTBreadcrumbHost;
import ro.amiq.dvt.ui.editor.breadcrumb.SelectOtherVHInstanceDialog;
import ro.amiq.dvt.ui.editor.breadcrumb.ThickBreadcrumbViewer;
import ro.amiq.dvt.ui.editor.breadcrumb.VHBreadcrumbItem;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBCDropDownLabelProvider;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBCInputContentProvider;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBCInputLabelProvider;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBCLazyDropDownContentProvider;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBCToolTipProvider;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbInstancePathsResult;
import ro.amiq.dvt.ui.editor.vhbreadcrumb.VHBreadcrumbUtils;
import ro.amiq.dvt.ui.views.IDVTElementWrapper;
import ro.amiq.dvt.utils.DVTDocumentCommon;
import ro.amiq.dvt.utils.Utils;

public class VHBreadcrumbViewer
extends ThickBreadcrumbViewer
implements IXvmFactoryInitListener {
    public static final String ID = "ro.amiq.dvt.ui.editor.breadcrumb.VHBreadcrumbViewer";
    private static boolean isReadOnly;
    private IRfVHBreadcrumbElement elementCache;
    private IDVTElementWrapper vhElementWrapperCache;
    private IRfVHBreadcrumbElement elementToSendFromDropDown;
    private Composite errorNoVerificationElementsInFileComposite;
    private StyledText noVElements;
    private Menu testContextMenu;
    private SelectionListener openFieldSelectionListener;
    private SelectionListener openCreateSelectionListener;
    private SelectionListener copyHierarchyPathListener;

    public VHBreadcrumbViewer(IDVTBreadcrumbHost editor, Composite topContainer) {
        super(editor, topContainer);
        DVTMixedLangModelManager.getInstance().addXvmFactoryInitListeners(this);
    }

    public void updateXVMFactory() {
        AbstractBreadcrumbUtils utils = this.getUtils();
        if (utils instanceof VHBreadcrumbUtils) {
            ((VHBreadcrumbUtils)utils).initXVM(this.getProject());
        }
    }

    @Override
    public void createBreadcrumbSWTComponents(Composite topContainer) {
        super.createBreadcrumbSWTComponents(topContainer);
        this.errorNoVerificationElementsInFileComposite = new Composite(this.fStackComposite, 0);
        GridDataFactory.fillDefaults().align(4, 128).grab(true, false).applyTo((Control)this.errorNoVerificationElementsInFileComposite);
        GridLayoutFactory.fillDefaults().applyTo(this.errorNoVerificationElementsInFileComposite);
        this.noVElements = new StyledText(this.errorNoVerificationElementsInFileComposite, 0x1000040);
        this.noVElements.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 1, 1));
        this.selectOtherInstanceButton = new Button(this.fBreadcrumbHostComposite, 8);
        this.selectOtherInstanceButton.setToolTipText("Select Instance");
        this.selectOtherInstanceButton.setImage(DVTImages.imageCache.getImage(DVTImages.DESIGN_HIERARCHY));
        this.selectOtherInstanceButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.selectOtherInstanceButton.setEnabled(false);
        this.selectOtherInstanceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int instanceIndex = e.data instanceof Integer ? (Integer)e.data : -1;
                IWorkbench workbench = PlatformUI.getWorkbench();
                Display d = workbench.getDisplay();
                Runnable runnable = () -> {
                    VHBreadcrumbViewer.this.soiDialog = new SelectOtherVHInstanceDialog(VHBreadcrumbViewer.this.fActiveEditor);
                    VHBreadcrumbViewer.this.soiDialog.open(instanceIndex);
                };
                if (instanceIndex != -1 && TestHelper.isTestMode()) {
                    d.syncExec(runnable);
                } else {
                    d.asyncExec(runnable);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    @Override
    public void createBreadcrumbDropDownProviders() {
        this.fDropDownLabelProvider = new VHBCDropDownLabelProvider(this.fActiveEditor);
    }

    @Override
    public void createBreadcrumbInputProviders() {
        this.fInputContentProvider = new VHBCInputContentProvider(this);
        this.fInputLabelProvider = new VHBCInputLabelProvider(this, this.fActiveEditor);
        this.fInputTooltipProvider = new VHBCToolTipProvider(this, this.fActiveEditor);
    }

    @Override
    public void createListeners() {
        super.createListeners();
        this.fContextMenuListener = new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                Menu contextMenu;
                ISelection selection = VHBreadcrumbViewer.this.getSelection();
                if (!(selection instanceof IStructuredSelection)) {
                    return;
                }
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (!(element instanceof IRfVHBreadcrumbElement)) {
                    return;
                }
                AbstractBreadcrumbUtils breadcrumbUtils = VHBreadcrumbViewer.this.fActiveEditor.getBreadcrumbUtils(VHBreadcrumbViewer.class);
                if (!(breadcrumbUtils instanceof VHBreadcrumbUtils)) {
                    return;
                }
                VHBreadcrumbViewer.this.testContextMenu = contextMenu = new Menu((Control)VHBreadcrumbViewer.this.getContainer());
                VHBreadcrumbViewer.this.addOpenCreateMenuItem(false, (IRfVHBreadcrumbElement)element, contextMenu, (VHBreadcrumbUtils)breadcrumbUtils);
                VHBreadcrumbViewer.this.addOpenFieldDeclarationMenuItem(false, (IRfVHBreadcrumbElement)element, contextMenu, (VHBreadcrumbUtils)breadcrumbUtils);
                this.addShowDiagramMenuItem((IRfVHBreadcrumbElement)element, contextMenu, (VHBreadcrumbUtils)breadcrumbUtils);
                new MenuItem(contextMenu, 2);
                this.addCopyHierarcyPathMenuItem((IRfVHBreadcrumbElement)element, contextMenu);
                contextMenu.setLocation(e.x, e.y);
                contextMenu.setVisible(true);
            }

            private void addShowDiagramMenuItem(final IRfVHBreadcrumbElement element, Menu contextMenu, final VHBreadcrumbUtils breadcrumbUtils) {
                MenuItem mi = new MenuItem(contextMenu, 0);
                mi.setText("Show Diagram");
                mi.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        if (element instanceof CHUVMComponent) {
                            this.openCHGDiagram(element, breadcrumbUtils);
                            return;
                        }
                        IDVTElementWrapper wrapper = VHBreadcrumbViewer.this.getCachedElementWrapper(element);
                        IMenuCommandDelegate delegate = MenuCommandDelegatesManager.getCommandDelegate(wrapper);
                        if (delegate != null) {
                            delegate.showDiagram(wrapper, VHBreadcrumbViewer.ID);
                        }
                    }

                    private void openCHGDiagram(IRfVHBreadcrumbElement element2, VHBreadcrumbUtils breadcrumbUtils2) {
                        if (VHBreadcrumbViewer.this.fBreadcrumbInput == null) {
                            return;
                        }
                        List<BreadcrumbSegment> subList = VHBreadcrumbViewer.this.getInputUntilElement(element2, true);
                        if (subList == null) {
                            return;
                        }
                        IDVTBreadcrumbHost editor = VHBreadcrumbViewer.this.getEditor();
                        BreadcrumbInput bcInput = new BreadcrumbInput(editor.getProject(), subList, breadcrumbUtils2.getBreadcrumbSerializer());
                        breadcrumbUtils2.openElement(editor, VHBreadcrumbViewer.this.getProject(), element2, bcInput);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                });
            }

            private void addCopyHierarcyPathMenuItem(final IRfVHBreadcrumbElement namedElement, Menu contextMenu) {
                MenuItem mi = new MenuItem(contextMenu, 0);
                mi.setText("Copy Hierarchy Path");
                VHBreadcrumbViewer.this.copyHierarchyPathListener = new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        String lineDelimiter = DVTDocumentCommon.getLineDelimiterByProject(VHBreadcrumbViewer.this.getEditor().getProject());
                        ElementPath path = VHBreadcrumbViewer.this.fBreadcrumbInput.getElementPathUpTo(namedElement);
                        String pathDelim = DVTPlugin.getDefault().getPreferenceStore().getString("copyHierarchyPathSegmentSeparator");
                        String fullPath = String.valueOf(path.toString(pathDelim)) + lineDelimiter;
                        Utils.copyToClipboard(fullPath.trim(), 3);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        this.widgetSelected(e);
                    }
                };
                mi.addSelectionListener(VHBreadcrumbViewer.this.copyHierarchyPathListener);
            }
        };
        this.fElementClickListener = e -> {
            Object eventSource = e.getSource();
            if (!(eventSource instanceof VHBreadcrumbViewer)) {
                return;
            }
            Object vhBCElement = ((IStructuredSelection)e.getSelection()).getFirstElement();
            if (!(vhBCElement instanceof IRfVHBreadcrumbElement)) {
                return;
            }
            if (this.fBreadcrumbInput == null) {
                return;
            }
            List<BreadcrumbSegment> subList = this.getInputUntilElement((IRfVHBreadcrumbElement)vhBCElement, true);
            if (subList == null) {
                return;
            }
            VHBreadcrumbViewer breadcrumbViewer = (VHBreadcrumbViewer)eventSource;
            IDVTBreadcrumbHost editor = breadcrumbViewer.getEditor();
            AbstractBreadcrumbUtils vhBreadcrumbUtils = editor.getBreadcrumbUtils(VHBreadcrumbViewer.class);
            if (!(vhBreadcrumbUtils instanceof VHBreadcrumbUtils)) {
                return;
            }
            ((VHBreadcrumbUtils)vhBreadcrumbUtils).openElement(editor, editor.getProject(), (IRfVHBreadcrumbElement)vhBCElement, new BreadcrumbInput(this.fActiveEditor.getProject(), subList, vhBreadcrumbUtils.getBreadcrumbSerializer()));
        };
        this.fOpenFromDropDownListener = e -> {
            List<BreadcrumbSegment> inputSegments;
            Object eventSource = e.getSource();
            if (!(eventSource instanceof VHBreadcrumbViewer)) {
                return;
            }
            ISelection selection = e.getSelection();
            if (!(selection instanceof StructuredSelection)) {
                return;
            }
            Object selectedElement = ((StructuredSelection)selection).getFirstElement();
            if (!(selectedElement instanceof IDVTElementWrapper)) {
                return;
            }
            IDVTElementWrapper selectedWrapper = (IDVTElementWrapper)selectedElement;
            IRfVHBreadcrumbElement clickedElement = (IRfVHBreadcrumbElement)selectedWrapper.getRfElement();
            if (clickedElement == null) {
                return;
            }
            VHBreadcrumbViewer breadcrumbViewer = (VHBreadcrumbViewer)eventSource;
            IDVTBreadcrumbHost editor = breadcrumbViewer.getEditor();
            AbstractBreadcrumbUtils vhBreadcrumbUtils = editor.getBreadcrumbUtils(VHBreadcrumbViewer.class);
            if (!(vhBreadcrumbUtils instanceof VHBreadcrumbUtils)) {
                return;
            }
            int indexOfSelectedElement = this.fBreadcrumbInput.indexOfSegment(this.elementToSendFromDropDown);
            if (indexOfSelectedElement < 0) {
                return;
            }
            if (clickedElement instanceof IRfNamedElement) {
                clickedElement = (IRfVHBreadcrumbElement)((Object)((IRfNamedElement)((Object)clickedElement)).getDeclaration());
            }
            ArrayList<Object> subListSegments = (inputSegments = this.fBreadcrumbInput.getInputSegments()) == null ? new ArrayList() : new ArrayList<BreadcrumbSegment>(inputSegments.subList(0, indexOfSelectedElement + 1));
            if (!((VHBreadcrumbUtils)vhBreadcrumbUtils).isInsideMacro(clickedElement)) {
                subListSegments.add(new BreadcrumbSegment(clickedElement));
            }
            ((VHBreadcrumbUtils)vhBreadcrumbUtils).openElement(editor, editor.getProject(), clickedElement, new BreadcrumbInput(this.fActiveEditor.getProject(), subListSegments, vhBreadcrumbUtils.getBreadcrumbSerializer()));
            ObjectionManager.getInstance().clear(Objection.VERIFICATION_BC);
        };
    }

    private void addOpenCreateMenuItem(final boolean fromDD, final IRfVHBreadcrumbElement element, Menu contextMenu, final VHBreadcrumbUtils breadcrumbUtils) {
        GoToInfo instanceMarker;
        if (!breadcrumbUtils.shouldOpenCreate()) {
            return;
        }
        if (this.fBreadcrumbInput.isRoot(element, false)) {
            return;
        }
        if (element instanceof IXXVMComponent && (instanceMarker = ((IXXVMComponent)element).getCreateCallGoToInfo()) == null) {
            return;
        }
        if (element instanceof CHUVMComponent && (instanceMarker = ((CHUVMComponent)element).getInstanceMarker()) == null) {
            return;
        }
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText("Open Create Call");
        this.openCreateSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                List<BreadcrumbSegment> inputUntilElement = fromDD ? VHBreadcrumbViewer.this.getInputUntilElement(VHBreadcrumbViewer.this.elementToSendFromDropDown, true) : VHBreadcrumbViewer.this.getInputUntilElement(element, false);
                if (inputUntilElement == null) {
                    return;
                }
                IProject project = VHBreadcrumbViewer.this.getEditor().getProject();
                breadcrumbUtils.openCreate(project, element, new BreadcrumbInput(project, inputUntilElement, breadcrumbUtils.getBreadcrumbSerializer()));
                if (fromDD) {
                    VHBreadcrumbViewer.this.closeDropDown();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        mi.addSelectionListener(this.openCreateSelectionListener);
    }

    private void addOpenFieldDeclarationMenuItem(final boolean fromDD, final IRfVHBreadcrumbElement element, Menu contextMenu, final VHBreadcrumbUtils breadcrumbUtils) {
        if (element instanceof CHUVMComponent) {
            return;
        }
        if (this.fBreadcrumbInput.isRoot(element, false)) {
            return;
        }
        if (this.isXVVMArray(element)) {
            return;
        }
        MenuItem mi = new MenuItem(contextMenu, 0);
        mi.setText("Open Field Declaration");
        this.openFieldSelectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    List<BreadcrumbSegment> inputUntilElement = null;
                    inputUntilElement = fromDD ? VHBreadcrumbViewer.this.getInputUntilElement(VHBreadcrumbViewer.this.elementToSendFromDropDown, true) : VHBreadcrumbViewer.this.getInputUntilElement(element, false);
                    if (inputUntilElement == null) {
                        return;
                    }
                    breadcrumbUtils.openFieldDeclaration(element, new BreadcrumbInput(VHBreadcrumbViewer.this.getEditor().getProject(), inputUntilElement, breadcrumbUtils.getBreadcrumbSerializer()));
                    if (fromDD) {
                        VHBreadcrumbViewer.this.closeDropDown();
                    }
                    ObjectionManager.getInstance().clear(Objection.VERIFICATION_BC);
                }
                catch (CoreException e1) {
                    DVTLogger.INSTANCE.logError(e1.getMessage());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        mi.addSelectionListener(this.openFieldSelectionListener);
    }

    private boolean isXVVMArray(IRfVHBreadcrumbElement element) {
        if (!(element instanceof IXXVMComponent)) {
            return false;
        }
        return ((IXXVMComponent)element).getNamedElement() == null;
    }

    private void closeDropDown() {
        List<AbstractBreadcrumbItem> items = this.getItems();
        for (AbstractBreadcrumbItem item : items) {
            if (!item.isMenuShown()) continue;
            item.closeDropDownMenu();
            return;
        }
    }

    private List<BreadcrumbSegment> getInputUntilElement(IRfBreadcrumbElement element, boolean includeSelf) {
        int indexOfSelectedElement = this.fBreadcrumbInput.indexOfSegment(element);
        if (indexOfSelectedElement < 0) {
            return null;
        }
        List<BreadcrumbSegment> inputSegments = this.fBreadcrumbInput.getInputSegments();
        if (inputSegments == null) {
            return null;
        }
        if (includeSelf) {
            ++indexOfSelectedElement;
        }
        List<BreadcrumbSegment> subList = inputSegments.subList(0, indexOfSelectedElement);
        return subList;
    }

    @Override
    public void setBackgroundImageForErrorComposites(Image image) {
    }

    private void setElementToSendFromDropDown(IRfBreadcrumbElement inputElement) {
        if (!(inputElement instanceof IRfVHBreadcrumbElement)) {
            return;
        }
        this.elementToSendFromDropDown = (IRfVHBreadcrumbElement)inputElement;
    }

    @Override
    public void configureDropDownViewer(ColumnViewer viewer, Object input) {
        if (!(viewer instanceof TableViewer) || !(input instanceof IRfVHBreadcrumbElement)) {
            return;
        }
        ((TableViewer)viewer).getTable().addMenuDetectListener(e -> {
            ISelection selection = viewer.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (!(element instanceof IDVTElementWrapper)) {
                return;
            }
            Object ddElement = ((IDVTElementWrapper)element).getRfElement();
            if (!(ddElement instanceof IRfVHBreadcrumbElement)) {
                return;
            }
            AbstractBreadcrumbUtils breadcrumbUtils = this.getEditor().getBreadcrumbUtils(VHBreadcrumbViewer.class);
            if (!(breadcrumbUtils instanceof VHBreadcrumbUtils)) {
                return;
            }
            Menu dropDownMenu = new Menu((Control)this.fBreadcrumbHostComposite);
            this.addOpenCreateMenuItem(true, (IRfVHBreadcrumbElement)ddElement, dropDownMenu, (VHBreadcrumbUtils)breadcrumbUtils);
            this.addOpenFieldDeclarationMenuItem(true, (IRfVHBreadcrumbElement)ddElement, dropDownMenu, (VHBreadcrumbUtils)breadcrumbUtils);
            dropDownMenu.setLocation(e.x, e.y);
            dropDownMenu.setVisible(true);
        });
        this.fDropDownContentProvider = new VHBCLazyDropDownContentProvider((TableViewer)viewer, this);
        viewer.setContentProvider(this.fDropDownContentProvider);
        viewer.setUseHashlookup(true);
        if (this.fDropdownElements == null) {
            return;
        }
        viewer.setInput((Object)this.fDropdownElements.toArray());
        ((TableViewer)viewer).setItemCount(this.fDropdownElements.size());
        viewer.setLabelProvider((IBaseLabelProvider)this.fDropDownLabelProvider);
        this.setElementToSendFromDropDown((IRfVHBreadcrumbElement)input);
    }

    @Override
    public void computeDropdownElements(Object input) {
        this.fDropdownElements = null;
        if (!(input instanceof IRfVHBreadcrumbElement)) {
            return;
        }
        AbstractBreadcrumbUtils breadcrumbUtils = this.fActiveEditor.getBreadcrumbUtils(VHBreadcrumbViewer.class);
        if (!(breadcrumbUtils instanceof VHBreadcrumbUtils)) {
            this.fDropdownElements = Collections.emptyList();
            return;
        }
        IDVTElementWrapper menuWrapper = ((VHBreadcrumbUtils)breadcrumbUtils).createElementWrapper(this.fActiveEditor.getProject(), (IRfVHBreadcrumbElement)input);
        if (menuWrapper == null) {
            return;
        }
        this.fDropdownElements = menuWrapper.getAllChildren();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IDVTElementWrapper getCachedElementWrapper(IRfVHBreadcrumbElement vhBCElement) {
        AbstractBreadcrumbUtils breadcrumbUtils;
        block6: {
            try {
                boolean outdated;
                if (vhBCElement == null || this.fActiveEditor == null || this.fActiveEditor.getProject() == null) {
                    return this.vhElementWrapperCache;
                }
                if (vhBCElement.equals(this.elementCache)) {
                    outdated = false;
                } else {
                    outdated = true;
                    this.elementCache = vhBCElement;
                }
                if (!outdated) return this.vhElementWrapperCache;
                breadcrumbUtils = this.fActiveEditor.getBreadcrumbUtils(VHBreadcrumbViewer.class);
                if (breadcrumbUtils instanceof VHBreadcrumbUtils) break block6;
                return null;
            }
            catch (Throwable e) {
                DVTLogger.INSTANCE.logError(e);
                return null;
            }
        }
        this.vhElementWrapperCache = ((VHBreadcrumbUtils)breadcrumbUtils).createElementWrapper(this.fActiveEditor.getProject(), this.elementCache);
        return this.vhElementWrapperCache;
    }

    @Override
    public void scheduleComputeOtherInstancesJob() {
        Job computeInstances = new Job("Verification Breadcrumb: Computing Other Instances for " + this.getActiveEditorName() + "..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    AbstractBreadcrumbUtils breadcrumbUtils = VHBreadcrumbViewer.this.fActiveEditor.getBreadcrumbUtils(VHBreadcrumbViewer.class);
                    if (!(breadcrumbUtils instanceof VHBreadcrumbUtils)) {
                        return Status.CANCEL_STATUS;
                    }
                    if (VHBreadcrumbViewer.this.fBreadcrumbInput == null) {
                        return Status.CANCEL_STATUS;
                    }
                    IRfBreadcrumbElement leafSegment = VHBreadcrumbViewer.this.fBreadcrumbInput.getLeafSegment();
                    if (!(leafSegment instanceof IRfVHBreadcrumbElement)) {
                        return Status.CANCEL_STATUS;
                    }
                    VHBreadcrumbInstancePathsResult result = ((VHBreadcrumbUtils)breadcrumbUtils).computeVHBreadcrumbInstancePaths(VHBreadcrumbViewer.this.fBreadcrumbInput.getRootElement(), (IRfVHBreadcrumbElement)leafSegment, 2, monitor);
                    if (result == null) {
                        return Status.CANCEL_STATUS;
                    }
                    boolean enabled = !result.instancePaths.isEmpty() && result.instancePaths.size() != 1;
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                        if (VHBreadcrumbViewer.this.selectOtherInstanceButton == null || VHBreadcrumbViewer.this.selectOtherInstanceButton.isDisposed()) {
                            return;
                        }
                        VHBreadcrumbViewer.this.selectOtherInstanceButton.setEnabled(enabled);
                        VHBreadcrumbViewer.this.fBreadcrumbHostComposite.layout();
                        VHBreadcrumbViewer.this.fStackComposite.getParent().layout();
                    });
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        computeInstances.setSystem(true);
        computeInstances.schedule();
    }

    @Override
    public void setSelectOtherInstancesButtonEnable(boolean isReadOnly) {
        if (this.selectOtherInstanceButton == null || this.selectOtherInstanceButton.isDisposed()) {
            return;
        }
        this.selectOtherInstanceButton.setEnabled(isReadOnly);
    }

    @Override
    protected int getWidthOfExtraWidgets() {
        return this.selectOtherInstanceButton.getBounds().width;
    }

    @Override
    protected AbstractBreadcrumbItem createItem() {
        return new VHBreadcrumbItem(this, this.getContainer());
    }

    @Override
    protected void filterItem(AbstractBreadcrumbItem item, Object element) {
    }

    @Override
    public void dispose() {
        DVTMixedLangModelManager.getInstance().removeXvmFactoryInitListeners(this);
        super.dispose();
    }

    public void disposeDropDownModel() {
        if (this.fDropdownElements == null) {
            return;
        }
        this.fDropdownElements.clear();
        this.fDropdownElements = null;
    }

    @Override
    protected AbstractBreadcrumbUtils getUtils() {
        if (this.fActiveEditor == null) {
            return null;
        }
        return this.fActiveEditor.getBreadcrumbUtils(VHBreadcrumbViewer.class);
    }

    @Override
    public Button testGetSelectOtherInstanceButton() {
        return this.selectOtherInstanceButton;
    }

    public SelectionListener testGetCopyHierarchyPathListener() {
        return this.copyHierarchyPathListener;
    }

    public IDoubleClickListener testGetElementClickListener() {
        return this.fElementClickListener;
    }

    public IOpenListener testGetClickFromDropDownListener() {
        return this.fOpenFromDropDownListener;
    }

    @Override
    public MenuDetectListener testGetMenuDetectListener() {
        return this.fContextMenuListener;
    }

    public Menu testGetRightClickMenu() {
        return this.testContextMenu;
    }

    public SelectionListener testGetOpenFieldSelectionListener() {
        return this.openFieldSelectionListener;
    }

    public SelectionListener testGetOpenCreateSelectionListener() {
        return this.openCreateSelectionListener;
    }

    @Override
    public boolean isReadOnly() {
        return isReadOnly;
    }

    public static void setReadOnly(boolean readOnlyState) {
        isReadOnly = readOnlyState;
    }

    @Override
    public void setModelReady(boolean isModelReady) {
        VHBreadcrumbViewer.setReadOnly(!isModelReady);
    }

    @Override
    public void postXvmReadyUpdate() {
        if (this.isReadOnly()) {
            return;
        }
        this.setModelReady(true);
        Display.getDefault().asyncExec(() -> {
            if (!(this.fActiveEditor instanceof WorkbenchPart)) {
                return;
            }
            IWorkbenchWindow activeWorkbenchWindow = DVTUiUtils.getActiveWorkbenchWindow();
            if (activeWorkbenchWindow == null) {
                return;
            }
            IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
            if (activePage == null) {
                return;
            }
            if (!activePage.isPartVisible((IWorkbenchPart)this.fActiveEditor)) {
                return;
            }
            this.fActiveEditor.updateBreadcrumb(VHBreadcrumbViewer.class, null);
        });
    }
}

